// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Represents a gateway's local disk.
 */
public class Disk private constructor(builder: Builder) {
    /**
     * The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in the response if the local disk is not defined as an iSCSI target. The format of this field is *targetIqn::LUNNumber::region-volumeId*.
     */
    public val diskAllocationResource: kotlin.String? = builder.diskAllocationResource
    /**
     * One of the `DiskAllocationType` enumeration values that identifies how a local disk is used.
     *
     * Valid Values: `UPLOAD_BUFFER` | `CACHE_STORAGE`
     */
    public val diskAllocationType: kotlin.String? = builder.diskAllocationType
    /**
     * A list of values that represents attributes of a local disk.
     */
    public val diskAttributeList: List<String>? = builder.diskAttributeList
    /**
     * The unique device ID or other distinguishing data that identifies a local disk.
     */
    public val diskId: kotlin.String? = builder.diskId
    /**
     * The device node of a local disk as assigned by the virtualization environment.
     */
    public val diskNode: kotlin.String? = builder.diskNode
    /**
     * The path of a local disk in the gateway virtual machine (VM).
     */
    public val diskPath: kotlin.String? = builder.diskPath
    /**
     * The local disk size in bytes.
     */
    public val diskSizeInBytes: kotlin.Long = builder.diskSizeInBytes
    /**
     * A value that represents the status of a local disk.
     */
    public val diskStatus: kotlin.String? = builder.diskStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.Disk = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Disk(")
        append("diskAllocationResource=$diskAllocationResource,")
        append("diskAllocationType=$diskAllocationType,")
        append("diskAttributeList=$diskAttributeList,")
        append("diskId=$diskId,")
        append("diskNode=$diskNode,")
        append("diskPath=$diskPath,")
        append("diskSizeInBytes=$diskSizeInBytes,")
        append("diskStatus=$diskStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = diskAllocationResource?.hashCode() ?: 0
        result = 31 * result + (diskAllocationType?.hashCode() ?: 0)
        result = 31 * result + (diskAttributeList?.hashCode() ?: 0)
        result = 31 * result + (diskId?.hashCode() ?: 0)
        result = 31 * result + (diskNode?.hashCode() ?: 0)
        result = 31 * result + (diskPath?.hashCode() ?: 0)
        result = 31 * result + (diskSizeInBytes.hashCode())
        result = 31 * result + (diskStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Disk

        if (diskAllocationResource != other.diskAllocationResource) return false
        if (diskAllocationType != other.diskAllocationType) return false
        if (diskAttributeList != other.diskAttributeList) return false
        if (diskId != other.diskId) return false
        if (diskNode != other.diskNode) return false
        if (diskPath != other.diskPath) return false
        if (diskSizeInBytes != other.diskSizeInBytes) return false
        if (diskStatus != other.diskStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.Disk = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The iSCSI qualified name (IQN) that is defined for a disk. This field is not included in the response if the local disk is not defined as an iSCSI target. The format of this field is *targetIqn::LUNNumber::region-volumeId*.
         */
        public var diskAllocationResource: kotlin.String? = null
        /**
         * One of the `DiskAllocationType` enumeration values that identifies how a local disk is used.
         *
         * Valid Values: `UPLOAD_BUFFER` | `CACHE_STORAGE`
         */
        public var diskAllocationType: kotlin.String? = null
        /**
         * A list of values that represents attributes of a local disk.
         */
        public var diskAttributeList: List<String>? = null
        /**
         * The unique device ID or other distinguishing data that identifies a local disk.
         */
        public var diskId: kotlin.String? = null
        /**
         * The device node of a local disk as assigned by the virtualization environment.
         */
        public var diskNode: kotlin.String? = null
        /**
         * The path of a local disk in the gateway virtual machine (VM).
         */
        public var diskPath: kotlin.String? = null
        /**
         * The local disk size in bytes.
         */
        public var diskSizeInBytes: kotlin.Long = 0L
        /**
         * A value that represents the status of a local disk.
         */
        public var diskStatus: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.Disk) : this() {
            this.diskAllocationResource = x.diskAllocationResource
            this.diskAllocationType = x.diskAllocationType
            this.diskAttributeList = x.diskAttributeList
            this.diskId = x.diskId
            this.diskNode = x.diskNode
            this.diskPath = x.diskPath
            this.diskSizeInBytes = x.diskSizeInBytes
            this.diskStatus = x.diskStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.Disk = Disk(this)
    }
}
