// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.storagegateway.model.ListTapesResponse
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.sdk.kotlin.services.storagegateway.model.TapeInfo
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListTapesOperationDeserializer: HttpDeserialize<ListTapesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListTapesResponse {
        if (!response.status.isSuccess()) {
            throwListTapesError(context, response)
        }
        val builder = ListTapesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListTapesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListTapesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTapesOperationBody(builder: ListTapesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val TAPEINFOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TapeInfos"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MARKER_DESCRIPTOR)
        field(TAPEINFOS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                TAPEINFOS_DESCRIPTOR.index -> builder.tapeInfos =
                    deserializer.deserializeList(TAPEINFOS_DESCRIPTOR) {
                        val col0 = mutableListOf<TapeInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTapeInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
