// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.storagegateway.model.DescribeUploadBufferResponse
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeUploadBufferOperationDeserializer: HttpDeserialize<DescribeUploadBufferResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeUploadBufferResponse {
        if (!response.status.isSuccess()) {
            throwDescribeUploadBufferError(context, response)
        }
        val builder = DescribeUploadBufferResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeUploadBufferOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeUploadBufferError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeUploadBufferOperationBody(builder: DescribeUploadBufferResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISKIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DiskIds"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayARN"))
    val UPLOADBUFFERALLOCATEDINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("UploadBufferAllocatedInBytes"))
    val UPLOADBUFFERUSEDINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("UploadBufferUsedInBytes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISKIDS_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
        field(UPLOADBUFFERALLOCATEDINBYTES_DESCRIPTOR)
        field(UPLOADBUFFERUSEDINBYTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISKIDS_DESCRIPTOR.index -> builder.diskIds =
                    deserializer.deserializeList(DISKIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                UPLOADBUFFERALLOCATEDINBYTES_DESCRIPTOR.index -> builder.uploadBufferAllocatedInBytes = deserializeLong()
                UPLOADBUFFERUSEDINBYTES_DESCRIPTOR.index -> builder.uploadBufferUsedInBytes = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
