// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.storagegateway.model.ActiveDirectoryStatus
import aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsResponse
import aws.sdk.kotlin.services.storagegateway.model.SmbLocalGroups
import aws.sdk.kotlin.services.storagegateway.model.SmbSecurityStrategy
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeSMBSettingsOperationDeserializer: HttpDeserialize<DescribeSmbSettingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSmbSettingsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSmbSettingsError(context, response)
        }
        val builder = DescribeSmbSettingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSMBSettingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSmbSettingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSMBSettingsOperationBody(builder: DescribeSmbSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVEDIRECTORYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActiveDirectoryStatus"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val FILESHARESVISIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("FileSharesVisible"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayARN"))
    val SMBGUESTPASSWORDSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SMBGuestPasswordSet"))
    val SMBLOCALGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SMBLocalGroups"))
    val SMBSECURITYSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SMBSecurityStrategy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVEDIRECTORYSTATUS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(FILESHARESVISIBLE_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
        field(SMBGUESTPASSWORDSET_DESCRIPTOR)
        field(SMBLOCALGROUPS_DESCRIPTOR)
        field(SMBSECURITYSTRATEGY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVEDIRECTORYSTATUS_DESCRIPTOR.index -> builder.activeDirectoryStatus = deserializeString().let { ActiveDirectoryStatus.fromValue(it) }
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                FILESHARESVISIBLE_DESCRIPTOR.index -> builder.fileSharesVisible = deserializeBoolean()
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                SMBGUESTPASSWORDSET_DESCRIPTOR.index -> builder.smbGuestPasswordSet = deserializeBoolean()
                SMBLOCALGROUPS_DESCRIPTOR.index -> builder.smbLocalGroups = deserializeSmbLocalGroupsDocument(deserializer)
                SMBSECURITYSTRATEGY_DESCRIPTOR.index -> builder.smbSecurityStrategy = deserializeString().let { SmbSecurityStrategy.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
