// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * JoinDomainInput
 */
public class JoinDomainRequest private constructor(builder: Builder) {
    /**
     * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
     */
    public val domainControllers: List<String>? = builder.domainControllers
    /**
     * The name of the domain that you want the gateway to join.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
     */
    public val organizationalUnit: kotlin.String? = builder.organizationalUnit
    /**
     * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
     */
    public val password: kotlin.String? = builder.password
    /**
     * Specifies the time in seconds, in which the `JoinDomain` operation must complete. The default is 20 seconds.
     */
    public val timeoutInSeconds: kotlin.Int? = builder.timeoutInSeconds
    /**
     * Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user account should be enabled to join computers to the domain. For example, you can use the domain administrator account or an account with delegated permissions to join computers to the domain.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.JoinDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JoinDomainRequest(")
        append("domainControllers=$domainControllers,")
        append("domainName=$domainName,")
        append("gatewayArn=$gatewayArn,")
        append("organizationalUnit=$organizationalUnit,")
        append("password=*** Sensitive Data Redacted ***,")
        append("timeoutInSeconds=$timeoutInSeconds,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainControllers?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnit?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (timeoutInSeconds ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JoinDomainRequest

        if (domainControllers != other.domainControllers) return false
        if (domainName != other.domainName) return false
        if (gatewayArn != other.gatewayArn) return false
        if (organizationalUnit != other.organizationalUnit) return false
        if (password != other.password) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.JoinDomainRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
         */
        public var domainControllers: List<String>? = null
        /**
         * The name of the domain that you want the gateway to join.
         */
        public var domainName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways` operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
         */
        public var organizationalUnit: kotlin.String? = null
        /**
         * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
         */
        public var password: kotlin.String? = null
        /**
         * Specifies the time in seconds, in which the `JoinDomain` operation must complete. The default is 20 seconds.
         */
        public var timeoutInSeconds: kotlin.Int? = null
        /**
         * Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user account should be enabled to join computers to the domain. For example, you can use the domain administrator account or an account with delegated permissions to join computers to the domain.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.JoinDomainRequest) : this() {
            this.domainControllers = x.domainControllers
            this.domainName = x.domainName
            this.gatewayArn = x.gatewayArn
            this.organizationalUnit = x.organizationalUnit
            this.password = x.password
            this.timeoutInSeconds = x.timeoutInSeconds
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.JoinDomainRequest = JoinDomainRequest(this)
    }
}
