// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



public class CreateCachediScsiVolumeRequest private constructor(builder: Builder) {
    /**
     * A unique identifier that you use to retry a request. If you retry a request, use the same `ClientToken` you specified in the initial request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway.
     *
     * Valid Values: A valid IP address.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The `VolumeSizeInBytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
     */
    public val sourceVolumeArn: kotlin.String? = builder.sourceVolumeArn
    /**
     * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
     *
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
     */
    public val targetName: kotlin.String? = builder.targetName
    /**
     * The size of the volume in bytes.
     */
    public val volumeSizeInBytes: kotlin.Long = builder.volumeSizeInBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CreateCachediScsiVolumeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCachediScsiVolumeRequest(")
        append("clientToken=$clientToken,")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("snapshotId=$snapshotId,")
        append("sourceVolumeArn=$sourceVolumeArn,")
        append("tags=$tags,")
        append("targetName=$targetName,")
        append("volumeSizeInBytes=$volumeSizeInBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (sourceVolumeArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCachediScsiVolumeRequest

        if (clientToken != other.clientToken) return false
        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (snapshotId != other.snapshotId) return false
        if (sourceVolumeArn != other.sourceVolumeArn) return false
        if (tags != other.tags) return false
        if (targetName != other.targetName) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CreateCachediScsiVolumeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier that you use to retry a request. If you retry a request, use the same `ClientToken` you specified in the initial request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway.
         *
         * Valid Values: A valid IP address.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The `VolumeSizeInBytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
         */
        public var sourceVolumeArn: kotlin.String? = null
        /**
         * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
         *
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
         */
        public var targetName: kotlin.String? = null
        /**
         * The size of the volume in bytes.
         */
        public var volumeSizeInBytes: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CreateCachediScsiVolumeRequest) : this() {
            this.clientToken = x.clientToken
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.networkInterfaceId = x.networkInterfaceId
            this.snapshotId = x.snapshotId
            this.sourceVolumeArn = x.sourceVolumeArn
            this.tags = x.tags
            this.targetName = x.targetName
            this.volumeSizeInBytes = x.volumeSizeInBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CreateCachediScsiVolumeRequest = CreateCachediScsiVolumeRequest(this)
    }
}
