// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON object containing one or more of the following fields:
 * + UpdateSnapshotScheduleInput$Description
 * + UpdateSnapshotScheduleInput$RecurrenceInHours
 * + UpdateSnapshotScheduleInput$StartAt
 * + UpdateSnapshotScheduleInput$VolumeARN
 */
public class UpdateSnapshotScheduleRequest private constructor(builder: Builder) {
    /**
     * Optional description of the snapshot that overwrites the existing description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Frequency of snapshots. Specify the number of hours between snapshots.
     */
    public val recurrenceInHours: kotlin.Int? = builder.recurrenceInHours
    /**
     * The hour of the day at which the snapshot schedule begins represented as *hh*, where *hh* is the hour (0 to 23). The hour of the day is in the time zone of the gateway.
     */
    public val startAt: kotlin.Int? = builder.startAt
    /**
     * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation to return a list of gateway volumes.
     */
    public val volumeArn: kotlin.String? = builder.volumeArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.UpdateSnapshotScheduleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSnapshotScheduleRequest(")
        append("description=$description,")
        append("recurrenceInHours=$recurrenceInHours,")
        append("startAt=$startAt,")
        append("tags=$tags,")
        append("volumeArn=$volumeArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (recurrenceInHours ?: 0)
        result = 31 * result + (startAt ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSnapshotScheduleRequest

        if (description != other.description) return false
        if (recurrenceInHours != other.recurrenceInHours) return false
        if (startAt != other.startAt) return false
        if (tags != other.tags) return false
        if (volumeArn != other.volumeArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.UpdateSnapshotScheduleRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional description of the snapshot that overwrites the existing description.
         */
        public var description: kotlin.String? = null
        /**
         * Frequency of snapshots. Specify the number of hours between snapshots.
         */
        public var recurrenceInHours: kotlin.Int? = null
        /**
         * The hour of the day at which the snapshot schedule begins represented as *hh*, where *hh* is the hour (0 to 23). The hour of the day is in the time zone of the gateway.
         */
        public var startAt: kotlin.Int? = null
        /**
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation to return a list of gateway volumes.
         */
        public var volumeArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.UpdateSnapshotScheduleRequest) : this() {
            this.description = x.description
            this.recurrenceInHours = x.recurrenceInHours
            this.startAt = x.startAt
            this.tags = x.tags
            this.volumeArn = x.volumeArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.UpdateSnapshotScheduleRequest = UpdateSnapshotScheduleRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
