// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON object containing the following fields:
 * + UpdateMaintenanceStartTimeInput$SoftwareUpdatePreferences
 * + UpdateMaintenanceStartTimeInput$DayOfMonth
 * + UpdateMaintenanceStartTimeInput$DayOfWeek
 * + UpdateMaintenanceStartTimeInput$HourOfDay
 * + UpdateMaintenanceStartTimeInput$MinuteOfHour
 */
public class UpdateMaintenanceStartTimeRequest private constructor(builder: Builder) {
    /**
     * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month. It is not possible to set the maintenance schedule to start on days 29 through 31.
     */
    public val dayOfMonth: kotlin.Int? = builder.dayOfMonth
    /**
     * The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
     */
    public val dayOfWeek: kotlin.Int? = builder.dayOfWeek
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The hour component of the maintenance start time represented as *hh*, where *hh* is the hour (00 to 23). The hour of the day is in the time zone of the gateway.
     */
    public val hourOfDay: kotlin.Int? = builder.hourOfDay
    /**
     * The minute component of the maintenance start time represented as *mm*, where *mm* is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.
     */
    public val minuteOfHour: kotlin.Int? = builder.minuteOfHour
    /**
     * A set of variables indicating the software update preferences for the gateway.
     *
     * Includes `AutomaticUpdatePolicy` field with the following inputs:
     *
     * `ALL_VERSIONS` - Enables regular gateway maintenance updates.
     *
     * `EMERGENCY_VERSIONS_ONLY` - Disables regular gateway maintenance updates. The gateway will still receive emergency version updates on rare occasions if necessary to remedy highly critical security or durability issues. You will be notified before an emergency version update is applied. These updates are applied during your gateway's scheduled maintenance window.
     */
    public val softwareUpdatePreferences: aws.sdk.kotlin.services.storagegateway.model.SoftwareUpdatePreferences? = builder.softwareUpdatePreferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.UpdateMaintenanceStartTimeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMaintenanceStartTimeRequest(")
        append("dayOfMonth=$dayOfMonth,")
        append("dayOfWeek=$dayOfWeek,")
        append("gatewayArn=$gatewayArn,")
        append("hourOfDay=$hourOfDay,")
        append("minuteOfHour=$minuteOfHour,")
        append("softwareUpdatePreferences=$softwareUpdatePreferences")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dayOfMonth ?: 0
        result = 31 * result + (dayOfWeek ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (hourOfDay ?: 0)
        result = 31 * result + (minuteOfHour ?: 0)
        result = 31 * result + (softwareUpdatePreferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMaintenanceStartTimeRequest

        if (dayOfMonth != other.dayOfMonth) return false
        if (dayOfWeek != other.dayOfWeek) return false
        if (gatewayArn != other.gatewayArn) return false
        if (hourOfDay != other.hourOfDay) return false
        if (minuteOfHour != other.minuteOfHour) return false
        if (softwareUpdatePreferences != other.softwareUpdatePreferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.UpdateMaintenanceStartTimeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month. It is not possible to set the maintenance schedule to start on days 29 through 31.
         */
        public var dayOfMonth: kotlin.Int? = null
        /**
         * The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
         */
        public var dayOfWeek: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The hour component of the maintenance start time represented as *hh*, where *hh* is the hour (00 to 23). The hour of the day is in the time zone of the gateway.
         */
        public var hourOfDay: kotlin.Int? = null
        /**
         * The minute component of the maintenance start time represented as *mm*, where *mm* is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.
         */
        public var minuteOfHour: kotlin.Int? = null
        /**
         * A set of variables indicating the software update preferences for the gateway.
         *
         * Includes `AutomaticUpdatePolicy` field with the following inputs:
         *
         * `ALL_VERSIONS` - Enables regular gateway maintenance updates.
         *
         * `EMERGENCY_VERSIONS_ONLY` - Disables regular gateway maintenance updates. The gateway will still receive emergency version updates on rare occasions if necessary to remedy highly critical security or durability issues. You will be notified before an emergency version update is applied. These updates are applied during your gateway's scheduled maintenance window.
         */
        public var softwareUpdatePreferences: aws.sdk.kotlin.services.storagegateway.model.SoftwareUpdatePreferences? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.UpdateMaintenanceStartTimeRequest) : this() {
            this.dayOfMonth = x.dayOfMonth
            this.dayOfWeek = x.dayOfWeek
            this.gatewayArn = x.gatewayArn
            this.hourOfDay = x.hourOfDay
            this.minuteOfHour = x.minuteOfHour
            this.softwareUpdatePreferences = x.softwareUpdatePreferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.UpdateMaintenanceStartTimeRequest = UpdateMaintenanceStartTimeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.SoftwareUpdatePreferences] inside the given [block]
         */
        public fun softwareUpdatePreferences(block: aws.sdk.kotlin.services.storagegateway.model.SoftwareUpdatePreferences.Builder.() -> kotlin.Unit) {
            this.softwareUpdatePreferences = aws.sdk.kotlin.services.storagegateway.model.SoftwareUpdatePreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
