// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartCacheReportRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Region of the Amazon S3 bucket associated with the file share for which you want to generate the cache report.
     */
    public val bucketRegion: kotlin.String? = builder.bucketRegion
    /**
     * A unique identifier that you use to ensure idempotent report generation if you need to retry an unsuccessful `StartCacheReport` request. If you retry a request, use the same `ClientToken` you specified in the initial request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The list of filters and parameters that determine which files are excluded from the report. You must specify at least one value for `InclusionFilters` or `ExclusionFilters` in a `StartCacheReport` request.
     */
    public val exclusionFilters: List<CacheReportFilter>? = builder.exclusionFilters
    /**
     * The Amazon Resource Name (ARN) of the file share.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * The list of filters and parameters that determine which files are included in the report. You must specify at least one value for `InclusionFilters` or `ExclusionFilters` in a `StartCacheReport` request.
     */
    public val inclusionFilters: List<CacheReportFilter>? = builder.inclusionFilters
    /**
     * The ARN of the Amazon S3 bucket where the cache report will be saved.
     *
     * We do not recommend saving the cache report to the same Amazon S3 bucket for which you are generating the report.
     *
     * This field does not accept access point ARNs.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * The ARN of the IAM role used when saving the cache report to Amazon S3.
     */
    public val role: kotlin.String? = builder.role
    /**
     * A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you categorize your reports and more easily locate them in search results.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The DNS name of the VPC endpoint associated with the Amazon S3 where you want to save the cache report. Optional.
     */
    public val vpcEndpointDnsName: kotlin.String? = builder.vpcEndpointDnsName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.StartCacheReportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartCacheReportRequest(")
        append("bucketRegion=$bucketRegion,")
        append("clientToken=$clientToken,")
        append("exclusionFilters=$exclusionFilters,")
        append("fileShareArn=$fileShareArn,")
        append("inclusionFilters=$inclusionFilters,")
        append("locationArn=$locationArn,")
        append("role=$role,")
        append("tags=$tags,")
        append("vpcEndpointDnsName=$vpcEndpointDnsName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketRegion?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (exclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (inclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointDnsName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartCacheReportRequest

        if (bucketRegion != other.bucketRegion) return false
        if (clientToken != other.clientToken) return false
        if (exclusionFilters != other.exclusionFilters) return false
        if (fileShareArn != other.fileShareArn) return false
        if (inclusionFilters != other.inclusionFilters) return false
        if (locationArn != other.locationArn) return false
        if (role != other.role) return false
        if (tags != other.tags) return false
        if (vpcEndpointDnsName != other.vpcEndpointDnsName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.StartCacheReportRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services Region of the Amazon S3 bucket associated with the file share for which you want to generate the cache report.
         */
        public var bucketRegion: kotlin.String? = null
        /**
         * A unique identifier that you use to ensure idempotent report generation if you need to retry an unsuccessful `StartCacheReport` request. If you retry a request, use the same `ClientToken` you specified in the initial request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The list of filters and parameters that determine which files are excluded from the report. You must specify at least one value for `InclusionFilters` or `ExclusionFilters` in a `StartCacheReport` request.
         */
        public var exclusionFilters: List<CacheReportFilter>? = null
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * The list of filters and parameters that determine which files are included in the report. You must specify at least one value for `InclusionFilters` or `ExclusionFilters` in a `StartCacheReport` request.
         */
        public var inclusionFilters: List<CacheReportFilter>? = null
        /**
         * The ARN of the Amazon S3 bucket where the cache report will be saved.
         *
         * We do not recommend saving the cache report to the same Amazon S3 bucket for which you are generating the report.
         *
         * This field does not accept access point ARNs.
         */
        public var locationArn: kotlin.String? = null
        /**
         * The ARN of the IAM role used when saving the cache report to Amazon S3.
         */
        public var role: kotlin.String? = null
        /**
         * A list of up to 50 key/value tags that you can assign to the cache report. Using tags can help you categorize your reports and more easily locate them in search results.
         */
        public var tags: List<Tag>? = null
        /**
         * The DNS name of the VPC endpoint associated with the Amazon S3 where you want to save the cache report. Optional.
         */
        public var vpcEndpointDnsName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.StartCacheReportRequest) : this() {
            this.bucketRegion = x.bucketRegion
            this.clientToken = x.clientToken
            this.exclusionFilters = x.exclusionFilters
            this.fileShareArn = x.fileShareArn
            this.inclusionFilters = x.inclusionFilters
            this.locationArn = x.locationArn
            this.role = x.role
            this.tags = x.tags
            this.vpcEndpointDnsName = x.vpcEndpointDnsName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.StartCacheReportRequest = StartCacheReportRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
