// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CreateSMBFileShareInput
 */
public class CreateSmbFileShareRequest private constructor(builder: Builder) {
    /**
     * The files and folders on this share will only be visible to users with read access.
     */
    public val accessBasedEnumeration: kotlin.Boolean? = builder.accessBasedEnumeration
    /**
     * A list of users or groups in the Active Directory that will be granted administrator privileges on the file share. These users can do all file operations as the super-user. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`.
     *
     * Use this option very carefully, because any user in this list can do anything they like on the file share, regardless of file permissions.
     */
    public val adminUserList: List<String>? = builder.adminUserList
    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public val auditDestinationArn: kotlin.String? = builder.auditDestinationArn
    /**
     * The authentication method that users use to access the file share. The default is `ActiveDirectory`.
     *
     * Valid Values: `ActiveDirectory` | `GuestAccess`
     */
    public val authentication: kotlin.String? = builder.authentication
    /**
     * Specifies the Region of the S3 bucket where the SMB file share stores files.
     *
     * This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    public val bucketRegion: kotlin.String? = builder.bucketRegion
    /**
     * Specifies refresh cache information for the file share.
     */
    public val cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = builder.cacheAttributes
    /**
     * The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     */
    public val caseSensitivity: aws.sdk.kotlin.services.storagegateway.model.CaseSensitivity? = builder.caseSensitivity
    /**
     * A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
     *
     * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
     */
    public val defaultStorageClass: kotlin.String? = builder.defaultStorageClass
    /**
     * A value that specifies the type of server-side encryption that the file share will use for the data that it stores in Amazon S3.
     *
     * We recommend using `EncryptionType` instead of `KMSEncrypted` to set the file share encryption method. You do not need to provide values for both parameters.
     *
     * If values for both parameters exist in the same request, then the specified encryption methods must not conflict. For example, if `EncryptionType` is `SseS3`, then `KMSEncrypted` must be `false`. If `EncryptionType` is `SseKms` or `DsseKms`, then `KMSEncrypted` must be `true`.
     */
    public val encryptionType: aws.sdk.kotlin.services.storagegateway.model.EncryptionType? = builder.encryptionType
    /**
     * The name of the file share. Optional.
     *
     * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
     *
     * A valid SMB file share name cannot contain the following characters: `[`,`]`,`#`,`;`,`<`,`>`,`:`,`"`,`\`,`/`,`|`,`?`,`*`,`+`, or ASCII control characters `1-31`.
     */
    public val fileShareName: kotlin.String? = builder.fileShareName
    /**
     * The ARN of the S3 File Gateway on which you want to create a file share.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
     *
     * Valid Values: `true` | `false`
     */
    public val guessMimeTypeEnabled: kotlin.Boolean? = builder.guessMimeTypeEnabled
    /**
     * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
     */
    public val invalidUserList: List<String>? = builder.invalidUserList
    /**
     * Optional. Set to `true` to use Amazon S3 server-side encryption with your own KMS key (SSE-KMS), or `false` to use a key managed by Amazon S3 (SSE-S3). To use dual-layer encryption (DSSE-KMS), set the `EncryptionType` parameter instead.
     *
     * We recommend using `EncryptionType` instead of `KMSEncrypted` to set the file share encryption method. You do not need to provide values for both parameters.
     *
     * If values for both parameters exist in the same request, then the specified encryption methods must not conflict. For example, if `EncryptionType` is `SseS3`, then `KMSEncrypted` must be `false`. If `EncryptionType` is `SseKms` or `DsseKms`, then `KMSEncrypted` must be `true`.
     *
     * Valid Values: `true` | `false`
     */
    @Deprecated("KMSEncrypted is deprecated, use EncryptionType instead.")
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if `KMSEncrypted` is `true`, or if `EncryptionType` is `SseKms` or `DsseKms`.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).
     *
     * You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.
     *
     * Bucket ARN:
     *
     * `arn:aws:s3:::amzn-s3-demo-bucket/prefix/`
     *
     * Access point ARN:
     *
     * `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
     *
     * If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see [Delegating access control to access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control) in the *Amazon S3 User Guide*.
     *
     * Access point alias:
     *
     * `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
     *
     * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
     *
     * This setting is not meant to specify an exact time at which the notification will be sent. In some cases, the gateway might require more than the specified delay time to generate and send notifications.
     *
     * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
     *
     * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
     *
     * The following example sets `NotificationPolicy` off.
     *
     * `{}`
     */
    public val notificationPolicy: kotlin.String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
     */
    public val objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = builder.objectAcl
    /**
     * Specifies whether opportunistic locking is enabled for the SMB file share.
     *
     * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.
     *
     * Valid Values: `true` | `false`
     */
    public val oplocksEnabled: kotlin.Boolean? = builder.oplocksEnabled
    /**
     * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
     *
     * Valid Values: `true` | `false`
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
     *
     * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
     *
     * Valid Values: `true` | `false`
     */
    public val requesterPays: kotlin.Boolean? = builder.requesterPays
    /**
     * The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.
     */
    public val role: kotlin.String? = builder.role
    /**
     * Set this value to `true` to enable access control list (ACL) on the SMB file share. Set it to `false` to map file and directory permissions to the POSIX permissions.
     *
     * For more information, see [Using Windows ACLs to limit SMB file share access](https://docs.aws.amazon.com/filegateway/latest/files3/smb-acl.html) in the *Amazon S3 File Gateway User Guide*.
     *
     * Valid Values: `true` | `false`
     */
    public val smbaclEnabled: kotlin.Boolean? = builder.smbaclEnabled
    /**
     * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of users or groups in the Active Directory that are allowed to access the file  share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
     */
    public val validUserList: List<String>? = builder.validUserList
    /**
     * Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.
     *
     * This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    public val vpcEndpointDnsName: kotlin.String? = builder.vpcEndpointDnsName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CreateSmbFileShareRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSmbFileShareRequest(")
        append("accessBasedEnumeration=$accessBasedEnumeration,")
        append("adminUserList=$adminUserList,")
        append("auditDestinationArn=$auditDestinationArn,")
        append("authentication=$authentication,")
        append("bucketRegion=$bucketRegion,")
        append("cacheAttributes=$cacheAttributes,")
        append("caseSensitivity=$caseSensitivity,")
        append("clientToken=$clientToken,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("encryptionType=$encryptionType,")
        append("fileShareName=$fileShareName,")
        append("gatewayArn=$gatewayArn,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("invalidUserList=$invalidUserList,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("locationArn=$locationArn,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("oplocksEnabled=$oplocksEnabled,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("role=$role,")
        append("smbaclEnabled=$smbaclEnabled,")
        append("tags=$tags,")
        append("validUserList=$validUserList,")
        append("vpcEndpointDnsName=$vpcEndpointDnsName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessBasedEnumeration?.hashCode() ?: 0
        result = 31 * result + (adminUserList?.hashCode() ?: 0)
        result = 31 * result + (auditDestinationArn?.hashCode() ?: 0)
        result = 31 * result + (authentication?.hashCode() ?: 0)
        result = 31 * result + (bucketRegion?.hashCode() ?: 0)
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (caseSensitivity?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (encryptionType?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (invalidUserList?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (oplocksEnabled?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (smbaclEnabled?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (validUserList?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointDnsName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSmbFileShareRequest

        if (accessBasedEnumeration != other.accessBasedEnumeration) return false
        if (adminUserList != other.adminUserList) return false
        if (auditDestinationArn != other.auditDestinationArn) return false
        if (authentication != other.authentication) return false
        if (bucketRegion != other.bucketRegion) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (caseSensitivity != other.caseSensitivity) return false
        if (clientToken != other.clientToken) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (encryptionType != other.encryptionType) return false
        if (fileShareName != other.fileShareName) return false
        if (gatewayArn != other.gatewayArn) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (invalidUserList != other.invalidUserList) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (locationArn != other.locationArn) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (oplocksEnabled != other.oplocksEnabled) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (role != other.role) return false
        if (smbaclEnabled != other.smbaclEnabled) return false
        if (tags != other.tags) return false
        if (validUserList != other.validUserList) return false
        if (vpcEndpointDnsName != other.vpcEndpointDnsName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CreateSmbFileShareRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The files and folders on this share will only be visible to users with read access.
         */
        public var accessBasedEnumeration: kotlin.Boolean? = null
        /**
         * A list of users or groups in the Active Directory that will be granted administrator privileges on the file share. These users can do all file operations as the super-user. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`.
         *
         * Use this option very carefully, because any user in this list can do anything they like on the file share, regardless of file permissions.
         */
        public var adminUserList: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        public var auditDestinationArn: kotlin.String? = null
        /**
         * The authentication method that users use to access the file share. The default is `ActiveDirectory`.
         *
         * Valid Values: `ActiveDirectory` | `GuestAccess`
         */
        public var authentication: kotlin.String? = null
        /**
         * Specifies the Region of the S3 bucket where the SMB file share stores files.
         *
         * This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        public var bucketRegion: kotlin.String? = null
        /**
         * Specifies refresh cache information for the file share.
         */
        public var cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = null
        /**
         * The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
         */
        public var caseSensitivity: aws.sdk.kotlin.services.storagegateway.model.CaseSensitivity? = null
        /**
         * A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
         *
         * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
         */
        public var defaultStorageClass: kotlin.String? = null
        /**
         * A value that specifies the type of server-side encryption that the file share will use for the data that it stores in Amazon S3.
         *
         * We recommend using `EncryptionType` instead of `KMSEncrypted` to set the file share encryption method. You do not need to provide values for both parameters.
         *
         * If values for both parameters exist in the same request, then the specified encryption methods must not conflict. For example, if `EncryptionType` is `SseS3`, then `KMSEncrypted` must be `false`. If `EncryptionType` is `SseKms` or `DsseKms`, then `KMSEncrypted` must be `true`.
         */
        public var encryptionType: aws.sdk.kotlin.services.storagegateway.model.EncryptionType? = null
        /**
         * The name of the file share. Optional.
         *
         * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
         *
         * A valid SMB file share name cannot contain the following characters: `[`,`]`,`#`,`;`,`<`,`>`,`:`,`"`,`\`,`/`,`|`,`?`,`*`,`+`, or ASCII control characters `1-31`.
         */
        public var fileShareName: kotlin.String? = null
        /**
         * The ARN of the S3 File Gateway on which you want to create a file share.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
         *
         * Valid Values: `true` | `false`
         */
        public var guessMimeTypeEnabled: kotlin.Boolean? = null
        /**
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
         */
        public var invalidUserList: List<String>? = null
        /**
         * Optional. Set to `true` to use Amazon S3 server-side encryption with your own KMS key (SSE-KMS), or `false` to use a key managed by Amazon S3 (SSE-S3). To use dual-layer encryption (DSSE-KMS), set the `EncryptionType` parameter instead.
         *
         * We recommend using `EncryptionType` instead of `KMSEncrypted` to set the file share encryption method. You do not need to provide values for both parameters.
         *
         * If values for both parameters exist in the same request, then the specified encryption methods must not conflict. For example, if `EncryptionType` is `SseS3`, then `KMSEncrypted` must be `false`. If `EncryptionType` is `SseKms` or `DsseKms`, then `KMSEncrypted` must be `true`.
         *
         * Valid Values: `true` | `false`
         */
        @Deprecated("KMSEncrypted is deprecated, use EncryptionType instead.")
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if `KMSEncrypted` is `true`, or if `EncryptionType` is `SseKms` or `DsseKms`.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).
         *
         * You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.
         *
         * Bucket ARN:
         *
         * `arn:aws:s3:::amzn-s3-demo-bucket/prefix/`
         *
         * Access point ARN:
         *
         * `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
         *
         * If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see [Delegating access control to access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control) in the *Amazon S3 User Guide*.
         *
         * Access point alias:
         *
         * `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
         */
        public var locationArn: kotlin.String? = null
        /**
         * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
         *
         * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
         *
         * This setting is not meant to specify an exact time at which the notification will be sent. In some cases, the gateway might require more than the specified delay time to generate and send notifications.
         *
         * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
         *
         * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
         *
         * The following example sets `NotificationPolicy` off.
         *
         * `{}`
         */
        public var notificationPolicy: kotlin.String? = null
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
         */
        public var objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = null
        /**
         * Specifies whether opportunistic locking is enabled for the SMB file share.
         *
         * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.
         *
         * Valid Values: `true` | `false`
         */
        public var oplocksEnabled: kotlin.Boolean? = null
        /**
         * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
         *
         * Valid Values: `true` | `false`
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
         *
         * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
         *
         * Valid Values: `true` | `false`
         */
        public var requesterPays: kotlin.Boolean? = null
        /**
         * The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.
         */
        public var role: kotlin.String? = null
        /**
         * Set this value to `true` to enable access control list (ACL) on the SMB file share. Set it to `false` to map file and directory permissions to the POSIX permissions.
         *
         * For more information, see [Using Windows ACLs to limit SMB file share access](https://docs.aws.amazon.com/filegateway/latest/files3/smb-acl.html) in the *Amazon S3 File Gateway User Guide*.
         *
         * Valid Values: `true` | `false`
         */
        public var smbaclEnabled: kotlin.Boolean? = null
        /**
         * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of users or groups in the Active Directory that are allowed to access the file  share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
         */
        public var validUserList: List<String>? = null
        /**
         * Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.
         *
         * This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        public var vpcEndpointDnsName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CreateSmbFileShareRequest) : this() {
            this.accessBasedEnumeration = x.accessBasedEnumeration
            this.adminUserList = x.adminUserList
            this.auditDestinationArn = x.auditDestinationArn
            this.authentication = x.authentication
            this.bucketRegion = x.bucketRegion
            this.cacheAttributes = x.cacheAttributes
            this.caseSensitivity = x.caseSensitivity
            this.clientToken = x.clientToken
            this.defaultStorageClass = x.defaultStorageClass
            this.encryptionType = x.encryptionType
            this.fileShareName = x.fileShareName
            this.gatewayArn = x.gatewayArn
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.invalidUserList = x.invalidUserList
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.locationArn = x.locationArn
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.oplocksEnabled = x.oplocksEnabled
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.role = x.role
            this.smbaclEnabled = x.smbaclEnabled
            this.tags = x.tags
            this.validUserList = x.validUserList
            this.vpcEndpointDnsName = x.vpcEndpointDnsName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CreateSmbFileShareRequest = CreateSmbFileShareRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        public fun cacheAttributes(block: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.Builder.() -> kotlin.Unit) {
            this.cacheAttributes = aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
