// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an iSCSI cached volume.
 */
public class CachediScsiVolume private constructor(builder: Builder) {
    /**
     * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if `KMSEncrypted` is `true`, or if `EncryptionType` is `SseKms` or `DsseKms`.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g., snap-78e22663. Otherwise, this field is not included.
     */
    public val sourceSnapshotId: kotlin.String? = builder.sourceSnapshotId
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
     *
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
     */
    public val targetName: kotlin.String? = builder.targetName
    /**
     * The Amazon Resource Name (ARN) of the storage volume.
     */
    public val volumeArn: kotlin.String? = builder.volumeArn
    /**
     * A value that indicates whether a storage volume is attached to or detached from a gateway. For more information, see [Moving your volumes to a different gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume).
     */
    public val volumeAttachmentStatus: kotlin.String? = builder.volumeAttachmentStatus
    /**
     * The unique identifier of the volume, e.g., vol-AE4B946D.
     */
    public val volumeId: kotlin.String? = builder.volumeId
    /**
     * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the cached volume is not restoring or bootstrapping.
     */
    public val volumeProgress: kotlin.Double? = builder.volumeProgress
    /**
     * The size, in bytes, of the volume capacity.
     */
    public val volumeSizeInBytes: kotlin.Long = builder.volumeSizeInBytes
    /**
     * One of the VolumeStatus values that indicates the state of the storage volume.
     */
    public val volumeStatus: kotlin.String? = builder.volumeStatus
    /**
     * One of the VolumeType enumeration values that describes the type of the volume.
     */
    public val volumeType: kotlin.String? = builder.volumeType
    /**
     * The size of the data stored on the volume in bytes. This value is calculated based on the number of blocks that are touched, instead of the actual amount of data written. This value can be useful for sequential write patterns but less accurate for random write patterns. `VolumeUsedInBytes` is different from the compressed size of the volume, which is the value that is used to calculate your bill.
     *
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     *
     * If you use a delete tool that overwrites the data on your volume with random data, your usage will not be reduced. This is because the random data is not compressible. If you want to reduce the amount of billed storage on your volume, we recommend overwriting your files with zeros to compress the data to a negligible amount of actual storage.
     */
    public val volumeUsedInBytes: kotlin.Long? = builder.volumeUsedInBytes
    /**
     * An VolumeiSCSIAttributes object that represents a collection of iSCSI attributes for one stored volume.
     */
    public val volumeiScsiAttributes: aws.sdk.kotlin.services.storagegateway.model.VolumeiScsiAttributes? = builder.volumeiScsiAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CachediScsiVolume = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachediScsiVolume(")
        append("createdDate=$createdDate,")
        append("kmsKey=$kmsKey,")
        append("sourceSnapshotId=$sourceSnapshotId,")
        append("targetName=$targetName,")
        append("volumeArn=$volumeArn,")
        append("volumeAttachmentStatus=$volumeAttachmentStatus,")
        append("volumeId=$volumeId,")
        append("volumeProgress=$volumeProgress,")
        append("volumeSizeInBytes=$volumeSizeInBytes,")
        append("volumeStatus=$volumeStatus,")
        append("volumeType=$volumeType,")
        append("volumeUsedInBytes=$volumeUsedInBytes,")
        append("volumeiScsiAttributes=$volumeiScsiAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (sourceSnapshotId?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeAttachmentStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeProgress?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        result = 31 * result + (volumeStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        result = 31 * result + (volumeUsedInBytes?.hashCode() ?: 0)
        result = 31 * result + (volumeiScsiAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachediScsiVolume

        if (createdDate != other.createdDate) return false
        if (kmsKey != other.kmsKey) return false
        if (sourceSnapshotId != other.sourceSnapshotId) return false
        if (targetName != other.targetName) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeAttachmentStatus != other.volumeAttachmentStatus) return false
        if (volumeId != other.volumeId) return false
        if (!(volumeProgress?.equals(other.volumeProgress) ?: (other.volumeProgress == null))) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false
        if (volumeStatus != other.volumeStatus) return false
        if (volumeType != other.volumeType) return false
        if (volumeUsedInBytes != other.volumeUsedInBytes) return false
        if (volumeiScsiAttributes != other.volumeiScsiAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CachediScsiVolume = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if `KMSEncrypted` is `true`, or if `EncryptionType` is `SseKms` or `DsseKms`.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * If the cached volume was created from a snapshot, this field contains the snapshot ID used, e.g., snap-78e22663. Otherwise, this field is not included.
         */
        public var sourceSnapshotId: kotlin.String? = null
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
         *
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
         */
        public var targetName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the storage volume.
         */
        public var volumeArn: kotlin.String? = null
        /**
         * A value that indicates whether a storage volume is attached to or detached from a gateway. For more information, see [Moving your volumes to a different gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume).
         */
        public var volumeAttachmentStatus: kotlin.String? = null
        /**
         * The unique identifier of the volume, e.g., vol-AE4B946D.
         */
        public var volumeId: kotlin.String? = null
        /**
         * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of data transferred. This field does not appear in the response if the cached volume is not restoring or bootstrapping.
         */
        public var volumeProgress: kotlin.Double? = null
        /**
         * The size, in bytes, of the volume capacity.
         */
        public var volumeSizeInBytes: kotlin.Long = 0L
        /**
         * One of the VolumeStatus values that indicates the state of the storage volume.
         */
        public var volumeStatus: kotlin.String? = null
        /**
         * One of the VolumeType enumeration values that describes the type of the volume.
         */
        public var volumeType: kotlin.String? = null
        /**
         * The size of the data stored on the volume in bytes. This value is calculated based on the number of blocks that are touched, instead of the actual amount of data written. This value can be useful for sequential write patterns but less accurate for random write patterns. `VolumeUsedInBytes` is different from the compressed size of the volume, which is the value that is used to calculate your bill.
         *
         * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
         *
         * If you use a delete tool that overwrites the data on your volume with random data, your usage will not be reduced. This is because the random data is not compressible. If you want to reduce the amount of billed storage on your volume, we recommend overwriting your files with zeros to compress the data to a negligible amount of actual storage.
         */
        public var volumeUsedInBytes: kotlin.Long? = null
        /**
         * An VolumeiSCSIAttributes object that represents a collection of iSCSI attributes for one stored volume.
         */
        public var volumeiScsiAttributes: aws.sdk.kotlin.services.storagegateway.model.VolumeiScsiAttributes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CachediScsiVolume) : this() {
            this.createdDate = x.createdDate
            this.kmsKey = x.kmsKey
            this.sourceSnapshotId = x.sourceSnapshotId
            this.targetName = x.targetName
            this.volumeArn = x.volumeArn
            this.volumeAttachmentStatus = x.volumeAttachmentStatus
            this.volumeId = x.volumeId
            this.volumeProgress = x.volumeProgress
            this.volumeSizeInBytes = x.volumeSizeInBytes
            this.volumeStatus = x.volumeStatus
            this.volumeType = x.volumeType
            this.volumeUsedInBytes = x.volumeUsedInBytes
            this.volumeiScsiAttributes = x.volumeiScsiAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CachediScsiVolume = CachediScsiVolume(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.VolumeiScsiAttributes] inside the given [block]
         */
        public fun volumeiScsiAttributes(block: aws.sdk.kotlin.services.storagegateway.model.VolumeiScsiAttributes.Builder.() -> kotlin.Unit) {
            this.volumeiScsiAttributes = aws.sdk.kotlin.services.storagegateway.model.VolumeiScsiAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
