// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains all informational fields associated with a cache report. Includes name, ARN, tags, status, progress, filters, start time, and end time.
 */
public class CacheReportInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cache report you want to describe.
     */
    public val cacheReportArn: kotlin.String? = builder.cacheReportArn
    /**
     * The status of the specified cache report.
     */
    public val cacheReportStatus: aws.sdk.kotlin.services.storagegateway.model.CacheReportStatus? = builder.cacheReportStatus
    /**
     * The time at which the gateway stopped generating the cache report.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The list of filters and parameters that determine which files are excluded from the report.
     */
    public val exclusionFilters: List<CacheReportFilter>? = builder.exclusionFilters
    /**
     * The Amazon Resource Name (ARN) of the file share.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * The list of filters and parameters that determine which files are included in the report.
     */
    public val inclusionFilters: List<CacheReportFilter>? = builder.inclusionFilters
    /**
     * The ARN of the Amazon S3 bucket location where the cache report is saved.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * The percentage of the report generation process that has been completed at time of inquiry.
     */
    public val reportCompletionPercent: kotlin.Int? = builder.reportCompletionPercent
    /**
     * The file name of the completed cache report object stored in Amazon S3.
     */
    public val reportName: kotlin.String? = builder.reportName
    /**
     * The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying storage.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The time at which the gateway started generating the cache report.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The list of key/value tags associated with the report.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CacheReportInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheReportInfo(")
        append("cacheReportArn=$cacheReportArn,")
        append("cacheReportStatus=$cacheReportStatus,")
        append("endTime=$endTime,")
        append("exclusionFilters=$exclusionFilters,")
        append("fileShareArn=$fileShareArn,")
        append("inclusionFilters=$inclusionFilters,")
        append("locationArn=$locationArn,")
        append("reportCompletionPercent=$reportCompletionPercent,")
        append("reportName=$reportName,")
        append("role=$role,")
        append("startTime=$startTime,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheReportArn?.hashCode() ?: 0
        result = 31 * result + (cacheReportStatus?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (exclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (inclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (reportCompletionPercent ?: 0)
        result = 31 * result + (reportName?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheReportInfo

        if (cacheReportArn != other.cacheReportArn) return false
        if (cacheReportStatus != other.cacheReportStatus) return false
        if (endTime != other.endTime) return false
        if (exclusionFilters != other.exclusionFilters) return false
        if (fileShareArn != other.fileShareArn) return false
        if (inclusionFilters != other.inclusionFilters) return false
        if (locationArn != other.locationArn) return false
        if (reportCompletionPercent != other.reportCompletionPercent) return false
        if (reportName != other.reportName) return false
        if (role != other.role) return false
        if (startTime != other.startTime) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CacheReportInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cache report you want to describe.
         */
        public var cacheReportArn: kotlin.String? = null
        /**
         * The status of the specified cache report.
         */
        public var cacheReportStatus: aws.sdk.kotlin.services.storagegateway.model.CacheReportStatus? = null
        /**
         * The time at which the gateway stopped generating the cache report.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of filters and parameters that determine which files are excluded from the report.
         */
        public var exclusionFilters: List<CacheReportFilter>? = null
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * The list of filters and parameters that determine which files are included in the report.
         */
        public var inclusionFilters: List<CacheReportFilter>? = null
        /**
         * The ARN of the Amazon S3 bucket location where the cache report is saved.
         */
        public var locationArn: kotlin.String? = null
        /**
         * The percentage of the report generation process that has been completed at time of inquiry.
         */
        public var reportCompletionPercent: kotlin.Int? = null
        /**
         * The file name of the completed cache report object stored in Amazon S3.
         */
        public var reportName: kotlin.String? = null
        /**
         * The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying storage.
         */
        public var role: kotlin.String? = null
        /**
         * The time at which the gateway started generating the cache report.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of key/value tags associated with the report.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CacheReportInfo) : this() {
            this.cacheReportArn = x.cacheReportArn
            this.cacheReportStatus = x.cacheReportStatus
            this.endTime = x.endTime
            this.exclusionFilters = x.exclusionFilters
            this.fileShareArn = x.fileShareArn
            this.inclusionFilters = x.inclusionFilters
            this.locationArn = x.locationArn
            this.reportCompletionPercent = x.reportCompletionPercent
            this.reportName = x.reportName
            this.role = x.role
            this.startTime = x.startTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CacheReportInfo = CacheReportInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
