// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of filter parameters and associated values that determine which files are included or excluded from a cache report created by a `StartCacheReport` request. Multiple instances of the same filter parameter are combined with an OR operation, while different parameters are combined with an AND operation.
 */
public class CacheReportFilter private constructor(builder: Builder) {
    /**
     * The parameter name for a filter that determines which files are included or excluded from a cache report.
     *
     * **Valid Names:**
     *
     * UploadFailureReason | UploadState
     */
    public val name: aws.sdk.kotlin.services.storagegateway.model.CacheReportFilterName = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The parameter value for a filter that determines which files are included or excluded from a cache report.
     *
     * **Valid `UploadFailureReason` Values:**
     *
     * `InaccessibleStorageClass` | `InvalidObjectState` | `ObjectMissing` | `S3AccessDenied`
     *
     * **Valid `UploadState` Values:**
     *
     * `FailingUpload`
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CacheReportFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheReportFilter(")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheReportFilter

        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CacheReportFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The parameter name for a filter that determines which files are included or excluded from a cache report.
         *
         * **Valid Names:**
         *
         * UploadFailureReason | UploadState
         */
        public var name: aws.sdk.kotlin.services.storagegateway.model.CacheReportFilterName? = null
        /**
         * The parameter value for a filter that determines which files are included or excluded from a cache report.
         *
         * **Valid `UploadFailureReason` Values:**
         *
         * `InaccessibleStorageClass` | `InvalidObjectState` | `ObjectMissing` | `S3AccessDenied`
         *
         * **Valid `UploadState` Values:**
         *
         * `FailingUpload`
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CacheReportFilter) : this() {
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CacheReportFilter = CacheReportFilter(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = CacheReportFilterName.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
