// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.serde

import aws.sdk.kotlin.services.storagegateway.model.Disk
import aws.sdk.kotlin.services.storagegateway.model.ListLocalDisksResponse
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListLocalDisksOperationDeserializer: HttpDeserializer.NonStreaming<ListLocalDisksResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListLocalDisksResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListLocalDisksError(context, call, payload)
        }
        val builder = ListLocalDisksResponse.Builder()

        if (payload != null) {
            deserializeListLocalDisksOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListLocalDisksError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListLocalDisksOperationBody(builder: ListLocalDisksResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Disks"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISKS_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISKS_DESCRIPTOR.index -> builder.disks =
                    deserializer.deserializeList(DISKS_DESCRIPTOR) {
                        val col0 = mutableListOf<Disk>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDiskDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
