// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a virtual tape that is archived in the virtual tape shelf (VTS).
 */
public class TapeArchive private constructor(builder: Builder) {
    /**
     * The time that the archiving of the virtual tape was completed.
     *
     * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The time that the tape entered the custom tape pool.
     *
     * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
     */
    public val poolEntryDate: aws.smithy.kotlin.runtime.time.Instant? = builder.poolEntryDate
    /**
     * The ID of the pool that was used to archive the tape. The tapes in this pool are archived in the S3 storage class that is associated with the pool.
     */
    public val poolId: kotlin.String? = builder.poolId
    /**
     * If the archived tape is subject to tape retention lock, the date that the archived tape started being retained.
     */
    public val retentionStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.retentionStartDate
    /**
     * The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.
     *
     * The virtual tape is retrieved from the virtual tape shelf (VTS).
     */
    public val retrievedTo: kotlin.String? = builder.retrievedTo
    /**
     * The Amazon Resource Name (ARN) of an archived virtual tape.
     */
    public val tapeArn: kotlin.String? = builder.tapeArn
    /**
     * The barcode that identifies the archived virtual tape.
     */
    public val tapeBarcode: kotlin.String? = builder.tapeBarcode
    /**
     * The date the virtual tape was created.
     */
    public val tapeCreatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.tapeCreatedDate
    /**
     * The size, in bytes, of the archived virtual tape.
     */
    public val tapeSizeInBytes: kotlin.Long? = builder.tapeSizeInBytes
    /**
     * The current state of the archived virtual tape.
     */
    public val tapeStatus: kotlin.String? = builder.tapeStatus
    /**
     * The size, in bytes, of data stored on the virtual tape.
     *
     * This value is not available for tapes created prior to May 13, 2015.
     */
    public val tapeUsedInBytes: kotlin.Long? = builder.tapeUsedInBytes
    /**
     * Set to `true` if the archived tape is stored as write-once-read-many (WORM).
     */
    public val worm: kotlin.Boolean = builder.worm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.TapeArchive = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TapeArchive(")
        append("completionTime=$completionTime,")
        append("kmsKey=$kmsKey,")
        append("poolEntryDate=$poolEntryDate,")
        append("poolId=$poolId,")
        append("retentionStartDate=$retentionStartDate,")
        append("retrievedTo=$retrievedTo,")
        append("tapeArn=$tapeArn,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeCreatedDate=$tapeCreatedDate,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus,")
        append("tapeUsedInBytes=$tapeUsedInBytes,")
        append("worm=$worm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (poolEntryDate?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (retentionStartDate?.hashCode() ?: 0)
        result = 31 * result + (retrievedTo?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeCreatedDate?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        result = 31 * result + (tapeUsedInBytes?.hashCode() ?: 0)
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TapeArchive

        if (completionTime != other.completionTime) return false
        if (kmsKey != other.kmsKey) return false
        if (poolEntryDate != other.poolEntryDate) return false
        if (poolId != other.poolId) return false
        if (retentionStartDate != other.retentionStartDate) return false
        if (retrievedTo != other.retrievedTo) return false
        if (tapeArn != other.tapeArn) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeCreatedDate != other.tapeCreatedDate) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false
        if (tapeUsedInBytes != other.tapeUsedInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.TapeArchive = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time that the archiving of the virtual tape was completed.
         *
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The time that the tape entered the custom tape pool.
         *
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
         */
        public var poolEntryDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the pool that was used to archive the tape. The tapes in this pool are archived in the S3 storage class that is associated with the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * If the archived tape is subject to tape retention lock, the date that the archived tape started being retained.
         */
        public var retentionStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.
         *
         * The virtual tape is retrieved from the virtual tape shelf (VTS).
         */
        public var retrievedTo: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an archived virtual tape.
         */
        public var tapeArn: kotlin.String? = null
        /**
         * The barcode that identifies the archived virtual tape.
         */
        public var tapeBarcode: kotlin.String? = null
        /**
         * The date the virtual tape was created.
         */
        public var tapeCreatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size, in bytes, of the archived virtual tape.
         */
        public var tapeSizeInBytes: kotlin.Long? = null
        /**
         * The current state of the archived virtual tape.
         */
        public var tapeStatus: kotlin.String? = null
        /**
         * The size, in bytes, of data stored on the virtual tape.
         *
         * This value is not available for tapes created prior to May 13, 2015.
         */
        public var tapeUsedInBytes: kotlin.Long? = null
        /**
         * Set to `true` if the archived tape is stored as write-once-read-many (WORM).
         */
        public var worm: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.TapeArchive) : this() {
            this.completionTime = x.completionTime
            this.kmsKey = x.kmsKey
            this.poolEntryDate = x.poolEntryDate
            this.poolId = x.poolId
            this.retentionStartDate = x.retentionStartDate
            this.retrievedTo = x.retrievedTo
            this.tapeArn = x.tapeArn
            this.tapeBarcode = x.tapeBarcode
            this.tapeCreatedDate = x.tapeCreatedDate
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
            this.tapeUsedInBytes = x.tapeUsedInBytes
            this.worm = x.worm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.TapeArchive = TapeArchive(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
