// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a virtual tape object.
 */
public class Tape private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The date that the tape enters a custom tape pool.
     */
    public val poolEntryDate: aws.smithy.kotlin.runtime.time.Instant? = builder.poolEntryDate
    /**
     * The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public val poolId: kotlin.String? = builder.poolId
    /**
     * For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.
     *
     * Range: 0 (not started) to 100 (complete).
     */
    public val progress: kotlin.Double? = builder.progress
    /**
     * The date that the tape is first archived with tape retention lock enabled.
     */
    public val retentionStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.retentionStartDate
    /**
     * The Amazon Resource Name (ARN) of the virtual tape.
     */
    public val tapeArn: kotlin.String? = builder.tapeArn
    /**
     * The barcode that identifies a specific virtual tape.
     */
    public val tapeBarcode: kotlin.String? = builder.tapeBarcode
    /**
     * The date the virtual tape was created.
     */
    public val tapeCreatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.tapeCreatedDate
    /**
     * The size, in bytes, of the virtual tape capacity.
     */
    public val tapeSizeInBytes: kotlin.Long? = builder.tapeSizeInBytes
    /**
     * The current state of the virtual tape.
     */
    public val tapeStatus: kotlin.String? = builder.tapeStatus
    /**
     * The size, in bytes, of data stored on the virtual tape.
     *
     * This value is not available for tapes created prior to May 13, 2015.
     */
    public val tapeUsedInBytes: kotlin.Long? = builder.tapeUsedInBytes
    /**
     * The virtual tape library (VTL) device that the virtual tape is associated with.
     */
    public val vtlDevice: kotlin.String? = builder.vtlDevice
    /**
     * If the tape is archived as write-once-read-many (WORM), this value is `true`.
     */
    public val worm: kotlin.Boolean = builder.worm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.Tape = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tape(")
        append("kmsKey=$kmsKey,")
        append("poolEntryDate=$poolEntryDate,")
        append("poolId=$poolId,")
        append("progress=$progress,")
        append("retentionStartDate=$retentionStartDate,")
        append("tapeArn=$tapeArn,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeCreatedDate=$tapeCreatedDate,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus,")
        append("tapeUsedInBytes=$tapeUsedInBytes,")
        append("vtlDevice=$vtlDevice,")
        append("worm=$worm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKey?.hashCode() ?: 0
        result = 31 * result + (poolEntryDate?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (retentionStartDate?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeCreatedDate?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        result = 31 * result + (tapeUsedInBytes?.hashCode() ?: 0)
        result = 31 * result + (vtlDevice?.hashCode() ?: 0)
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tape

        if (kmsKey != other.kmsKey) return false
        if (poolEntryDate != other.poolEntryDate) return false
        if (poolId != other.poolId) return false
        if (!(progress?.equals(other.progress) ?: (other.progress == null))) return false
        if (retentionStartDate != other.retentionStartDate) return false
        if (tapeArn != other.tapeArn) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeCreatedDate != other.tapeCreatedDate) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false
        if (tapeUsedInBytes != other.tapeUsedInBytes) return false
        if (vtlDevice != other.vtlDevice) return false
        if (worm != other.worm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.Tape = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The date that the tape enters a custom tape pool.
         */
        public var poolEntryDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.
         *
         * Range: 0 (not started) to 100 (complete).
         */
        public var progress: kotlin.Double? = null
        /**
         * The date that the tape is first archived with tape retention lock enabled.
         */
        public var retentionStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the virtual tape.
         */
        public var tapeArn: kotlin.String? = null
        /**
         * The barcode that identifies a specific virtual tape.
         */
        public var tapeBarcode: kotlin.String? = null
        /**
         * The date the virtual tape was created.
         */
        public var tapeCreatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size, in bytes, of the virtual tape capacity.
         */
        public var tapeSizeInBytes: kotlin.Long? = null
        /**
         * The current state of the virtual tape.
         */
        public var tapeStatus: kotlin.String? = null
        /**
         * The size, in bytes, of data stored on the virtual tape.
         *
         * This value is not available for tapes created prior to May 13, 2015.
         */
        public var tapeUsedInBytes: kotlin.Long? = null
        /**
         * The virtual tape library (VTL) device that the virtual tape is associated with.
         */
        public var vtlDevice: kotlin.String? = null
        /**
         * If the tape is archived as write-once-read-many (WORM), this value is `true`.
         */
        public var worm: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.Tape) : this() {
            this.kmsKey = x.kmsKey
            this.poolEntryDate = x.poolEntryDate
            this.poolId = x.poolId
            this.progress = x.progress
            this.retentionStartDate = x.retentionStartDate
            this.tapeArn = x.tapeArn
            this.tapeBarcode = x.tapeBarcode
            this.tapeCreatedDate = x.tapeCreatedDate
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
            this.tapeUsedInBytes = x.tapeUsedInBytes
            this.vtlDevice = x.vtlDevice
            this.worm = x.worm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.Tape = Tape(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
