// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON object containing one or more of the following fields:
 * + CreateStorediSCSIVolumeInput$DiskId
 * + CreateStorediSCSIVolumeInput$NetworkInterfaceId
 * + CreateStorediSCSIVolumeInput$PreserveExistingData
 * + CreateStorediSCSIVolumeInput$SnapshotId
 * + CreateStorediSCSIVolumeInput$TargetName
 */
public class CreateStorediScsiVolumeRequest private constructor(builder: Builder) {
    /**
     * The unique identifier for the gateway local disk that is configured as a stored volume. Use [ListLocalDisks](https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html) to list disk IDs for a gateway.
     */
    public val diskId: kotlin.String? = builder.diskId
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway.
     *
     * Valid Values: A valid IP address.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * Set to `true` if you want to preserve the data on the local disk. Otherwise, set to `false` to create an empty volume.
     *
     * Valid Values: `true` | `false`
     */
    public val preserveExistingData: kotlin.Boolean? = builder.preserveExistingData
    /**
     * The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
     *
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
     */
    public val targetName: kotlin.String? = builder.targetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CreateStorediScsiVolumeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStorediScsiVolumeRequest(")
        append("diskId=$diskId,")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("preserveExistingData=$preserveExistingData,")
        append("snapshotId=$snapshotId,")
        append("tags=$tags,")
        append("targetName=$targetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = diskId?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (preserveExistingData?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStorediScsiVolumeRequest

        if (diskId != other.diskId) return false
        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (preserveExistingData != other.preserveExistingData) return false
        if (snapshotId != other.snapshotId) return false
        if (tags != other.tags) return false
        if (targetName != other.targetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CreateStorediScsiVolumeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the gateway local disk that is configured as a stored volume. Use [ListLocalDisks](https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html) to list disk IDs for a gateway.
         */
        public var diskId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway.
         *
         * Valid Values: A valid IP address.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * Set to `true` if you want to preserve the data on the local disk. Otherwise, set to `false` to create an empty volume.
         *
         * Valid Values: `true` | `false`
         */
        public var preserveExistingData: kotlin.Boolean? = null
        /**
         * The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
         */
        public var tags: List<Tag>? = null
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
         *
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
         */
        public var targetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CreateStorediScsiVolumeRequest) : this() {
            this.diskId = x.diskId
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.networkInterfaceId = x.networkInterfaceId
            this.preserveExistingData = x.preserveExistingData
            this.snapshotId = x.snapshotId
            this.tags = x.tags
            this.targetName = x.targetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CreateStorediScsiVolumeRequest = CreateStorediScsiVolumeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
