// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * AttachVolumeInput
 */
public class AttachVolumeRequest private constructor(builder: Builder) {
    /**
     * The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This value is only required when you are attaching a stored volume.
     */
    public val diskId: kotlin.String? = builder.diskId
    /**
     * The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway.
     *
     * Valid Values: A valid IP address.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
     *
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
     */
    public val targetName: kotlin.String? = builder.targetName
    /**
     * The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
     */
    public val volumeArn: kotlin.String? = builder.volumeArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.AttachVolumeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttachVolumeRequest(")
        append("diskId=$diskId,")
        append("gatewayArn=$gatewayArn,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("targetName=$targetName,")
        append("volumeArn=$volumeArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = diskId?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (targetName?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttachVolumeRequest

        if (diskId != other.diskId) return false
        if (gatewayArn != other.gatewayArn) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (targetName != other.targetName) return false
        if (volumeArn != other.volumeArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.AttachVolumeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This value is only required when you are attaching a stored volume.
         */
        public var diskId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway.
         *
         * Valid Values: A valid IP address.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying `TargetName` as *myvolume* results in the target ARN of `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`. The target name must be unique across all volumes on a gateway.
         *
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
         */
        public var targetName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
         */
        public var volumeArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.AttachVolumeRequest) : this() {
            this.diskId = x.diskId
            this.gatewayArn = x.gatewayArn
            this.networkInterfaceId = x.networkInterfaceId
            this.targetName = x.targetName
            this.volumeArn = x.volumeArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.AttachVolumeRequest = AttachVolumeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
