// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.serde

import aws.sdk.kotlin.services.storagegateway.model.DescribeCacheResponse
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeCacheOperationDeserializer: HttpDeserializer.NonStreaming<DescribeCacheResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeCacheResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCacheError(context, call, payload)
        }
        val builder = DescribeCacheResponse.Builder()

        if (payload != null) {
            deserializeDescribeCacheOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeCacheError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCacheOperationBody(builder: DescribeCacheResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CACHEALLOCATEDINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("CacheAllocatedInBytes"))
    val CACHEDIRTYPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("CacheDirtyPercentage"))
    val CACHEHITPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("CacheHitPercentage"))
    val CACHEMISSPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("CacheMissPercentage"))
    val CACHEUSEDPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("CacheUsedPercentage"))
    val DISKIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DiskIds"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHEALLOCATEDINBYTES_DESCRIPTOR)
        field(CACHEDIRTYPERCENTAGE_DESCRIPTOR)
        field(CACHEHITPERCENTAGE_DESCRIPTOR)
        field(CACHEMISSPERCENTAGE_DESCRIPTOR)
        field(CACHEUSEDPERCENTAGE_DESCRIPTOR)
        field(DISKIDS_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CACHEALLOCATEDINBYTES_DESCRIPTOR.index -> builder.cacheAllocatedInBytes = deserializeLong()
                CACHEDIRTYPERCENTAGE_DESCRIPTOR.index -> builder.cacheDirtyPercentage = deserializeDouble()
                CACHEHITPERCENTAGE_DESCRIPTOR.index -> builder.cacheHitPercentage = deserializeDouble()
                CACHEMISSPERCENTAGE_DESCRIPTOR.index -> builder.cacheMissPercentage = deserializeDouble()
                CACHEUSEDPERCENTAGE_DESCRIPTOR.index -> builder.cacheUsedPercentage = deserializeDouble()
                DISKIDS_DESCRIPTOR.index -> builder.diskIds =
                    deserializer.deserializeList(DISKIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
