// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a storage volume recovery point object.
 */
public class VolumeRecoveryPointInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the volume target.
     */
    public val volumeArn: kotlin.String? = builder.volumeArn
    /**
     * The time the recovery point was taken.
     */
    public val volumeRecoveryPointTime: kotlin.String? = builder.volumeRecoveryPointTime
    /**
     * The size of the volume in bytes.
     */
    public val volumeSizeInBytes: kotlin.Long = builder.volumeSizeInBytes
    /**
     * The size of the data stored on the volume in bytes.
     *
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     */
    public val volumeUsageInBytes: kotlin.Long = builder.volumeUsageInBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.VolumeRecoveryPointInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeRecoveryPointInfo(")
        append("volumeArn=$volumeArn,")
        append("volumeRecoveryPointTime=$volumeRecoveryPointTime,")
        append("volumeSizeInBytes=$volumeSizeInBytes,")
        append("volumeUsageInBytes=$volumeUsageInBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = volumeArn?.hashCode() ?: 0
        result = 31 * result + (volumeRecoveryPointTime?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        result = 31 * result + (volumeUsageInBytes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VolumeRecoveryPointInfo

        if (volumeArn != other.volumeArn) return false
        if (volumeRecoveryPointTime != other.volumeRecoveryPointTime) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false
        if (volumeUsageInBytes != other.volumeUsageInBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.VolumeRecoveryPointInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the volume target.
         */
        public var volumeArn: kotlin.String? = null
        /**
         * The time the recovery point was taken.
         */
        public var volumeRecoveryPointTime: kotlin.String? = null
        /**
         * The size of the volume in bytes.
         */
        public var volumeSizeInBytes: kotlin.Long = 0L
        /**
         * The size of the data stored on the volume in bytes.
         *
         * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
         */
        public var volumeUsageInBytes: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.VolumeRecoveryPointInfo) : this() {
            this.volumeArn = x.volumeArn
            this.volumeRecoveryPointTime = x.volumeRecoveryPointTime
            this.volumeSizeInBytes = x.volumeSizeInBytes
            this.volumeUsageInBytes = x.volumeUsageInBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.VolumeRecoveryPointInfo = VolumeRecoveryPointInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
