// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a storage volume object.
 */
public class VolumeInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.
     *
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public val gatewayId: kotlin.String? = builder.gatewayId
    /**
     * The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:
     *
     * `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB`
     *
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public val volumeArn: kotlin.String? = builder.volumeArn
    /**
     * One of the VolumeStatus values that indicates the state of the storage volume.
     */
    public val volumeAttachmentStatus: kotlin.String? = builder.volumeAttachmentStatus
    /**
     * The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name (ARN), which you use as input for other operations.
     *
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public val volumeId: kotlin.String? = builder.volumeId
    /**
     * The size of the volume in bytes.
     *
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    public val volumeSizeInBytes: kotlin.Long = builder.volumeSizeInBytes
    /**
     * One of the VolumeType enumeration values describing the type of the volume.
     */
    public val volumeType: kotlin.String? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.VolumeInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeInfo(")
        append("gatewayArn=$gatewayArn,")
        append("gatewayId=$gatewayId,")
        append("volumeArn=$volumeArn,")
        append("volumeAttachmentStatus=$volumeAttachmentStatus,")
        append("volumeId=$volumeId,")
        append("volumeSizeInBytes=$volumeSizeInBytes,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeAttachmentStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VolumeInfo

        if (gatewayArn != other.gatewayArn) return false
        if (gatewayId != other.gatewayId) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeAttachmentStatus != other.volumeAttachmentStatus) return false
        if (volumeId != other.volumeId) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.VolumeInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.
         *
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        public var gatewayId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the storage volume. For example, the following is a valid ARN:
         *
         * `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB`
         *
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        public var volumeArn: kotlin.String? = null
        /**
         * One of the VolumeStatus values that indicates the state of the storage volume.
         */
        public var volumeAttachmentStatus: kotlin.String? = null
        /**
         * The unique identifier assigned to the volume. This ID becomes part of the volume Amazon Resource Name (ARN), which you use as input for other operations.
         *
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        public var volumeId: kotlin.String? = null
        /**
         * The size of the volume in bytes.
         *
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        public var volumeSizeInBytes: kotlin.Long = 0L
        /**
         * One of the VolumeType enumeration values describing the type of the volume.
         */
        public var volumeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.VolumeInfo) : this() {
            this.gatewayArn = x.gatewayArn
            this.gatewayId = x.gatewayId
            this.volumeArn = x.volumeArn
            this.volumeAttachmentStatus = x.volumeAttachmentStatus
            this.volumeId = x.volumeId
            this.volumeSizeInBytes = x.volumeSizeInBytes
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.VolumeInfo = VolumeInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
