// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * UpdateNFSFileShareInput
 */
public class UpdateNfsFileShareRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public val auditDestinationArn: kotlin.String? = builder.auditDestinationArn
    /**
     * Specifies refresh cache information for the file share.
     */
    public val cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = builder.cacheAttributes
    /**
     * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.
     */
    public val clientList: List<String>? = builder.clientList
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
     *
     * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
     */
    public val defaultStorageClass: kotlin.String? = builder.defaultStorageClass
    /**
     * The Amazon Resource Name (ARN) of the file share to be updated.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * The name of the file share. Optional.
     *
     * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
     */
    public val fileShareName: kotlin.String? = builder.fileShareName
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
     *
     * Valid Values: `true` | `false`
     */
    public val guessMimeTypeEnabled: kotlin.Boolean? = builder.guessMimeTypeEnabled
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The default values for the file share. Optional.
     */
    public val nfsFileShareDefaults: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults? = builder.nfsFileShareDefaults
    /**
     * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
     *
     * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
     *
     * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
     *
     * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
     *
     * The following example sets `NotificationPolicy` off.
     *
     * `{}`
     */
    public val notificationPolicy: kotlin.String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
     */
    public val objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = builder.objectAcl
    /**
     * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
     *
     * Valid Values: `true` | `false`
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
     *
     * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
     *
     * Valid Values: `true` | `false`
     */
    public val requesterPays: kotlin.Boolean? = builder.requesterPays
    /**
     * The user mapped to anonymous user.
     *
     * Valid values are the following:
     * + `RootSquash`: Only root is mapped to anonymous user.
     * + `NoSquash`: No one is mapped to anonymous user.
     * + `AllSquash`: Everyone is mapped to anonymous user.
     */
    public val squash: kotlin.String? = builder.squash

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.UpdateNfsFileShareRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateNfsFileShareRequest(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("clientList=$clientList,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("fileShareArn=$fileShareArn,")
        append("fileShareName=$fileShareName,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("nfsFileShareDefaults=$nfsFileShareDefaults,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("squash=$squash")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (clientList?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (nfsFileShareDefaults?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (squash?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateNfsFileShareRequest

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (clientList != other.clientList) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (fileShareArn != other.fileShareArn) return false
        if (fileShareName != other.fileShareName) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (nfsFileShareDefaults != other.nfsFileShareDefaults) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (squash != other.squash) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.UpdateNfsFileShareRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        public var auditDestinationArn: kotlin.String? = null
        /**
         * Specifies refresh cache information for the file share.
         */
        public var cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = null
        /**
         * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.
         */
        public var clientList: List<String>? = null
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
         *
         * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
         */
        public var defaultStorageClass: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the file share to be updated.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * The name of the file share. Optional.
         *
         * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
         */
        public var fileShareName: kotlin.String? = null
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
         *
         * Valid Values: `true` | `false`
         */
        public var guessMimeTypeEnabled: kotlin.Boolean? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The default values for the file share. Optional.
         */
        public var nfsFileShareDefaults: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults? = null
        /**
         * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
         *
         * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
         *
         * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
         *
         * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
         *
         * The following example sets `NotificationPolicy` off.
         *
         * `{}`
         */
        public var notificationPolicy: kotlin.String? = null
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
         */
        public var objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = null
        /**
         * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
         *
         * Valid Values: `true` | `false`
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
         *
         * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
         *
         * Valid Values: `true` | `false`
         */
        public var requesterPays: kotlin.Boolean? = null
        /**
         * The user mapped to anonymous user.
         *
         * Valid values are the following:
         * + `RootSquash`: Only root is mapped to anonymous user.
         * + `NoSquash`: No one is mapped to anonymous user.
         * + `AllSquash`: Everyone is mapped to anonymous user.
         */
        public var squash: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.UpdateNfsFileShareRequest) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.clientList = x.clientList
            this.defaultStorageClass = x.defaultStorageClass
            this.fileShareArn = x.fileShareArn
            this.fileShareName = x.fileShareName
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.nfsFileShareDefaults = x.nfsFileShareDefaults
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.squash = x.squash
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.UpdateNfsFileShareRequest = UpdateNfsFileShareRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        public fun cacheAttributes(block: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.Builder.() -> kotlin.Unit) {
            this.cacheAttributes = aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults] inside the given [block]
         */
        public fun nfsFileShareDefaults(block: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults.Builder.() -> kotlin.Unit) {
            this.nfsFileShareDefaults = aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
