// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON object containing one or more of the following fields:
 * + UpdateChapCredentialsInput$InitiatorName
 * + UpdateChapCredentialsInput$SecretToAuthenticateInitiator
 * + UpdateChapCredentialsInput$SecretToAuthenticateTarget
 * + UpdateChapCredentialsInput$TargetARN
 */
public class UpdateChapCredentialsRequest private constructor(builder: Builder) {
    /**
     * The iSCSI initiator that connects to the target.
     */
    public val initiatorName: kotlin.String? = builder.initiatorName
    /**
     * The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.
     *
     * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
     */
    public val secretToAuthenticateInitiator: kotlin.String? = builder.secretToAuthenticateInitiator
    /**
     * The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).
     *
     * Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
     *
     * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
     */
    public val secretToAuthenticateTarget: kotlin.String? = builder.secretToAuthenticateTarget
    /**
     * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return the TargetARN for specified VolumeARN.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.UpdateChapCredentialsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateChapCredentialsRequest(")
        append("initiatorName=$initiatorName,")
        append("secretToAuthenticateInitiator=*** Sensitive Data Redacted ***,")
        append("secretToAuthenticateTarget=*** Sensitive Data Redacted ***,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = initiatorName?.hashCode() ?: 0
        result = 31 * result + (secretToAuthenticateInitiator?.hashCode() ?: 0)
        result = 31 * result + (secretToAuthenticateTarget?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateChapCredentialsRequest

        if (initiatorName != other.initiatorName) return false
        if (secretToAuthenticateInitiator != other.secretToAuthenticateInitiator) return false
        if (secretToAuthenticateTarget != other.secretToAuthenticateTarget) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.UpdateChapCredentialsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The iSCSI initiator that connects to the target.
         */
        public var initiatorName: kotlin.String? = null
        /**
         * The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.
         *
         * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
         */
        public var secretToAuthenticateInitiator: kotlin.String? = null
        /**
         * The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).
         *
         * Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
         *
         * The secret key must be between 12 and 16 bytes when encoded in UTF-8.
         */
        public var secretToAuthenticateTarget: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return the TargetARN for specified VolumeARN.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.UpdateChapCredentialsRequest) : this() {
            this.initiatorName = x.initiatorName
            this.secretToAuthenticateInitiator = x.secretToAuthenticateInitiator
            this.secretToAuthenticateTarget = x.secretToAuthenticateTarget
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.UpdateChapCredentialsRequest = UpdateChapCredentialsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
