// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a virtual tape.
 */
public class TapeInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The date that the tape entered the custom tape pool with tape retention lock enabled.
     */
    public val poolEntryDate: aws.smithy.kotlin.runtime.time.Instant? = builder.poolEntryDate
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public val poolId: kotlin.String? = builder.poolId
    /**
     * The date that the tape became subject to tape retention lock.
     */
    public val retentionStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.retentionStartDate
    /**
     * The Amazon Resource Name (ARN) of a virtual tape.
     */
    public val tapeArn: kotlin.String? = builder.tapeArn
    /**
     * The barcode that identifies a specific virtual tape.
     */
    public val tapeBarcode: kotlin.String? = builder.tapeBarcode
    /**
     * The size, in bytes, of a virtual tape.
     */
    public val tapeSizeInBytes: kotlin.Long? = builder.tapeSizeInBytes
    /**
     * The status of the tape.
     */
    public val tapeStatus: kotlin.String? = builder.tapeStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.TapeInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TapeInfo(")
        append("gatewayArn=$gatewayArn,")
        append("poolEntryDate=$poolEntryDate,")
        append("poolId=$poolId,")
        append("retentionStartDate=$retentionStartDate,")
        append("tapeArn=$tapeArn,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (poolEntryDate?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (retentionStartDate?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TapeInfo

        if (gatewayArn != other.gatewayArn) return false
        if (poolEntryDate != other.poolEntryDate) return false
        if (poolId != other.poolId) return false
        if (retentionStartDate != other.retentionStartDate) return false
        if (tapeArn != other.tapeArn) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.TapeInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The date that the tape entered the custom tape pool with tape retention lock enabled.
         */
        public var poolEntryDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * The date that the tape became subject to tape retention lock.
         */
        public var retentionStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of a virtual tape.
         */
        public var tapeArn: kotlin.String? = null
        /**
         * The barcode that identifies a specific virtual tape.
         */
        public var tapeBarcode: kotlin.String? = null
        /**
         * The size, in bytes, of a virtual tape.
         */
        public var tapeSizeInBytes: kotlin.Long? = null
        /**
         * The status of the tape.
         */
        public var tapeStatus: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.TapeInfo) : this() {
            this.gatewayArn = x.gatewayArn
            this.poolEntryDate = x.poolEntryDate
            this.poolId = x.poolId
            this.retentionStartDate = x.retentionStartDate
            this.tapeArn = x.tapeArn
            this.tapeBarcode = x.tapeBarcode
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.TapeInfo = TapeInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
