// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * RefreshCacheInput
 */
public class RefreshCacheRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the file share you want to refresh.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * A comma-separated list of the paths of folders to refresh in the cache. The default is &#91;`"/"`&#93;. The default refreshes objects and folders at the root of the Amazon S3 bucket. If `Recursive` is set to `true`, the entire S3 bucket that the file share has access to is refreshed.
     *
     * Do not include `/` when specifying folder names. For example, you would specify `samplefolder` rather than `samplefolder/`.
     */
    public val folderList: List<String>? = builder.folderList
    /**
     * A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that were in the cache the last time the gateway listed the folder's contents. If this value set to `true`, each folder that is listed in `FolderList` is recursively updated. Otherwise, subfolders listed in `FolderList` are not refreshed. Only objects that are in folders listed directly under `FolderList` are found and used for the update. The default is `true`.
     *
     * Valid Values: `true` | `false`
     */
    public val recursive: kotlin.Boolean? = builder.recursive

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.RefreshCacheRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RefreshCacheRequest(")
        append("fileShareArn=$fileShareArn,")
        append("folderList=$folderList,")
        append("recursive=$recursive")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileShareArn?.hashCode() ?: 0
        result = 31 * result + (folderList?.hashCode() ?: 0)
        result = 31 * result + (recursive?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RefreshCacheRequest

        if (fileShareArn != other.fileShareArn) return false
        if (folderList != other.folderList) return false
        if (recursive != other.recursive) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.RefreshCacheRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the file share you want to refresh.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * A comma-separated list of the paths of folders to refresh in the cache. The default is &#91;`"/"`&#93;. The default refreshes objects and folders at the root of the Amazon S3 bucket. If `Recursive` is set to `true`, the entire S3 bucket that the file share has access to is refreshed.
         *
         * Do not include `/` when specifying folder names. For example, you would specify `samplefolder` rather than `samplefolder/`.
         */
        public var folderList: List<String>? = null
        /**
         * A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that were in the cache the last time the gateway listed the folder's contents. If this value set to `true`, each folder that is listed in `FolderList` is recursively updated. Otherwise, subfolders listed in `FolderList` are not refreshed. Only objects that are in folders listed directly under `FolderList` are found and used for the update. The default is `true`.
         *
         * Valid Values: `true` | `false`
         */
        public var recursive: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.RefreshCacheRequest) : this() {
            this.fileShareArn = x.fileShareArn
            this.folderList = x.folderList
            this.recursive = x.recursive
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.RefreshCacheRequest = RefreshCacheRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
