// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Unix file permissions and ownership information assigned, by default, to native S3 objects when an S3 File Gateway discovers them in S3 buckets. This operation is only supported in S3 File Gateways.
 */
public class NfsFileShareInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public val auditDestinationArn: kotlin.String? = builder.auditDestinationArn
    /**
     * Specifies the Region of the S3 bucket where the NFS file share stores files.
     *
     * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    public val bucketRegion: kotlin.String? = builder.bucketRegion
    /**
     * Refresh cache information for the file share.
     */
    public val cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = builder.cacheAttributes
    /**
     * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.
     */
    public val clientList: List<String>? = builder.clientList
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
     *
     * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
     */
    public val defaultStorageClass: kotlin.String? = builder.defaultStorageClass
    /**
     * The Amazon Resource Name (ARN) of the file share.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * The ID of the file share.
     */
    public val fileShareId: kotlin.String? = builder.fileShareId
    /**
     * The name of the file share. Optional.
     *
     * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
     */
    public val fileShareName: kotlin.String? = builder.fileShareName
    /**
     * The status of the file share.
     *
     * Valid Values: `CREATING` | `UPDATING` | `AVAILABLE` | `DELETING`
     */
    public val fileShareStatus: kotlin.String? = builder.fileShareStatus
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
     *
     * Valid Values: `true` | `false`
     */
    public val guessMimeTypeEnabled: kotlin.Boolean? = builder.guessMimeTypeEnabled
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).
     *
     * You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.
     *
     * Bucket ARN:
     *
     * `arn:aws:s3:::my-bucket/prefix/`
     *
     * Access point ARN:
     *
     * `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
     *
     * If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see [Delegating access control to access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control) in the *Amazon S3 User Guide*.
     *
     * Access point alias:
     *
     * `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * Describes Network File System (NFS) file share default values. Files and folders stored as Amazon S3 objects in S3 buckets don't, by default, have Unix file permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects that represent files and folders are assigned these default Unix permissions. This operation is only supported for S3 File Gateways.
     */
    public val nfsFileShareDefaults: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults? = builder.nfsFileShareDefaults
    /**
     * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
     *
     * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
     *
     * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
     *
     * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
     *
     * The following example sets `NotificationPolicy` off.
     *
     * `{}`
     */
    public val notificationPolicy: kotlin.String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that an S3 File Gateway puts objects into. The default value is `private`.
     */
    public val objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = builder.objectAcl
    /**
     * The file share path used by the NFS client to identify the mount point.
     */
    public val path: kotlin.String? = builder.path
    /**
     * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
     *
     * Valid Values: `true` | `false`
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
     *
     * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
     *
     * Valid Values: `true` | `false`
     */
    public val requesterPays: kotlin.Boolean? = builder.requesterPays
    /**
     * The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying storage.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The user mapped to anonymous user. Valid options are the following:
     * + `RootSquash`: Only root is mapped to anonymous user.
     * + `NoSquash`: No one is mapped to anonymous user.
     * + `AllSquash`: Everyone is mapped to anonymous user.
     */
    public val squash: kotlin.String? = builder.squash
    /**
     * A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the `ListTagsForResource` API operation.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.
     *
     * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    public val vpcEndpointDnsName: kotlin.String? = builder.vpcEndpointDnsName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.NfsFileShareInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NfsFileShareInfo(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("bucketRegion=$bucketRegion,")
        append("cacheAttributes=$cacheAttributes,")
        append("clientList=$clientList,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("fileShareArn=$fileShareArn,")
        append("fileShareId=$fileShareId,")
        append("fileShareName=$fileShareName,")
        append("fileShareStatus=$fileShareStatus,")
        append("gatewayArn=$gatewayArn,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("locationArn=$locationArn,")
        append("nfsFileShareDefaults=$nfsFileShareDefaults,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("path=$path,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("role=$role,")
        append("squash=$squash,")
        append("tags=$tags,")
        append("vpcEndpointDnsName=$vpcEndpointDnsName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (bucketRegion?.hashCode() ?: 0)
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (clientList?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (fileShareId?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (fileShareStatus?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted.hashCode())
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (nfsFileShareDefaults?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (squash?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointDnsName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NfsFileShareInfo

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (bucketRegion != other.bucketRegion) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (clientList != other.clientList) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (fileShareArn != other.fileShareArn) return false
        if (fileShareId != other.fileShareId) return false
        if (fileShareName != other.fileShareName) return false
        if (fileShareStatus != other.fileShareStatus) return false
        if (gatewayArn != other.gatewayArn) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (locationArn != other.locationArn) return false
        if (nfsFileShareDefaults != other.nfsFileShareDefaults) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (path != other.path) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (role != other.role) return false
        if (squash != other.squash) return false
        if (tags != other.tags) return false
        if (vpcEndpointDnsName != other.vpcEndpointDnsName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.NfsFileShareInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        public var auditDestinationArn: kotlin.String? = null
        /**
         * Specifies the Region of the S3 bucket where the NFS file share stores files.
         *
         * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        public var bucketRegion: kotlin.String? = null
        /**
         * Refresh cache information for the file share.
         */
        public var cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = null
        /**
         * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.
         */
        public var clientList: List<String>? = null
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
         *
         * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
         */
        public var defaultStorageClass: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * The ID of the file share.
         */
        public var fileShareId: kotlin.String? = null
        /**
         * The name of the file share. Optional.
         *
         * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
         */
        public var fileShareName: kotlin.String? = null
        /**
         * The status of the file share.
         *
         * Valid Values: `CREATING` | `UPDATING` | `AVAILABLE` | `DELETING`
         */
        public var fileShareStatus: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
         *
         * Valid Values: `true` | `false`
         */
        public var guessMimeTypeEnabled: kotlin.Boolean? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).
         *
         * You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.
         *
         * Bucket ARN:
         *
         * `arn:aws:s3:::my-bucket/prefix/`
         *
         * Access point ARN:
         *
         * `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
         *
         * If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see [Delegating access control to access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control) in the *Amazon S3 User Guide*.
         *
         * Access point alias:
         *
         * `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
         */
        public var locationArn: kotlin.String? = null
        /**
         * Describes Network File System (NFS) file share default values. Files and folders stored as Amazon S3 objects in S3 buckets don't, by default, have Unix file permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects that represent files and folders are assigned these default Unix permissions. This operation is only supported for S3 File Gateways.
         */
        public var nfsFileShareDefaults: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults? = null
        /**
         * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
         *
         * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
         *
         * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
         *
         * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
         *
         * The following example sets `NotificationPolicy` off.
         *
         * `{}`
         */
        public var notificationPolicy: kotlin.String? = null
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that an S3 File Gateway puts objects into. The default value is `private`.
         */
        public var objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = null
        /**
         * The file share path used by the NFS client to identify the mount point.
         */
        public var path: kotlin.String? = null
        /**
         * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
         *
         * Valid Values: `true` | `false`
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
         *
         * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
         *
         * Valid Values: `true` | `false`
         */
        public var requesterPays: kotlin.Boolean? = null
        /**
         * The ARN of the IAM role that an S3 File Gateway assumes when it accesses the underlying storage.
         */
        public var role: kotlin.String? = null
        /**
         * The user mapped to anonymous user. Valid options are the following:
         * + `RootSquash`: Only root is mapped to anonymous user.
         * + `NoSquash`: No one is mapped to anonymous user.
         * + `AllSquash`: Everyone is mapped to anonymous user.
         */
        public var squash: kotlin.String? = null
        /**
         * A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the `ListTagsForResource` API operation.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.
         *
         * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        public var vpcEndpointDnsName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareInfo) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.bucketRegion = x.bucketRegion
            this.cacheAttributes = x.cacheAttributes
            this.clientList = x.clientList
            this.defaultStorageClass = x.defaultStorageClass
            this.fileShareArn = x.fileShareArn
            this.fileShareId = x.fileShareId
            this.fileShareName = x.fileShareName
            this.fileShareStatus = x.fileShareStatus
            this.gatewayArn = x.gatewayArn
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.locationArn = x.locationArn
            this.nfsFileShareDefaults = x.nfsFileShareDefaults
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.path = x.path
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.role = x.role
            this.squash = x.squash
            this.tags = x.tags
            this.vpcEndpointDnsName = x.vpcEndpointDnsName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.NfsFileShareInfo = NfsFileShareInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        public fun cacheAttributes(block: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.Builder.() -> kotlin.Unit) {
            this.cacheAttributes = aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults] inside the given [block]
         */
        public fun nfsFileShareDefaults(block: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults.Builder.() -> kotlin.Unit) {
            this.nfsFileShareDefaults = aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
