// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes Network File System (NFS) file share default values. Files and folders stored as Amazon S3 objects in S3 buckets don't, by default, have Unix file permissions assigned to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects that represent files and folders are assigned these default Unix permissions. This operation is only supported for S3 File Gateways.
 */
public class NfsFileShareDefaults private constructor(builder: Builder) {
    /**
     * The Unix directory mode in the form "nnnn". For example, `0666` represents the default access mode for all directories inside the file share. The default value is `0777`.
     */
    public val directoryMode: kotlin.String? = builder.directoryMode
    /**
     * The Unix file mode in the form "nnnn". For example, `0666` represents the default file mode inside the file share. The default value is `0666`.
     */
    public val fileMode: kotlin.String? = builder.fileMode
    /**
     * The default group ID for the file share (unless the files have another group ID specified). The default value is `nfsnobody`.
     */
    public val groupId: kotlin.Long? = builder.groupId
    /**
     * The default owner ID for files in the file share (unless the files have another owner ID specified). The default value is `nfsnobody`.
     */
    public val ownerId: kotlin.Long? = builder.ownerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NfsFileShareDefaults(")
        append("directoryMode=$directoryMode,")
        append("fileMode=$fileMode,")
        append("groupId=$groupId,")
        append("ownerId=$ownerId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = directoryMode?.hashCode() ?: 0
        result = 31 * result + (fileMode?.hashCode() ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NfsFileShareDefaults

        if (directoryMode != other.directoryMode) return false
        if (fileMode != other.fileMode) return false
        if (groupId != other.groupId) return false
        if (ownerId != other.ownerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Unix directory mode in the form "nnnn". For example, `0666` represents the default access mode for all directories inside the file share. The default value is `0777`.
         */
        public var directoryMode: kotlin.String? = null
        /**
         * The Unix file mode in the form "nnnn". For example, `0666` represents the default file mode inside the file share. The default value is `0666`.
         */
        public var fileMode: kotlin.String? = null
        /**
         * The default group ID for the file share (unless the files have another group ID specified). The default value is `nfsnobody`.
         */
        public var groupId: kotlin.Long? = null
        /**
         * The default owner ID for files in the file share (unless the files have another owner ID specified). The default value is `nfsnobody`.
         */
        public var ownerId: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults) : this() {
            this.directoryMode = x.directoryMode
            this.fileMode = x.fileMode
            this.groupId = x.groupId
            this.ownerId = x.ownerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults = NfsFileShareDefaults(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
