// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * JoinDomainOutput
 */
public class JoinDomainResponse private constructor(builder: Builder) {
    /**
     * Indicates the status of the gateway as a member of the Active Directory domain.
     * + `ACCESS_DENIED`: Indicates that the `JoinDomain` operation failed due to an authentication error.
     * + `DETACHED`: Indicates that gateway is not joined to a domain.
     * + `JOINED`: Indicates that the gateway has successfully joined a domain.
     * + `JOINING`: Indicates that a `JoinDomain` operation is in progress.
     * + `NETWORK_ERROR`: Indicates that `JoinDomain` operation failed due to a network or connectivity error.
     * + `TIMEOUT`: Indicates that the `JoinDomain` operation failed because the operation didn't complete within the allotted time.
     * + `UNKNOWN_ERROR`: Indicates that the `JoinDomain` operation failed due to another type of error.
     */
    public val activeDirectoryStatus: aws.sdk.kotlin.services.storagegateway.model.ActiveDirectoryStatus? = builder.activeDirectoryStatus
    /**
     * The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.JoinDomainResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JoinDomainResponse(")
        append("activeDirectoryStatus=$activeDirectoryStatus,")
        append("gatewayArn=$gatewayArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryStatus?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JoinDomainResponse

        if (activeDirectoryStatus != other.activeDirectoryStatus) return false
        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.JoinDomainResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the status of the gateway as a member of the Active Directory domain.
         * + `ACCESS_DENIED`: Indicates that the `JoinDomain` operation failed due to an authentication error.
         * + `DETACHED`: Indicates that gateway is not joined to a domain.
         * + `JOINED`: Indicates that the gateway has successfully joined a domain.
         * + `JOINING`: Indicates that a `JoinDomain` operation is in progress.
         * + `NETWORK_ERROR`: Indicates that `JoinDomain` operation failed due to a network or connectivity error.
         * + `TIMEOUT`: Indicates that the `JoinDomain` operation failed because the operation didn't complete within the allotted time.
         * + `UNKNOWN_ERROR`: Indicates that the `JoinDomain` operation failed due to another type of error.
         */
        public var activeDirectoryStatus: aws.sdk.kotlin.services.storagegateway.model.ActiveDirectoryStatus? = null
        /**
         * The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
         */
        public var gatewayArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.JoinDomainResponse) : this() {
            this.activeDirectoryStatus = x.activeDirectoryStatus
            this.gatewayArn = x.gatewayArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.JoinDomainResponse = JoinDomainResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
