// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON object containing the following fields:
 */
public class DescribeGatewayInformationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway. This field only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * Date after which this gateway will not receive software updates for new features and bug fixes.
     */
    public val deprecationDate: kotlin.String? = builder.deprecationDate
    /**
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    public val ec2InstanceId: kotlin.String? = builder.ec2InstanceId
    /**
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     */
    public val ec2InstanceRegion: kotlin.String? = builder.ec2InstanceRegion
    /**
     * The type of endpoint for your gateway.
     *
     * Valid Values: `STANDARD` | `FIPS`
     */
    public val endpointType: kotlin.String? = builder.endpointType
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * Specifies the size of the gateway's metadata cache.
     */
    public val gatewayCapacity: aws.sdk.kotlin.services.storagegateway.model.GatewayCapacity? = builder.gatewayCapacity
    /**
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.
     */
    public val gatewayId: kotlin.String? = builder.gatewayId
    /**
     * The name you configured for your gateway.
     */
    public val gatewayName: kotlin.String? = builder.gatewayName
    /**
     * A NetworkInterface array that contains descriptions of the gateway network interfaces.
     */
    public val gatewayNetworkInterfaces: List<NetworkInterface>? = builder.gatewayNetworkInterfaces
    /**
     * A value that indicates the operating state of the gateway.
     */
    public val gatewayState: kotlin.String? = builder.gatewayState
    /**
     * A value that indicates the time zone configured for the gateway.
     */
    public val gatewayTimezone: kotlin.String? = builder.gatewayTimezone
    /**
     * The type of the gateway.
     */
    public val gatewayType: kotlin.String? = builder.gatewayType
    /**
     * The type of hardware or software platform on which the gateway is running.
     *
     * Tape Gateway is no longer available on Snow Family devices.
     */
    public val hostEnvironment: aws.sdk.kotlin.services.storagegateway.model.HostEnvironment? = builder.hostEnvironment
    /**
     * A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.
     */
    public val hostEnvironmentId: kotlin.String? = builder.hostEnvironmentId
    /**
     * The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response. This only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM
     */
    public val lastSoftwareUpdate: kotlin.String? = builder.lastSoftwareUpdate
    /**
     * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.
     */
    public val nextUpdateAvailabilityDate: kotlin.String? = builder.nextUpdateAvailabilityDate
    /**
     * Date after which this gateway will not receive software updates for new features.
     */
    public val softwareUpdatesEndDate: kotlin.String? = builder.softwareUpdatesEndDate
    /**
     * The version number of the software running on the gateway appliance.
     */
    public val softwareVersion: kotlin.String? = builder.softwareVersion
    /**
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     */
    public val supportedGatewayCapacities: List<GatewayCapacity>? = builder.supportedGatewayCapacities
    /**
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the `ListTagsForResource` API operation.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     */
    public val vpcEndpoint: kotlin.String? = builder.vpcEndpoint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.DescribeGatewayInformationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGatewayInformationResponse(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("deprecationDate=$deprecationDate,")
        append("ec2InstanceId=$ec2InstanceId,")
        append("ec2InstanceRegion=$ec2InstanceRegion,")
        append("endpointType=$endpointType,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayCapacity=$gatewayCapacity,")
        append("gatewayId=$gatewayId,")
        append("gatewayName=$gatewayName,")
        append("gatewayNetworkInterfaces=$gatewayNetworkInterfaces,")
        append("gatewayState=$gatewayState,")
        append("gatewayTimezone=$gatewayTimezone,")
        append("gatewayType=$gatewayType,")
        append("hostEnvironment=$hostEnvironment,")
        append("hostEnvironmentId=$hostEnvironmentId,")
        append("lastSoftwareUpdate=$lastSoftwareUpdate,")
        append("nextUpdateAvailabilityDate=$nextUpdateAvailabilityDate,")
        append("softwareUpdatesEndDate=$softwareUpdatesEndDate,")
        append("softwareVersion=$softwareVersion,")
        append("supportedGatewayCapacities=$supportedGatewayCapacities,")
        append("tags=$tags,")
        append("vpcEndpoint=$vpcEndpoint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (deprecationDate?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceId?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceRegion?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayCapacity?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayNetworkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (gatewayState?.hashCode() ?: 0)
        result = 31 * result + (gatewayTimezone?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (hostEnvironment?.hashCode() ?: 0)
        result = 31 * result + (hostEnvironmentId?.hashCode() ?: 0)
        result = 31 * result + (lastSoftwareUpdate?.hashCode() ?: 0)
        result = 31 * result + (nextUpdateAvailabilityDate?.hashCode() ?: 0)
        result = 31 * result + (softwareUpdatesEndDate?.hashCode() ?: 0)
        result = 31 * result + (softwareVersion?.hashCode() ?: 0)
        result = 31 * result + (supportedGatewayCapacities?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGatewayInformationResponse

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (deprecationDate != other.deprecationDate) return false
        if (ec2InstanceId != other.ec2InstanceId) return false
        if (ec2InstanceRegion != other.ec2InstanceRegion) return false
        if (endpointType != other.endpointType) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayCapacity != other.gatewayCapacity) return false
        if (gatewayId != other.gatewayId) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayNetworkInterfaces != other.gatewayNetworkInterfaces) return false
        if (gatewayState != other.gatewayState) return false
        if (gatewayTimezone != other.gatewayTimezone) return false
        if (gatewayType != other.gatewayType) return false
        if (hostEnvironment != other.hostEnvironment) return false
        if (hostEnvironmentId != other.hostEnvironmentId) return false
        if (lastSoftwareUpdate != other.lastSoftwareUpdate) return false
        if (nextUpdateAvailabilityDate != other.nextUpdateAvailabilityDate) return false
        if (softwareUpdatesEndDate != other.softwareUpdatesEndDate) return false
        if (softwareVersion != other.softwareVersion) return false
        if (supportedGatewayCapacities != other.supportedGatewayCapacities) return false
        if (tags != other.tags) return false
        if (vpcEndpoint != other.vpcEndpoint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.DescribeGatewayInformationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway. This field only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * Date after which this gateway will not receive software updates for new features and bug fixes.
         */
        public var deprecationDate: kotlin.String? = null
        /**
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         */
        public var ec2InstanceId: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the Amazon EC2 instance is located.
         */
        public var ec2InstanceRegion: kotlin.String? = null
        /**
         * The type of endpoint for your gateway.
         *
         * Valid Values: `STANDARD` | `FIPS`
         */
        public var endpointType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * Specifies the size of the gateway's metadata cache.
         */
        public var gatewayCapacity: aws.sdk.kotlin.services.storagegateway.model.GatewayCapacity? = null
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.
         */
        public var gatewayId: kotlin.String? = null
        /**
         * The name you configured for your gateway.
         */
        public var gatewayName: kotlin.String? = null
        /**
         * A NetworkInterface array that contains descriptions of the gateway network interfaces.
         */
        public var gatewayNetworkInterfaces: List<NetworkInterface>? = null
        /**
         * A value that indicates the operating state of the gateway.
         */
        public var gatewayState: kotlin.String? = null
        /**
         * A value that indicates the time zone configured for the gateway.
         */
        public var gatewayTimezone: kotlin.String? = null
        /**
         * The type of the gateway.
         */
        public var gatewayType: kotlin.String? = null
        /**
         * The type of hardware or software platform on which the gateway is running.
         *
         * Tape Gateway is no longer available on Snow Family devices.
         */
        public var hostEnvironment: aws.sdk.kotlin.services.storagegateway.model.HostEnvironment? = null
        /**
         * A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.
         */
        public var hostEnvironmentId: kotlin.String? = null
        /**
         * The date on which the last software update was applied to the gateway. If the gateway has never been updated, this field does not return a value in the response. This only only exist and returns once it have been chosen and set by the SGW service, based on the OS version of the gateway VM
         */
        public var lastSoftwareUpdate: kotlin.String? = null
        /**
         * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the gateway is not available for an update this field is not returned in the response.
         */
        public var nextUpdateAvailabilityDate: kotlin.String? = null
        /**
         * Date after which this gateway will not receive software updates for new features.
         */
        public var softwareUpdatesEndDate: kotlin.String? = null
        /**
         * The version number of the software running on the gateway appliance.
         */
        public var softwareVersion: kotlin.String? = null
        /**
         * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
         */
        public var supportedGatewayCapacities: List<GatewayCapacity>? = null
        /**
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the `ListTagsForResource` API operation.
         */
        public var tags: List<Tag>? = null
        /**
         * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
         */
        public var vpcEndpoint: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.DescribeGatewayInformationResponse) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.deprecationDate = x.deprecationDate
            this.ec2InstanceId = x.ec2InstanceId
            this.ec2InstanceRegion = x.ec2InstanceRegion
            this.endpointType = x.endpointType
            this.gatewayArn = x.gatewayArn
            this.gatewayCapacity = x.gatewayCapacity
            this.gatewayId = x.gatewayId
            this.gatewayName = x.gatewayName
            this.gatewayNetworkInterfaces = x.gatewayNetworkInterfaces
            this.gatewayState = x.gatewayState
            this.gatewayTimezone = x.gatewayTimezone
            this.gatewayType = x.gatewayType
            this.hostEnvironment = x.hostEnvironment
            this.hostEnvironmentId = x.hostEnvironmentId
            this.lastSoftwareUpdate = x.lastSoftwareUpdate
            this.nextUpdateAvailabilityDate = x.nextUpdateAvailabilityDate
            this.softwareUpdatesEndDate = x.softwareUpdatesEndDate
            this.softwareVersion = x.softwareVersion
            this.supportedGatewayCapacities = x.supportedGatewayCapacities
            this.tags = x.tags
            this.vpcEndpoint = x.vpcEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.DescribeGatewayInformationResponse = DescribeGatewayInformationResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
