// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON object containing the following fields:
 */
public class DescribeChapCredentialsResponse private constructor(builder: Builder) {
    /**
     * An array of ChapInfo objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:
     * + **InitiatorName**: The iSCSI initiator that connects to the target.
     * + **SecretToAuthenticateInitiator**: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.
     * + **SecretToAuthenticateTarget**: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).
     * + **TargetARN**: The Amazon Resource Name (ARN) of the storage volume.
     */
    public val chapCredentials: List<ChapInfo>? = builder.chapCredentials

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.DescribeChapCredentialsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeChapCredentialsResponse(")
        append("chapCredentials=$chapCredentials")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = chapCredentials?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeChapCredentialsResponse

        if (chapCredentials != other.chapCredentials) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.DescribeChapCredentialsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of ChapInfo objects that represent CHAP credentials. Each object in the array contains CHAP credential information for one target-initiator pair. If no CHAP credentials are set, an empty array is returned. CHAP credential information is provided in a JSON object with the following fields:
         * + **InitiatorName**: The iSCSI initiator that connects to the target.
         * + **SecretToAuthenticateInitiator**: The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.
         * + **SecretToAuthenticateTarget**: The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client).
         * + **TargetARN**: The Amazon Resource Name (ARN) of the storage volume.
         */
        public var chapCredentials: List<ChapInfo>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.DescribeChapCredentialsResponse) : this() {
            this.chapCredentials = x.chapCredentials
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.DescribeChapCredentialsResponse = DescribeChapCredentialsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
