// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * DeleteFileShareInput
 */
public class DeleteFileShareRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the file share to be deleted.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * If this value is set to `true`, the operation deletes a file share immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the file share enters the `FORCE_DELETING` status.
     *
     * Valid Values: `true` | `false`
     */
    public val forceDelete: kotlin.Boolean? = builder.forceDelete

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.DeleteFileShareRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteFileShareRequest(")
        append("fileShareArn=$fileShareArn,")
        append("forceDelete=$forceDelete")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileShareArn?.hashCode() ?: 0
        result = 31 * result + (forceDelete?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteFileShareRequest

        if (fileShareArn != other.fileShareArn) return false
        if (forceDelete != other.forceDelete) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.DeleteFileShareRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the file share to be deleted.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * If this value is set to `true`, the operation deletes a file share immediately and aborts all data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon Web Services. This process aborts the data upload process, and the file share enters the `FORCE_DELETING` status.
         *
         * Valid Values: `true` | `false`
         */
        public var forceDelete: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.DeleteFileShareRequest) : this() {
            this.fileShareArn = x.fileShareArn
            this.forceDelete = x.forceDelete
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.DeleteFileShareRequest = DeleteFileShareRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
