// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CreateTapesInput
 */
public class CreateTapesRequest private constructor(builder: Builder) {
    /**
     * A unique identifier that you use to retry a request. If you retry a request, use the same `ClientToken` you specified in the initial request.
     *
     * Using the same `ClientToken` prevents creating the tape multiple times.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The number of virtual tapes that you want to create.
     */
    public val numTapesToCreate: kotlin.Int? = builder.numTapesToCreate
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public val poolId: kotlin.String? = builder.poolId
    /**
     * A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.
     *
     * The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
     */
    public val tapeBarcodePrefix: kotlin.String? = builder.tapeBarcodePrefix
    /**
     * The size, in bytes, of the virtual tapes that you want to create.
     *
     * The size must be aligned by gigabyte (1024*1024*1024 bytes).
     */
    public val tapeSizeInBytes: kotlin.Long? = builder.tapeSizeInBytes
    /**
     * Set to `TRUE` if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.
     */
    public val worm: kotlin.Boolean? = builder.worm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CreateTapesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTapesRequest(")
        append("clientToken=$clientToken,")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("numTapesToCreate=$numTapesToCreate,")
        append("poolId=$poolId,")
        append("tags=$tags,")
        append("tapeBarcodePrefix=$tapeBarcodePrefix,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("worm=$worm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (numTapesToCreate ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcodePrefix?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (worm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTapesRequest

        if (clientToken != other.clientToken) return false
        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (numTapesToCreate != other.numTapesToCreate) return false
        if (poolId != other.poolId) return false
        if (tags != other.tags) return false
        if (tapeBarcodePrefix != other.tapeBarcodePrefix) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CreateTapesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier that you use to retry a request. If you retry a request, use the same `ClientToken` you specified in the initial request.
         *
         * Using the same `ClientToken` prevents creating the tape multiple times.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The number of virtual tapes that you want to create.
         */
        public var numTapesToCreate: kotlin.Int? = null
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
         */
        public var tags: List<Tag>? = null
        /**
         * A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.
         *
         * The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
         */
        public var tapeBarcodePrefix: kotlin.String? = null
        /**
         * The size, in bytes, of the virtual tapes that you want to create.
         *
         * The size must be aligned by gigabyte (1024*1024*1024 bytes).
         */
        public var tapeSizeInBytes: kotlin.Long? = null
        /**
         * Set to `TRUE` if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.
         */
        public var worm: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CreateTapesRequest) : this() {
            this.clientToken = x.clientToken
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.numTapesToCreate = x.numTapesToCreate
            this.poolId = x.poolId
            this.tags = x.tags
            this.tapeBarcodePrefix = x.tapeBarcodePrefix
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.worm = x.worm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CreateTapesRequest = CreateTapesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
