// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CreateTapeWithBarcodeInput
 */
public class CreateTapeWithBarcodeRequest private constructor(builder: Builder) {
    /**
     * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.
     */
    public val poolId: kotlin.String? = builder.poolId
    /**
     * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The barcode that you want to assign to the tape.
     *
     * Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
     */
    public val tapeBarcode: kotlin.String? = builder.tapeBarcode
    /**
     * The size, in bytes, of the virtual tape that you want to create.
     *
     * The size must be aligned by gigabyte (1024*1024*1024 bytes).
     */
    public val tapeSizeInBytes: kotlin.Long? = builder.tapeSizeInBytes
    /**
     * Set to `TRUE` if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.
     */
    public val worm: kotlin.Boolean? = builder.worm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CreateTapeWithBarcodeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTapeWithBarcodeRequest(")
        append("gatewayArn=$gatewayArn,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("poolId=$poolId,")
        append("tags=$tags,")
        append("tapeBarcode=$tapeBarcode,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("worm=$worm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tapeBarcode?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (worm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTapeWithBarcodeRequest

        if (gatewayArn != other.gatewayArn) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (poolId != other.poolId) return false
        if (tags != other.tags) return false
        if (tapeBarcode != other.tapeBarcode) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CreateTapeWithBarcodeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
         */
        public var tags: List<Tag>? = null
        /**
         * The barcode that you want to assign to the tape.
         *
         * Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
         */
        public var tapeBarcode: kotlin.String? = null
        /**
         * The size, in bytes, of the virtual tape that you want to create.
         *
         * The size must be aligned by gigabyte (1024*1024*1024 bytes).
         */
        public var tapeSizeInBytes: kotlin.Long? = null
        /**
         * Set to `TRUE` if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.
         */
        public var worm: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CreateTapeWithBarcodeRequest) : this() {
            this.gatewayArn = x.gatewayArn
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.poolId = x.poolId
            this.tags = x.tags
            this.tapeBarcode = x.tapeBarcode
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.worm = x.worm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CreateTapeWithBarcodeRequest = CreateTapeWithBarcodeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
