// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AssociateFileSystemRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    public val auditDestinationArn: kotlin.String? = builder.auditDestinationArn
    /**
     * The refresh cache information for the file share or FSx file systems.
     */
    public val cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = builder.cacheAttributes
    /**
     * A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system association creation.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
     *
     * If multiple file systems are associated with this gateway, this parameter's `IpAddresses` field is required.
     */
    public val endpointNetworkConfiguration: aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration? = builder.endpointNetworkConfiguration
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * The password of the user credential.
     */
    public val password: kotlin.String? = builder.password
    /**
     * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.AssociateFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateFileSystemRequest(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("clientToken=$clientToken,")
        append("endpointNetworkConfiguration=$endpointNetworkConfiguration,")
        append("gatewayArn=$gatewayArn,")
        append("locationArn=$locationArn,")
        append("password=*** Sensitive Data Redacted ***,")
        append("tags=$tags,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (endpointNetworkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateFileSystemRequest

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (clientToken != other.clientToken) return false
        if (endpointNetworkConfiguration != other.endpointNetworkConfiguration) return false
        if (gatewayArn != other.gatewayArn) return false
        if (locationArn != other.locationArn) return false
        if (password != other.password) return false
        if (tags != other.tags) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.AssociateFileSystemRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         */
        public var auditDestinationArn: kotlin.String? = null
        /**
         * The refresh cache information for the file share or FSx file systems.
         */
        public var cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = null
        /**
         * A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system association creation.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
         *
         * If multiple file systems are associated with this gateway, this parameter's `IpAddresses` field is required.
         */
        public var endpointNetworkConfiguration: aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.
         */
        public var locationArn: kotlin.String? = null
        /**
         * The password of the user credential.
         */
        public var password: kotlin.String? = null
        /**
         * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
         */
        public var tags: List<Tag>? = null
        /**
         * The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.AssociateFileSystemRequest) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.clientToken = x.clientToken
            this.endpointNetworkConfiguration = x.endpointNetworkConfiguration
            this.gatewayArn = x.gatewayArn
            this.locationArn = x.locationArn
            this.password = x.password
            this.tags = x.tags
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.AssociateFileSystemRequest = AssociateFileSystemRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        public fun cacheAttributes(block: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.Builder.() -> kotlin.Unit) {
            this.cacheAttributes = aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration] inside the given [block]
         */
        public fun endpointNetworkConfiguration(block: aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointNetworkConfiguration = aws.sdk.kotlin.services.storagegateway.model.EndpointNetworkConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
