// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON object containing one or more of the following fields:
 * + ActivateGatewayInput$ActivationKey
 * + ActivateGatewayInput$GatewayName
 * + ActivateGatewayInput$GatewayRegion
 * + ActivateGatewayInput$GatewayTimezone
 * + ActivateGatewayInput$GatewayType
 * + ActivateGatewayInput$MediumChangerType
 * + ActivateGatewayInput$TapeDriveType
 */
public class ActivateGatewayRequest private constructor(builder: Builder) {
    /**
     * Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the activation key for your gateway in the query string parameter `activationKey`. It may also include other activation-related parameters, however, these are merely defaults -- the arguments you pass to the `ActivateGateway` API call determine the actual configuration of your gateway.
     *
     * For more information, see [Getting activation key](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html) in the *Storage Gateway User Guide*.
     */
    public val activationKey: kotlin.String? = builder.activationKey
    /**
     * The name you configured for your gateway.
     */
    public val gatewayName: kotlin.String? = builder.gatewayName
    /**
     * A value that indicates the Amazon Web Services Region where you want to store your data. The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web Services Region in your `Host` header in the request. For more information about available Amazon Web Services Regions and endpoints for Storage Gateway, see [ Storage Gateway endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sg.html) in the *Amazon Web Services General Reference*.
     *
     * Valid Values: See [ Storage Gateway endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sg.html) in the *Amazon Web Services General Reference*.
     */
    public val gatewayRegion: kotlin.String? = builder.gatewayRegion
    /**
     * A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, GMT indicates Greenwich Mean Time without any offset. GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
     */
    public val gatewayTimezone: kotlin.String? = builder.gatewayTimezone
    /**
     * A value that defines the type of gateway to activate. The type specified is critical to all later functions of the gateway and cannot be changed after activation. The default value is `CACHED`.
     *
     * Valid Values: `STORED` | `CACHED` | `VTL` | `FILE_S3` | `FILE_FSX_SMB`
     */
    public val gatewayType: kotlin.String? = builder.gatewayType
    /**
     * The value that indicates the type of medium changer to use for tape gateway. This field is optional.
     *
     * Valid Values: `STK-L700` | `AWS-Gateway-VTL` | `IBM-03584L32-0402`
     */
    public val mediumChangerType: kotlin.String? = builder.mediumChangerType
    /**
     * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The value that indicates the type of tape drive to use for tape gateway. This field is optional.
     *
     * Valid Values: `IBM-ULT3580-TD5`
     */
    public val tapeDriveType: kotlin.String? = builder.tapeDriveType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.ActivateGatewayRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActivateGatewayRequest(")
        append("activationKey=$activationKey,")
        append("gatewayName=$gatewayName,")
        append("gatewayRegion=$gatewayRegion,")
        append("gatewayTimezone=$gatewayTimezone,")
        append("gatewayType=$gatewayType,")
        append("mediumChangerType=$mediumChangerType,")
        append("tags=$tags,")
        append("tapeDriveType=$tapeDriveType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationKey?.hashCode() ?: 0
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayRegion?.hashCode() ?: 0)
        result = 31 * result + (gatewayTimezone?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (mediumChangerType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tapeDriveType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActivateGatewayRequest

        if (activationKey != other.activationKey) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayRegion != other.gatewayRegion) return false
        if (gatewayTimezone != other.gatewayTimezone) return false
        if (gatewayType != other.gatewayType) return false
        if (mediumChangerType != other.mediumChangerType) return false
        if (tags != other.tags) return false
        if (tapeDriveType != other.tapeDriveType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.ActivateGatewayRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the activation key for your gateway in the query string parameter `activationKey`. It may also include other activation-related parameters, however, these are merely defaults -- the arguments you pass to the `ActivateGateway` API call determine the actual configuration of your gateway.
         *
         * For more information, see [Getting activation key](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html) in the *Storage Gateway User Guide*.
         */
        public var activationKey: kotlin.String? = null
        /**
         * The name you configured for your gateway.
         */
        public var gatewayName: kotlin.String? = null
        /**
         * A value that indicates the Amazon Web Services Region where you want to store your data. The gateway Amazon Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web Services Region in your `Host` header in the request. For more information about available Amazon Web Services Regions and endpoints for Storage Gateway, see [ Storage Gateway endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sg.html) in the *Amazon Web Services General Reference*.
         *
         * Valid Values: See [ Storage Gateway endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sg.html) in the *Amazon Web Services General Reference*.
         */
        public var gatewayRegion: kotlin.String? = null
        /**
         * A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, GMT indicates Greenwich Mean Time without any offset. GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
         */
        public var gatewayTimezone: kotlin.String? = null
        /**
         * A value that defines the type of gateway to activate. The type specified is critical to all later functions of the gateway and cannot be changed after activation. The default value is `CACHED`.
         *
         * Valid Values: `STORED` | `CACHED` | `VTL` | `FILE_S3` | `FILE_FSX_SMB`
         */
        public var gatewayType: kotlin.String? = null
        /**
         * The value that indicates the type of medium changer to use for tape gateway. This field is optional.
         *
         * Valid Values: `STK-L700` | `AWS-Gateway-VTL` | `IBM-03584L32-0402`
         */
        public var mediumChangerType: kotlin.String? = null
        /**
         * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters.
         */
        public var tags: List<Tag>? = null
        /**
         * The value that indicates the type of tape drive to use for tape gateway. This field is optional.
         *
         * Valid Values: `IBM-ULT3580-TD5`
         */
        public var tapeDriveType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.ActivateGatewayRequest) : this() {
            this.activationKey = x.activationKey
            this.gatewayName = x.gatewayName
            this.gatewayRegion = x.gatewayRegion
            this.gatewayTimezone = x.gatewayTimezone
            this.gatewayType = x.gatewayType
            this.mediumChangerType = x.mediumChangerType
            this.tags = x.tags
            this.tapeDriveType = x.tapeDriveType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.ActivateGatewayRequest = ActivateGatewayRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
