// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.storagegateway.auth.DefaultStorageGatewayAuthSchemeProvider
import aws.sdk.kotlin.services.storagegateway.auth.StorageGatewayAuthSchemeProvider
import aws.sdk.kotlin.services.storagegateway.endpoints.DefaultStorageGatewayEndpointProvider
import aws.sdk.kotlin.services.storagegateway.endpoints.StorageGatewayEndpointParameters
import aws.sdk.kotlin.services.storagegateway.endpoints.StorageGatewayEndpointProvider
import aws.sdk.kotlin.services.storagegateway.model.ActivateGatewayRequest
import aws.sdk.kotlin.services.storagegateway.model.ActivateGatewayResponse
import aws.sdk.kotlin.services.storagegateway.model.AddCacheRequest
import aws.sdk.kotlin.services.storagegateway.model.AddCacheResponse
import aws.sdk.kotlin.services.storagegateway.model.AddTagsToResourceRequest
import aws.sdk.kotlin.services.storagegateway.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.storagegateway.model.AddUploadBufferRequest
import aws.sdk.kotlin.services.storagegateway.model.AddUploadBufferResponse
import aws.sdk.kotlin.services.storagegateway.model.AddWorkingStorageRequest
import aws.sdk.kotlin.services.storagegateway.model.AddWorkingStorageResponse
import aws.sdk.kotlin.services.storagegateway.model.AssignTapePoolRequest
import aws.sdk.kotlin.services.storagegateway.model.AssignTapePoolResponse
import aws.sdk.kotlin.services.storagegateway.model.AssociateFileSystemRequest
import aws.sdk.kotlin.services.storagegateway.model.AssociateFileSystemResponse
import aws.sdk.kotlin.services.storagegateway.model.AttachVolumeRequest
import aws.sdk.kotlin.services.storagegateway.model.AttachVolumeResponse
import aws.sdk.kotlin.services.storagegateway.model.CancelArchivalRequest
import aws.sdk.kotlin.services.storagegateway.model.CancelArchivalResponse
import aws.sdk.kotlin.services.storagegateway.model.CancelRetrievalRequest
import aws.sdk.kotlin.services.storagegateway.model.CancelRetrievalResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateCachediScsiVolumeRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateCachediScsiVolumeResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateNfsFileShareRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateNfsFileShareResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateSmbFileShareRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateSmbFileShareResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateStorediScsiVolumeRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateStorediScsiVolumeResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateTapePoolRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateTapePoolResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateTapeWithBarcodeRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateTapeWithBarcodeResponse
import aws.sdk.kotlin.services.storagegateway.model.CreateTapesRequest
import aws.sdk.kotlin.services.storagegateway.model.CreateTapesResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteBandwidthRateLimitRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteBandwidthRateLimitResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteChapCredentialsRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteChapCredentialsResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteFileShareRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteFileShareResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteGatewayRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteGatewayResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteSnapshotScheduleRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteSnapshotScheduleResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteTapeArchiveRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteTapeArchiveResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteTapePoolRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteTapePoolResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteTapeRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteTapeResponse
import aws.sdk.kotlin.services.storagegateway.model.DeleteVolumeRequest
import aws.sdk.kotlin.services.storagegateway.model.DeleteVolumeResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeAvailabilityMonitorTestRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeBandwidthRateLimitRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeBandwidthRateLimitResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeBandwidthRateLimitScheduleRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeCacheRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeCacheResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeCachediScsiVolumesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeCachediScsiVolumesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeChapCredentialsRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeChapCredentialsResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeFileSystemAssociationsRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeFileSystemAssociationsResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeGatewayInformationRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeGatewayInformationResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeMaintenanceStartTimeRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeMaintenanceStartTimeResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeNfsFileSharesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeNfsFileSharesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeSmbFileSharesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeSmbFileSharesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeSnapshotScheduleRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeSnapshotScheduleResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeStorediScsiVolumesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeStorediScsiVolumesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeArchivesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeArchivesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeUploadBufferRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeUploadBufferResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeVtlDevicesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeVtlDevicesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeWorkingStorageRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeWorkingStorageResponse
import aws.sdk.kotlin.services.storagegateway.model.DetachVolumeRequest
import aws.sdk.kotlin.services.storagegateway.model.DetachVolumeResponse
import aws.sdk.kotlin.services.storagegateway.model.DisableGatewayRequest
import aws.sdk.kotlin.services.storagegateway.model.DisableGatewayResponse
import aws.sdk.kotlin.services.storagegateway.model.DisassociateFileSystemRequest
import aws.sdk.kotlin.services.storagegateway.model.DisassociateFileSystemResponse
import aws.sdk.kotlin.services.storagegateway.model.JoinDomainRequest
import aws.sdk.kotlin.services.storagegateway.model.JoinDomainResponse
import aws.sdk.kotlin.services.storagegateway.model.ListAutomaticTapeCreationPoliciesRequest
import aws.sdk.kotlin.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse
import aws.sdk.kotlin.services.storagegateway.model.ListFileSharesRequest
import aws.sdk.kotlin.services.storagegateway.model.ListFileSharesResponse
import aws.sdk.kotlin.services.storagegateway.model.ListFileSystemAssociationsRequest
import aws.sdk.kotlin.services.storagegateway.model.ListFileSystemAssociationsResponse
import aws.sdk.kotlin.services.storagegateway.model.ListGatewaysRequest
import aws.sdk.kotlin.services.storagegateway.model.ListGatewaysResponse
import aws.sdk.kotlin.services.storagegateway.model.ListLocalDisksRequest
import aws.sdk.kotlin.services.storagegateway.model.ListLocalDisksResponse
import aws.sdk.kotlin.services.storagegateway.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.storagegateway.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.storagegateway.model.ListTapePoolsRequest
import aws.sdk.kotlin.services.storagegateway.model.ListTapePoolsResponse
import aws.sdk.kotlin.services.storagegateway.model.ListTapesRequest
import aws.sdk.kotlin.services.storagegateway.model.ListTapesResponse
import aws.sdk.kotlin.services.storagegateway.model.ListVolumeInitiatorsRequest
import aws.sdk.kotlin.services.storagegateway.model.ListVolumeInitiatorsResponse
import aws.sdk.kotlin.services.storagegateway.model.ListVolumeRecoveryPointsRequest
import aws.sdk.kotlin.services.storagegateway.model.ListVolumeRecoveryPointsResponse
import aws.sdk.kotlin.services.storagegateway.model.ListVolumesRequest
import aws.sdk.kotlin.services.storagegateway.model.ListVolumesResponse
import aws.sdk.kotlin.services.storagegateway.model.NotifyWhenUploadedRequest
import aws.sdk.kotlin.services.storagegateway.model.NotifyWhenUploadedResponse
import aws.sdk.kotlin.services.storagegateway.model.RefreshCacheRequest
import aws.sdk.kotlin.services.storagegateway.model.RefreshCacheResponse
import aws.sdk.kotlin.services.storagegateway.model.RemoveTagsFromResourceRequest
import aws.sdk.kotlin.services.storagegateway.model.RemoveTagsFromResourceResponse
import aws.sdk.kotlin.services.storagegateway.model.ResetCacheRequest
import aws.sdk.kotlin.services.storagegateway.model.ResetCacheResponse
import aws.sdk.kotlin.services.storagegateway.model.RetrieveTapeArchiveRequest
import aws.sdk.kotlin.services.storagegateway.model.RetrieveTapeArchiveResponse
import aws.sdk.kotlin.services.storagegateway.model.RetrieveTapeRecoveryPointRequest
import aws.sdk.kotlin.services.storagegateway.model.RetrieveTapeRecoveryPointResponse
import aws.sdk.kotlin.services.storagegateway.model.SetLocalConsolePasswordRequest
import aws.sdk.kotlin.services.storagegateway.model.SetLocalConsolePasswordResponse
import aws.sdk.kotlin.services.storagegateway.model.SetSmbGuestPasswordRequest
import aws.sdk.kotlin.services.storagegateway.model.SetSmbGuestPasswordResponse
import aws.sdk.kotlin.services.storagegateway.model.ShutdownGatewayRequest
import aws.sdk.kotlin.services.storagegateway.model.ShutdownGatewayResponse
import aws.sdk.kotlin.services.storagegateway.model.StartAvailabilityMonitorTestRequest
import aws.sdk.kotlin.services.storagegateway.model.StartAvailabilityMonitorTestResponse
import aws.sdk.kotlin.services.storagegateway.model.StartGatewayRequest
import aws.sdk.kotlin.services.storagegateway.model.StartGatewayResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateBandwidthRateLimitRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateBandwidthRateLimitResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateChapCredentialsRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateChapCredentialsResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateFileSystemAssociationRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateFileSystemAssociationResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateGatewayInformationRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateGatewayInformationResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateGatewaySoftwareNowRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateGatewaySoftwareNowResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateMaintenanceStartTimeRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateMaintenanceStartTimeResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateNfsFileShareRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateNfsFileShareResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareVisibilityResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbLocalGroupsRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbLocalGroupsResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbSecurityStrategyRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateSmbSecurityStrategyResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateSnapshotScheduleRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateSnapshotScheduleResponse
import aws.sdk.kotlin.services.storagegateway.model.UpdateVtlDeviceTypeRequest
import aws.sdk.kotlin.services.storagegateway.model.UpdateVtlDeviceTypeResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Storage Gateway"
public const val SdkVersion: String = "1.2.46"
public const val ServiceApiVersion: String = "2013-06-30"

/**
 * # Storage Gateway Service
 * Storage Gateway is the service that connects an on-premises software appliance with cloud-based storage to provide seamless and secure integration between an organization's on-premises IT environment and the Amazon Web Services storage infrastructure. The service enables you to securely upload data to the Amazon Web Services Cloud for cost effective backup and rapid disaster recovery.
 *
 * Use the following links to get started using the *Storage Gateway Service API Reference*:
 * + [Storage Gateway required request headers](https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewayHTTPRequestsHeaders): Describes the required headers that you must send with every POST request to Storage Gateway.
 * + [Signing requests](https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewaySigningRequests): Storage Gateway requires that you authenticate every request you send; this topic describes how sign such a request.
 * + [Error responses](https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#APIErrorResponses): Provides reference information about Storage Gateway errors.
 * + [Operations in Storage Gateway](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_Operations.html): Contains detailed descriptions of all Storage Gateway operations, their request parameters, response elements, possible errors, and examples of requests and responses.
 * + [Storage Gateway endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/sg.html): Provides a list of each Amazon Web Services Region and the endpoints available for use with Storage Gateway.
 *
 * Storage Gateway resource IDs are in uppercase. When you use these resource IDs with the Amazon EC2 API, EC2 expects resource IDs in lowercase. You must change your resource ID to lowercase to use it with the EC2 API. For example, in Storage Gateway the ID for a volume might be `vol-AA22BB012345DAF670`. When you use this ID with the EC2 API, you must change it to `vol-aa22bb012345daf670`. Otherwise, the EC2 API might not behave as expected.
 *
 * IDs for Storage Gateway volumes and Amazon EBS snapshots created from gateway volumes are changing to a longer format. Starting in December 2016, all new volumes and snapshots will be created with a 17-character string. Starting in April 2016, you will be able to use these longer IDs so you can test your systems with the new format. For more information, see [Longer EC2 and EBS resource IDs](http://aws.amazon.com/ec2/faqs/#longer-ids).
 *
 * For example, a volume Amazon Resource Name (ARN) with the longer volume ID format looks like the following:
 *
 * `arn:aws:storagegateway:us-west-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABBCCDDEEFFG`.
 *
 * A snapshot ID with the longer ID format looks like the following: `snap-78e226633445566ee`.
 *
 * For more information, see [Announcement: Heads-up – Longer Storage Gateway volume and snapshot IDs coming in 2016](http://forums.aws.amazon.com/ann.jspa?annID=3557).
 */
public interface StorageGatewayClient : SdkClient {
    /**
     * StorageGatewayClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, StorageGatewayClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "StorageGateway",
                "STORAGE_GATEWAY",
                "storage_gateway",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, StorageGatewayClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): StorageGatewayClient = DefaultStorageGatewayClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: StorageGatewayEndpointProvider = builder.endpointProvider ?: DefaultStorageGatewayEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: StorageGatewayAuthSchemeProvider = builder.authSchemeProvider ?: DefaultStorageGatewayAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Storage Gateway"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: StorageGatewayEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: StorageGatewayAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Activates the gateway you previously deployed on your host. In the activation process, you specify information such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The activation process also associates your gateway with your account. For more information, see UpdateGatewayInformation.
     *
     * You must turn on the gateway VM before you can activate your gateway.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ActivateGateway.sample
     */
    public suspend fun activateGateway(input: ActivateGatewayRequest): ActivateGatewayResponse

    /**
     * Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached volume, tape, and file gateway type (see [How Storage Gateway works (architecture)](https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html).
     *
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or more disk IDs that you want to configure as cache.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.AddCache.sample
     */
    public suspend fun addCache(input: AddCacheRequest): AddCacheResponse

    /**
     * Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team. Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway resources:
     * + Storage gateways of all types
     * + Storage volumes
     * + Virtual tapes
     * + NFS and SMB file shares
     * + File System associations
     *
     * You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes that are recovered to a new gateway maintain their tags.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.AddTagsToResource.sample
     */
    public suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.
     *
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and one or more disk IDs that you want to configure as upload buffer.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.AddUploadBuffer.sample
     */
    public suspend fun addUploadBuffer(input: AddUploadBufferRequest): AddUploadBufferResponse

    /**
     * Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use AddUploadBuffer instead.
     *
     * Working storage is also referred to as upload buffer. You can also use the AddUploadBuffer operation to add upload buffer to a stored volume gateway.
     *
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and one or more disk IDs that you want to configure as working storage.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.AddWorkingStorage.sample
     */
    public suspend fun addWorkingStorage(input: AddWorkingStorageRequest): AddWorkingStorageResponse

    /**
     * Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public suspend fun assignTapePool(input: AssignTapePoolRequest): AssignTapePoolResponse

    /**
     * Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the file shares on the Amazon FSx file system are available for access through the gateway. This operation only supports the FSx File Gateway type.
     */
    public suspend fun associateFileSystem(input: AssociateFileSystemRequest): AssociateFileSystemResponse

    /**
     * Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.
     */
    public suspend fun attachVolume(input: AttachVolumeRequest): AttachVolumeResponse

    /**
     * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated. This operation is only supported in the tape gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CancelArchival.sample
     */
    public suspend fun cancelArchival(input: CancelArchivalRequest): CancelArchivalResponse

    /**
     * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CancelRetrieval.sample
     */
    public suspend fun cancelRetrieval(input: CancelRetrievalRequest): CancelRetrievalResponse

    /**
     * Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached volume gateway type.
     *
     * Cache storage must be allocated to the gateway before you can create a cached volume. Use the AddCache operation to add cache storage to a gateway.
     *
     * In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.
     *
     * Optionally, you can provide the ARN for an existing volume as the `SourceVolumeARN` for this cached volume, which creates an exact copy of the existing volume’s latest recovery point. The `VolumeSizeInBytes` value must be equal to or larger than the size of the copied volume, in bytes.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateCachediSCSIVolume.sample
     */
    public suspend fun createCachediScsiVolume(input: CreateCachediScsiVolumeRequest): CreateCachediScsiVolumeResponse

    /**
     * Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS interface. This operation is only supported for S3 File Gateways.
     *
     * S3 File gateway requires Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your S3 File Gateway in. If Amazon Web Services STS is not activated in the Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see [Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Identity and Access Management User Guide*.
     *
     * S3 File Gateways do not support creating hard or symbolic links on a file share.
     */
    public suspend fun createNfsFileShare(input: CreateNfsFileShareRequest): CreateNfsFileShareResponse

    /**
     * Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB interface. This operation is only supported for S3 File Gateways.
     *
     * S3 File Gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your S3 File Gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see [Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Identity and Access Management User Guide*.
     *
     * File gateways don't support creating hard or symbolic links on a file share.
     */
    public suspend fun createSmbFileShare(input: CreateSmbFileShareRequest): CreateSmbFileShareResponse

    /**
     * Initiates a snapshot of a volume.
     *
     * Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage (Amazon S3) for durable off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc basis. This API enables you to take an ad hoc snapshot. For more information, see [Editing a snapshot schedule](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot).
     *
     * In the `CreateSnapshot` request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide description for the snapshot. When Storage Gateway takes the snapshot of specified volume, the snapshot and description appears in the Storage Gateway console. In response, Storage Gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot. This operation is only supported in stored and cached volume gateway type.
     *
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html) or [DeleteSnapshot](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html) in the *Amazon Elastic Compute Cloud API Reference*.
     *
     * Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note on the [Welcome](https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html) page.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateSnapshot.sample
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached volume gateway type.
     *
     * A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot. To get a list of volume recovery point for cached volume gateway, use ListVolumeRecoveryPoints.
     *
     * In the `CreateSnapshotFromVolumeRecoveryPoint` request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a snapshot of the specified volume, the snapshot and its description appear in the Storage Gateway console. In response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot.
     *
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html) or [DeleteSnapshot](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html) in the *Amazon Elastic Compute Cloud API Reference*.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateSnapshotFromVolumeRecoveryPoint.sample
     */
    public suspend fun createSnapshotFromVolumeRecoveryPoint(input: CreateSnapshotFromVolumeRecoveryPointRequest): CreateSnapshotFromVolumeRecoveryPointResponse

    /**
     * Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.
     *
     * The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty gateway volume, then any existing data on the disk is erased.
     *
     * In the request, you must specify the gateway and the disk information on which you are creating the volume. In response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateStorediSCSIVolume.sample
     */
    public suspend fun createStorediScsiVolume(input: CreateStorediScsiVolumeRequest): CreateStorediScsiVolumeResponse

    /**
     * Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are archived in the custom pool.
     */
    public suspend fun createTapePool(input: CreateTapePoolRequest): CreateTapePoolResponse

    /**
     * Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on deleted tapes. This operation is only supported in the tape gateway type.
     *
     * Cache storage must be allocated to the gateway before you can create a virtual tape. Use the AddCache operation to add cache storage to a gateway.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateTapeWithBarcode.sample
     */
    public suspend fun createTapeWithBarcode(input: CreateTapeWithBarcodeRequest): CreateTapeWithBarcodeResponse

    /**
     * Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation is only supported in the tape gateway type.
     *
     * Cache storage must be allocated to the gateway before you can create virtual tapes. Use the AddCache operation to add cache storage to a gateway.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateTapes.sample
     */
    public suspend fun createTapes(input: CreateTapesRequest): CreateTapesResponse

    /**
     * Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.
     */
    public suspend fun deleteAutomaticTapeCreationPolicy(input: DeleteAutomaticTapeCreationPolicyRequest): DeleteAutomaticTapeCreationPolicyResponse

    /**
     * Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This operation is supported only for the stored volume, cached volume, and tape gateway types.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteBandwidthRateLimit.sample
     */
    public suspend fun deleteBandwidthRateLimit(input: DeleteBandwidthRateLimitRequest): DeleteBandwidthRateLimitResponse

    /**
     * Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair. This operation is supported in volume and tape gateway types.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteChapCredentials.sample
     */
    public suspend fun deleteChapCredentials(input: DeleteChapCredentialsRequest): DeleteChapCredentialsResponse

    /**
     * Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.
     */
    public suspend fun deleteFileShare(input: DeleteFileShareRequest): DeleteFileShareResponse

    /**
     * Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from your host computer.
     *
     * After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next step is to remove it from your environment.
     *
     * You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots persist and you will continue to be billed for these snapshots. You can choose to remove all remaining Amazon EBS snapshots by canceling your Amazon EC2 subscription. If you prefer not to cancel your Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2 console. For more information, see the [Storage Gateway detail page](http://aws.amazon.com/storagegateway).
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteGateway.sample
     */
    public suspend fun deleteGateway(input: DeleteGatewayRequest): DeleteGatewayResponse

    /**
     * Deletes a snapshot of a volume.
     *
     * You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to delete a snapshot schedule for a volume. For more information, see [Backing up your volumes](https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html). In the `DeleteSnapshotSchedule` request, you identify the volume by providing its Amazon Resource Name (ARN). This operation is only supported for cached volume gateway types.
     *
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteSnapshotSchedule.sample
     */
    public suspend fun deleteSnapshotSchedule(input: DeleteSnapshotScheduleRequest): DeleteSnapshotScheduleResponse

    /**
     * Deletes the specified virtual tape. This operation is only supported in the tape gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteTape.sample
     */
    public suspend fun deleteTape(input: DeleteTapeRequest): DeleteTapeResponse

    /**
     * Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteTapeArchive.sample
     */
    public suspend fun deleteTapeArchive(input: DeleteTapeArchiveRequest): DeleteTapeArchiveResponse

    /**
     * Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there are no automatic tape creation policies that reference the custom tape pool.
     */
    public suspend fun deleteTapePool(input: DeleteTapePoolRequest): DeleteTapePoolResponse

    /**
     * Deletes the specified storage volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API. This operation is only supported in the cached volume and stored volume types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You can reuse the local disk to create another storage volume.
     *
     * Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are deleting and check the snapshot status. For more information, go to [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
     *
     * In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteVolume.sample
     */
    public suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse

    /**
     * Returns information about the most recent high availability monitoring test that was performed on the host in a cluster. If a test isn't performed, the status and start time in the response would be null.
     */
    public suspend fun describeAvailabilityMonitorTest(input: DescribeAvailabilityMonitorTestRequest): DescribeAvailabilityMonitorTestResponse

    /**
     * Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth rate limiting is in effect. This operation is supported only for the stored volume, cached volume, and tape gateway types. To describe bandwidth rate limits for S3 file gateways, use DescribeBandwidthRateLimitSchedule.
     *
     * This operation returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for the gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeBandwidthRateLimit.sample
     */
    public suspend fun describeBandwidthRateLimit(input: DescribeBandwidthRateLimitRequest): DescribeBandwidthRateLimitResponse

    /**
     * Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported only for volume, tape and S3 file gateways. FSx file gateways do not support bandwidth rate limits.
     *
     * This operation returns information about a gateway's bandwidth rate limit schedule. A bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the week, during which bandwidth rate limits are specified for uploading, downloading, or both.
     *
     *  A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute, an ending hour and minute, and bandwidth rate limits for uploading and downloading
     *
     *  If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an empty response. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     */
    public suspend fun describeBandwidthRateLimitSchedule(input: DescribeBandwidthRateLimitScheduleRequest): DescribeBandwidthRateLimitScheduleResponse

    /**
     * Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape, and file gateway types.
     *
     * The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and used.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeCache.sample
     */
    public suspend fun describeCache(input: DescribeCacheRequest): DescribeCacheResponse

    /**
     * Returns a description of the gateway volumes specified in the request. This operation is only supported in the cached volume gateway types.
     *
     * The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume Amazon Resource Name (ARN).
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeCachediSCSIVolumes.sample
     */
    public suspend fun describeCachediScsiVolumes(input: DescribeCachediScsiVolumesRequest): DescribeCachediScsiVolumesResponse

    /**
     * Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway types.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeChapCredentials.sample
     */
    public suspend fun describeChapCredentials(input: DescribeChapCredentialsRequest): DescribeChapCredentialsResponse

    /**
     * Gets the file system association information. This operation is only supported for FSx File Gateways.
     */
    public suspend fun describeFileSystemAssociations(input: DescribeFileSystemAssociationsRequest): DescribeFileSystemAssociationsResponse

    /**
     * Returns metadata about a gateway such as its name, network interfaces, time zone, status, and software version. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeGatewayInformation.sample
     */
    public suspend fun describeGatewayInformation(input: DescribeGatewayInformationRequest): DescribeGatewayInformationResponse

    /**
     * Returns your gateway's maintenance window schedule information, with values for monthly or weekly cadence, specific day and time to begin maintenance, and which types of updates to apply. Time values returned are for the gateway's time zone.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeMaintenanceStartTime.sample
     */
    public suspend fun describeMaintenanceStartTime(input: DescribeMaintenanceStartTimeRequest): DescribeMaintenanceStartTimeResponse

    /**
     * Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation is only supported for S3 File Gateways.
     */
    public suspend fun describeNfsFileShares(input: DescribeNfsFileSharesRequest): DescribeNfsFileSharesResponse

    /**
     * Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation is only supported for S3 File Gateways.
     */
    public suspend fun describeSmbFileShares(input: DescribeSmbFileSharesRequest): DescribeSmbFileSharesResponse

    /**
     * Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is only supported for file gateways.
     */
    public suspend fun describeSmbSettings(input: DescribeSmbSettingsRequest): DescribeSmbSettingsResponse

    /**
     * Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the cached volume and stored volume types.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeSnapshotSchedule.sample
     */
    public suspend fun describeSnapshotSchedule(input: DescribeSnapshotScheduleRequest): DescribeSnapshotScheduleResponse

    /**
     * Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported in stored volume gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeStorediSCSIVolumes.sample
     */
    public suspend fun describeStorediScsiVolumes(input: DescribeStorediScsiVolumesRequest): DescribeStorediScsiVolumesResponse

    /**
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.
     *
     * If a specific `TapeARN` is not specified, Storage Gateway returns a description of all virtual tapes found in the VTS associated with your account.
     */
    public suspend fun describeTapeArchives(input: DescribeTapeArchivesRequest = DescribeTapeArchivesRequest { }): DescribeTapeArchivesResponse

    /**
     * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
     *
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway. This operation is only supported in the tape gateway type.
     */
    public suspend fun describeTapeRecoveryPoints(input: DescribeTapeRecoveryPointsRequest): DescribeTapeRecoveryPointsResponse

    /**
     * Returns a description of virtual tapes that correspond to the specified Amazon Resource Names (ARNs). If `TapeARN` is not specified, returns a description of the virtual tapes associated with the specified gateway. This operation is only supported for the tape gateway type.
     *
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the `Limit` field in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a `Marker` field. You can use this `Marker` value in your subsequent request to retrieve the next set of tapes.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeTapes.sample
     */
    public suspend fun describeTapes(input: DescribeTapesRequest): DescribeTapesResponse

    /**
     * Returns information about the upload buffer of a gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.
     *
     * The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload buffer space allocated and used.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeUploadBuffer.sample
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeUploadBuffer.sample2
     */
    public suspend fun describeUploadBuffer(input: DescribeUploadBufferRequest): DescribeUploadBufferResponse

    /**
     * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, Storage Gateway returns VTL device information.
     *
     * This operation is only supported in the tape gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeVTLDevices.sample
     */
    public suspend fun describeVtlDevices(input: DescribeVtlDevicesRequest): DescribeVtlDevicesResponse

    /**
     * Returns information about the working storage of a gateway. This operation is only supported in the stored volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use DescribeUploadBuffer instead.
     *
     * Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.
     *
     * The response includes disk IDs that are configured as working storage, and it includes the amount of working storage allocated and used.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeWorkingStorage.sample
     */
    public suspend fun describeWorkingStorage(input: DescribeWorkingStorageRequest): DescribeWorkingStorageResponse

    /**
     * Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance. This operation is only supported in the volume gateway type.
     */
    public suspend fun detachVolume(input: DetachVolumeRequest): DetachVolumeResponse

    /**
     * Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.
     *
     * Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported in the tape gateway type.
     *
     * After a gateway is disabled, it cannot be enabled.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.DisableGateway.sample
     */
    public suspend fun disableGateway(input: DisableGatewayRequest): DisableGatewayResponse

    /**
     * Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes, the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File Gateway type.
     */
    public suspend fun disassociateFileSystem(input: DisassociateFileSystemRequest): DisassociateFileSystemResponse

    /**
     * Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that support the SMB file protocol.
     *
     * Joining a domain creates an Active Directory computer account in the default organizational unit, using the gateway's **Gateway ID** as the account name (for example, SGW-1234ADE). If your Active Directory environment requires that you pre-stage accounts to facilitate the join domain process, you will need to create this account ahead of time.
     *
     * To create the gateway's computer account in an organizational unit other than the default, you must specify the organizational unit when joining the domain.
     */
    public suspend fun joinDomain(input: JoinDomainRequest): JoinDomainResponse

    /**
     * Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for the gateway, it returns an empty list.
     *
     * This operation is only supported for tape gateways.
     */
    public suspend fun listAutomaticTapeCreationPolicies(input: ListAutomaticTapeCreationPoliciesRequest = ListAutomaticTapeCreationPoliciesRequest { }): ListAutomaticTapeCreationPoliciesResponse

    /**
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the calling Amazon Web Services account. This operation is only supported for S3 File Gateways.
     */
    public suspend fun listFileShares(input: ListFileSharesRequest = ListFileSharesRequest { }): ListFileSharesResponse

    /**
     * Gets a list of `FileSystemAssociationSummary` objects. Each object contains a summary of a file system association. This operation is only supported for FSx File Gateways.
     */
    public suspend fun listFileSystemAssociations(input: ListFileSystemAssociationsRequest = ListFileSystemAssociationsRequest { }): ListFileSystemAssociationsResponse

    /**
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).
     *
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you to optionally reduce the number of gateways returned in a response.
     *
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of your gateways), the response contains a marker that you can specify in your next request to fetch the next page of gateways.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ListGateways.sample
     */
    public suspend fun listGateways(input: ListGatewaysRequest = ListGatewaysRequest { }): ListGatewaysResponse

    /**
     * Returns a list of the gateway's local disks. To specify which gateway to describe, you use the Amazon Resource Name (ARN) of the gateway in the body of the request.
     *
     * The request returns a list of all disks, specifying which are configured as working storage, cache storage, or stored volume or not configured at all. The response includes a `DiskStatus` field. This field can have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway), or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ListLocalDisks.sample
     */
    public suspend fun listLocalDisks(input: ListLocalDisksRequest): ListLocalDisksResponse

    /**
     * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of all types.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
     *
     * This operation supports pagination. You can optionally specify the `Limit` parameter in the body to limit the number of tape pools in the response. If the number of tape pools returned in the response is truncated, the response includes a `Marker` element that you can use in your subsequent request to retrieve the next set of tape pools.
     */
    public suspend fun listTapePools(input: ListTapePoolsRequest = ListTapePoolsRequest { }): ListTapePoolsResponse

    /**
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation lists all virtual tapes in both your VTL and VTS.
     *
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the `Limit` parameter in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a `Marker` element that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported in the tape gateway type.
     */
    public suspend fun listTapes(input: ListTapesRequest = ListTapesRequest { }): ListTapesResponse

    /**
     * Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume is being used or not. This operation is only supported in the cached volume and stored volume gateway types.
     */
    public suspend fun listVolumeInitiators(input: ListVolumeInitiatorsRequest): ListVolumeInitiatorsResponse

    /**
     * Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway type.
     *
     * Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume. To create a snapshot from a volume recovery point use the CreateSnapshotFromVolumeRecoveryPoint operation.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ListVolumeRecoveryPoints.sample
     */
    public suspend fun listVolumeRecoveryPoints(input: ListVolumeRecoveryPointsRequest): ListVolumeRecoveryPointsResponse

    /**
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the volume ARNs. If you want additional volume information, use the DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes API.
     *
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can optionally specify the `Limit` field in the body to limit the number of volumes in the response. If the number of volumes returned in the response is truncated, the response includes a Marker field. You can use this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only supported in the cached volume and stored volume gateway types.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ListVolumes.sample
     */
    public suspend fun listVolumes(input: ListVolumesRequest = ListVolumesRequest { }): ListVolumesResponse

    /**
     * Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to Amazon S3.
     *
     * Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file share up to that point in time have been uploaded to Amazon S3. These files include files written to the file share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File Gateways.
     *
     * For more information, see [Getting file upload notification](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*.
     */
    public suspend fun notifyWhenUploaded(input: NotifyWhenUploadedRequest): NotifyWhenUploadedResponse

    /**
     * Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only supported in the S3 File Gateway types.
     *
     * You can subscribe to be notified through an Amazon CloudWatch event when your `RefreshCache` operation completes. For more information, see [Getting notified about file operations](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*. This operation is Only supported for S3 File Gateways.
     *
     * When this API is called, it only initiates the refresh operation. When the API call completes and returns a success code, it doesn't necessarily mean that the file refresh has completed. You should use the refresh-complete notification to determine that the operation has completed before you check for new files on the gateway file share. You can subscribe to be notified through a CloudWatch event when your `RefreshCache` operation completes.
     *
     * Throttle limit: This API is asynchronous, so the gateway will accept no more than two refreshes at any time. We recommend using the refresh-complete CloudWatch event notification before issuing additional requests. For more information, see [Getting notified about file operations](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*.
     *
     * + Wait at least 60 seconds between consecutive RefreshCache API requests.
     * + If you invoke the RefreshCache API when two requests are already being processed, any new request will cause an `InvalidGatewayRequestException` error because too many requests were sent to the server.
     * The S3 bucket name does not need to be included when entering the list of folders in the FolderList parameter.
     *
     * For more information, see [Getting notified about file operations](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*.
     */
    public suspend fun refreshCache(input: RefreshCacheRequest): RefreshCacheResponse

    /**
     * Removes one or more tags from the specified resource. This operation is supported in storage gateways of all types.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.RemoveTagsFromResource.sample
     */
    public suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks. This operation is only supported in the cached volume and tape types.
     *
     * If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must configure at least one new cache disk for your gateway to function properly.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ResetCache.sample
     */
    public suspend fun resetCache(input: ResetCacheRequest): ResetCacheResponse

    /**
     * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway, even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway type.
     *
     * Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must archive the tape again before you can retrieve it to another gateway. This operation is only supported in the tape gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.RetrieveTapeArchive.sample
     */
    public suspend fun retrieveTapeArchive(input: RetrieveTapeArchiveRequest): RetrieveTapeArchiveResponse

    /**
     * Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway type.
     *
     * A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     *
     * The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge for retrieving recovery points.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.RetrieveTapeRecoveryPoint.sample
     */
    public suspend fun retrieveTapeRecoveryPoint(input: RetrieveTapeRecoveryPointRequest): RetrieveTapeRecoveryPointResponse

    /**
     * Sets the password for your VM local console. When you log in to the local console for the first time, you log in to the VM with the default credentials. We recommend that you set a new password. You don't need to know the default password to set a new password.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.SetLocalConsolePassword.sample
     */
    public suspend fun setLocalConsolePassword(input: SetLocalConsolePasswordRequest): SetLocalConsolePasswordResponse

    /**
     * Sets the password for the guest user `smbguest`. The `smbguest` user is the user when the authentication method for the file share is set to `GuestAccess`. This operation only supported for S3 File Gateways
     */
    public suspend fun setSmbGuestPassword(input: SetSmbGuestPasswordRequest): SetSmbGuestPasswordResponse

    /**
     * Shuts down a Tape Gateway or Volume Gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in the body of your request.
     *
     * This API action cannot be used to shut down S3 File Gateway or FSx File Gateway.
     *
     * The operation shuts down the gateway service component running in the gateway's virtual machine (VM) and not the host VM.
     *
     * If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to avoid unpredictable conditions.
     *
     * After the gateway is shutdown, you cannot call any other API except StartGateway, DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway. Your applications cannot read from or write to the gateway's storage volumes, and there are no snapshots taken.
     *
     * When you make a shutdown request, you will get a `200 OK` success response immediately. However, it might take some time for the gateway to shut down. You can call the DescribeGatewayInformation API to check the status. For more information, see ActivateGateway.
     *
     * If do not intend to use the gateway again, you must delete the gateway (using DeleteGateway) to no longer pay software charges associated with the gateway.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.ShutdownGateway.sample
     */
    public suspend fun shutdownGateway(input: ShutdownGatewayRequest): ShutdownGatewayResponse

    /**
     * Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host environment. This request only initiates the test and that a successful response only indicates that the test was started. It doesn't indicate that the test passed. For the status of the test, invoke the `DescribeAvailabilityMonitorTest` API.
     *
     * Starting this test will cause your gateway to go offline for a brief period.
     */
    public suspend fun startAvailabilityMonitorTest(input: StartAvailabilityMonitorTestRequest): StartAvailabilityMonitorTestResponse

    /**
     * Starts a gateway that you previously shut down (see ShutdownGateway). After the gateway starts, you can then make other API calls, your applications can read from or write to the gateway's storage volumes and you will be able to take snapshot backups.
     *
     * When you make a request, you will get a 200 OK success response immediately. However, it might take some time for the gateway to be ready. You should call DescribeGatewayInformation and check the status before making any additional API calls. For more information, see ActivateGateway.
     *
     * To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.StartGateway.sample
     */
    public suspend fun startGateway(input: StartGatewayRequest): StartGatewayResponse

    /**
     * Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of automatic tape creation rules. This is only supported for tape gateways.
     *
     * By default, there is no automatic tape creation policy.
     *
     * A gateway can have only one automatic tape creation policy.
     */
    public suspend fun updateAutomaticTapeCreationPolicy(input: UpdateAutomaticTapeCreationPolicyRequest): UpdateAutomaticTapeCreationPolicyResponse

    /**
     * Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This operation is supported only for the stored volume, cached volume, and tape gateway types. To update bandwidth rate limits for S3 file gateways, use UpdateBandwidthRateLimitSchedule.
     *
     * By default, a gateway's bandwidth rate limits are not set. If you don't set any limit, the gateway does not have any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.
     *
     * To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateBandwidthRateLimit.sample
     */
    public suspend fun updateBandwidthRateLimit(input: UpdateBandwidthRateLimitRequest): UpdateBandwidthRateLimitResponse

    /**
     * Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a gateway's bandwidth rate limit schedule. This operation is supported for volume, tape, and S3 file gateways. S3 file gateways support bandwidth rate limits for upload only. FSx file gateways do not support bandwidth rate limits.
     */
    public suspend fun updateBandwidthRateLimitSchedule(input: UpdateBandwidthRateLimitScheduleRequest): UpdateBandwidthRateLimitScheduleResponse

    /**
     * Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is supported in the volume and tape gateway types.
     *
     * When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect with the new credentials.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateChapCredentials.sample
     */
    public suspend fun updateChapCredentials(input: UpdateChapCredentialsRequest): UpdateChapCredentialsResponse

    /**
     * Updates a file system association. This operation is only supported in the FSx File Gateways.
     */
    public suspend fun updateFileSystemAssociation(input: UpdateFileSystemAssociationRequest): UpdateFileSystemAssociationResponse

    /**
     * Updates a gateway's metadata, which includes the gateway's name, time zone, and metadata cache size. To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
     *
     * For gateways activated after September 2, 2015, the gateway's ARN contains the gateway ID rather than the gateway name. However, changing the name of the gateway has no effect on the gateway's ARN.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateGatewayInformation.sample
     */
    public suspend fun updateGatewayInformation(input: UpdateGatewayInformationRequest): UpdateGatewayInformationResponse

    /**
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     *
     * When you make this request, you get a `200 OK` success response immediately. However, it might take some time for the update to complete. You can call DescribeGatewayInformation to verify the gateway is in the `STATE_RUNNING` state.
     *
     * A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your applications by increasing your iSCSI Initiators' timeouts. For more information about increasing iSCSI Initiator timeouts for Windows and Linux, see [Customizing your Windows iSCSI settings](https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings) and [Customizing your Linux iSCSI settings](https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings), respectively.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateGatewaySoftwareNow.sample
     */
    public suspend fun updateGatewaySoftwareNow(input: UpdateGatewaySoftwareNowRequest): UpdateGatewaySoftwareNowResponse

    /**
     * Updates a gateway's maintenance window schedule, with settings for monthly or weekly cadence, specific day and time to begin maintenance, and which types of updates to apply. Time configuration uses the gateway's time zone. You can pass values for a complete maintenance schedule, or update policy, or both. Previous values will persist for whichever setting you choose not to modify. If an incomplete or invalid maintenance schedule is passed, the entire request will be rejected with an error and no changes will occur.
     *
     * A complete maintenance schedule must include values for *both*`MinuteOfHour` and `HourOfDay`, and *either*`DayOfMonth`*or*`DayOfWeek`.
     *
     * We recommend keeping maintenance updates turned on, except in specific use cases where the brief disruptions caused by updating the gateway could critically impact your deployment.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateMaintenanceStartTime.sample
     */
    public suspend fun updateMaintenanceStartTime(input: UpdateMaintenanceStartTimeRequest): UpdateMaintenanceStartTimeResponse

    /**
     * Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.
     *
     * To leave a file share field unchanged, set the corresponding input field to null.
     *
     * Updates the following file share settings:
     * + Default storage class for your S3 bucket
     * + Metadata defaults for your S3 bucket
     * + Allowed NFS clients for your file share
     * + Squash settings
     * + Write status of your file share
     */
    public suspend fun updateNfsFileShare(input: UpdateNfsFileShareRequest): UpdateNfsFileShareResponse

    /**
     * Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.
     *
     * To leave a file share field unchanged, set the corresponding input field to null.
     *
     * File gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your file gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see [Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Identity and Access Management User Guide*.
     *
     * File gateways don't support creating hard or symbolic links on a file share.
     */
    public suspend fun updateSmbFileShare(input: UpdateSmbFileShareRequest): UpdateSmbFileShareResponse

    /**
     * Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only supported for S3 File Gateways.
     */
    public suspend fun updateSmbFileShareVisibility(input: UpdateSmbFileShareVisibilityRequest): UpdateSmbFileShareVisibilityResponse

    /**
     * Updates the list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
     */
    public suspend fun updateSmbLocalGroups(input: UpdateSmbLocalGroupsRequest): UpdateSmbLocalGroupsResponse

    /**
     * Updates the SMB security strategy level for an Amazon S3 file gateway. This action is only supported for Amazon S3 file gateways.
     *
     * For information about configuring this setting using the Amazon Web Services console, see [Setting a security level for your gateway](https://docs.aws.amazon.com/filegateway/latest/files3/security-strategy.html) in the *Amazon S3 File Gateway User Guide*.
     *
     * A higher security strategy level can affect performance of the gateway.
     */
    public suspend fun updateSmbSecurityStrategy(input: UpdateSmbSecurityStrategyRequest): UpdateSmbSecurityStrategyResponse

    /**
     * Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached volume and stored volume gateway types.
     *
     * The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You can use this API to change the snapshot schedule configured for the volume.
     *
     * In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateSnapshotSchedule.sample
     */
    public suspend fun updateSnapshotSchedule(input: UpdateSnapshotScheduleRequest): UpdateSnapshotScheduleResponse

    /**
     * Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium changer type for the tape gateway. This operation enables you to select a different type of medium changer after a tape gateway is activated. This operation is only supported in the tape gateway type.
     *
     * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateVTLDeviceType.sample
     */
    public suspend fun updateVtlDeviceType(input: UpdateVtlDeviceTypeRequest): UpdateVtlDeviceTypeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun StorageGatewayClient.withConfig(block: StorageGatewayClient.Config.Builder.() -> Unit): StorageGatewayClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultStorageGatewayClient(newConfig)
}

/**
 * Activates the gateway you previously deployed on your host. In the activation process, you specify information such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The activation process also associates your gateway with your account. For more information, see UpdateGatewayInformation.
 *
 * You must turn on the gateway VM before you can activate your gateway.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ActivateGateway.sample
 */
public suspend inline fun StorageGatewayClient.activateGateway(crossinline block: ActivateGatewayRequest.Builder.() -> Unit): ActivateGatewayResponse = activateGateway(ActivateGatewayRequest.Builder().apply(block).build())

/**
 * Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached volume, tape, and file gateway type (see [How Storage Gateway works (architecture)](https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html).
 *
 * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or more disk IDs that you want to configure as cache.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.AddCache.sample
 */
public suspend inline fun StorageGatewayClient.addCache(crossinline block: AddCacheRequest.Builder.() -> Unit): AddCacheResponse = addCache(AddCacheRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team. Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway resources:
 * + Storage gateways of all types
 * + Storage volumes
 * + Virtual tapes
 * + NFS and SMB file shares
 * + File System associations
 *
 * You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes that are recovered to a new gateway maintain their tags.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.AddTagsToResource.sample
 */
public suspend inline fun StorageGatewayClient.addTagsToResource(crossinline block: AddTagsToResourceRequest.Builder.() -> Unit): AddTagsToResourceResponse = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

/**
 * Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.
 *
 * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and one or more disk IDs that you want to configure as upload buffer.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.AddUploadBuffer.sample
 */
public suspend inline fun StorageGatewayClient.addUploadBuffer(crossinline block: AddUploadBufferRequest.Builder.() -> Unit): AddUploadBufferResponse = addUploadBuffer(AddUploadBufferRequest.Builder().apply(block).build())

/**
 * Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use AddUploadBuffer instead.
 *
 * Working storage is also referred to as upload buffer. You can also use the AddUploadBuffer operation to add upload buffer to a stored volume gateway.
 *
 * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and one or more disk IDs that you want to configure as working storage.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.AddWorkingStorage.sample
 */
public suspend inline fun StorageGatewayClient.addWorkingStorage(crossinline block: AddWorkingStorageRequest.Builder.() -> Unit): AddWorkingStorageResponse = addWorkingStorage(AddWorkingStorageRequest.Builder().apply(block).build())

/**
 * Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
 */
public suspend inline fun StorageGatewayClient.assignTapePool(crossinline block: AssignTapePoolRequest.Builder.() -> Unit): AssignTapePoolResponse = assignTapePool(AssignTapePoolRequest.Builder().apply(block).build())

/**
 * Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the file shares on the Amazon FSx file system are available for access through the gateway. This operation only supports the FSx File Gateway type.
 */
public suspend inline fun StorageGatewayClient.associateFileSystem(crossinline block: AssociateFileSystemRequest.Builder.() -> Unit): AssociateFileSystemResponse = associateFileSystem(AssociateFileSystemRequest.Builder().apply(block).build())

/**
 * Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.
 */
public suspend inline fun StorageGatewayClient.attachVolume(crossinline block: AttachVolumeRequest.Builder.() -> Unit): AttachVolumeResponse = attachVolume(AttachVolumeRequest.Builder().apply(block).build())

/**
 * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated. This operation is only supported in the tape gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CancelArchival.sample
 */
public suspend inline fun StorageGatewayClient.cancelArchival(crossinline block: CancelArchivalRequest.Builder.() -> Unit): CancelArchivalResponse = cancelArchival(CancelArchivalRequest.Builder().apply(block).build())

/**
 * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CancelRetrieval.sample
 */
public suspend inline fun StorageGatewayClient.cancelRetrieval(crossinline block: CancelRetrievalRequest.Builder.() -> Unit): CancelRetrievalResponse = cancelRetrieval(CancelRetrievalRequest.Builder().apply(block).build())

/**
 * Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached volume gateway type.
 *
 * Cache storage must be allocated to the gateway before you can create a cached volume. Use the AddCache operation to add cache storage to a gateway.
 *
 * In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.
 *
 * Optionally, you can provide the ARN for an existing volume as the `SourceVolumeARN` for this cached volume, which creates an exact copy of the existing volume’s latest recovery point. The `VolumeSizeInBytes` value must be equal to or larger than the size of the copied volume, in bytes.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateCachediSCSIVolume.sample
 */
public suspend inline fun StorageGatewayClient.createCachediScsiVolume(crossinline block: CreateCachediScsiVolumeRequest.Builder.() -> Unit): CreateCachediScsiVolumeResponse = createCachediScsiVolume(CreateCachediScsiVolumeRequest.Builder().apply(block).build())

/**
 * Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS interface. This operation is only supported for S3 File Gateways.
 *
 * S3 File gateway requires Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your S3 File Gateway in. If Amazon Web Services STS is not activated in the Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see [Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Identity and Access Management User Guide*.
 *
 * S3 File Gateways do not support creating hard or symbolic links on a file share.
 */
public suspend inline fun StorageGatewayClient.createNfsFileShare(crossinline block: CreateNfsFileShareRequest.Builder.() -> Unit): CreateNfsFileShareResponse = createNfsFileShare(CreateNfsFileShareRequest.Builder().apply(block).build())

/**
 * Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB interface. This operation is only supported for S3 File Gateways.
 *
 * S3 File Gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your S3 File Gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see [Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Identity and Access Management User Guide*.
 *
 * File gateways don't support creating hard or symbolic links on a file share.
 */
public suspend inline fun StorageGatewayClient.createSmbFileShare(crossinline block: CreateSmbFileShareRequest.Builder.() -> Unit): CreateSmbFileShareResponse = createSmbFileShare(CreateSmbFileShareRequest.Builder().apply(block).build())

/**
 * Initiates a snapshot of a volume.
 *
 * Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage (Amazon S3) for durable off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc basis. This API enables you to take an ad hoc snapshot. For more information, see [Editing a snapshot schedule](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot).
 *
 * In the `CreateSnapshot` request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide description for the snapshot. When Storage Gateway takes the snapshot of specified volume, the snapshot and description appears in the Storage Gateway console. In response, Storage Gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot. This operation is only supported in stored and cached volume gateway type.
 *
 * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html) or [DeleteSnapshot](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html) in the *Amazon Elastic Compute Cloud API Reference*.
 *
 * Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note on the [Welcome](https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html) page.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateSnapshot.sample
 */
public suspend inline fun StorageGatewayClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached volume gateway type.
 *
 * A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot. To get a list of volume recovery point for cached volume gateway, use ListVolumeRecoveryPoints.
 *
 * In the `CreateSnapshotFromVolumeRecoveryPoint` request, you identify the volume by providing its Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a snapshot of the specified volume, the snapshot and its description appear in the Storage Gateway console. In response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create a volume from a snapshot.
 *
 * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html) or [DeleteSnapshot](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html) in the *Amazon Elastic Compute Cloud API Reference*.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateSnapshotFromVolumeRecoveryPoint.sample
 */
public suspend inline fun StorageGatewayClient.createSnapshotFromVolumeRecoveryPoint(crossinline block: CreateSnapshotFromVolumeRecoveryPointRequest.Builder.() -> Unit): CreateSnapshotFromVolumeRecoveryPointResponse = createSnapshotFromVolumeRecoveryPoint(CreateSnapshotFromVolumeRecoveryPointRequest.Builder().apply(block).build())

/**
 * Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.
 *
 * The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty gateway volume, then any existing data on the disk is erased.
 *
 * In the request, you must specify the gateway and the disk information on which you are creating the volume. In response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateStorediSCSIVolume.sample
 */
public suspend inline fun StorageGatewayClient.createStorediScsiVolume(crossinline block: CreateStorediScsiVolumeRequest.Builder.() -> Unit): CreateStorediScsiVolumeResponse = createStorediScsiVolume(CreateStorediScsiVolumeRequest.Builder().apply(block).build())

/**
 * Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are archived in the custom pool.
 */
public suspend inline fun StorageGatewayClient.createTapePool(crossinline block: CreateTapePoolRequest.Builder.() -> Unit): CreateTapePoolResponse = createTapePool(CreateTapePoolRequest.Builder().apply(block).build())

/**
 * Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on deleted tapes. This operation is only supported in the tape gateway type.
 *
 * Cache storage must be allocated to the gateway before you can create a virtual tape. Use the AddCache operation to add cache storage to a gateway.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateTapeWithBarcode.sample
 */
public suspend inline fun StorageGatewayClient.createTapeWithBarcode(crossinline block: CreateTapeWithBarcodeRequest.Builder.() -> Unit): CreateTapeWithBarcodeResponse = createTapeWithBarcode(CreateTapeWithBarcodeRequest.Builder().apply(block).build())

/**
 * Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation is only supported in the tape gateway type.
 *
 * Cache storage must be allocated to the gateway before you can create virtual tapes. Use the AddCache operation to add cache storage to a gateway.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.CreateTapes.sample
 */
public suspend inline fun StorageGatewayClient.createTapes(crossinline block: CreateTapesRequest.Builder.() -> Unit): CreateTapesResponse = createTapes(CreateTapesRequest.Builder().apply(block).build())

/**
 * Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.
 */
public suspend inline fun StorageGatewayClient.deleteAutomaticTapeCreationPolicy(crossinline block: DeleteAutomaticTapeCreationPolicyRequest.Builder.() -> Unit): DeleteAutomaticTapeCreationPolicyResponse = deleteAutomaticTapeCreationPolicy(DeleteAutomaticTapeCreationPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This operation is supported only for the stored volume, cached volume, and tape gateway types.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteBandwidthRateLimit.sample
 */
public suspend inline fun StorageGatewayClient.deleteBandwidthRateLimit(crossinline block: DeleteBandwidthRateLimitRequest.Builder.() -> Unit): DeleteBandwidthRateLimitResponse = deleteBandwidthRateLimit(DeleteBandwidthRateLimitRequest.Builder().apply(block).build())

/**
 * Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair. This operation is supported in volume and tape gateway types.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteChapCredentials.sample
 */
public suspend inline fun StorageGatewayClient.deleteChapCredentials(crossinline block: DeleteChapCredentialsRequest.Builder.() -> Unit): DeleteChapCredentialsResponse = deleteChapCredentials(DeleteChapCredentialsRequest.Builder().apply(block).build())

/**
 * Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.
 */
public suspend inline fun StorageGatewayClient.deleteFileShare(crossinline block: DeleteFileShareRequest.Builder.() -> Unit): DeleteFileShareResponse = deleteFileShare(DeleteFileShareRequest.Builder().apply(block).build())

/**
 * Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from your host computer.
 *
 * After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next step is to remove it from your environment.
 *
 * You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots persist and you will continue to be billed for these snapshots. You can choose to remove all remaining Amazon EBS snapshots by canceling your Amazon EC2 subscription. If you prefer not to cancel your Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2 console. For more information, see the [Storage Gateway detail page](http://aws.amazon.com/storagegateway).
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteGateway.sample
 */
public suspend inline fun StorageGatewayClient.deleteGateway(crossinline block: DeleteGatewayRequest.Builder.() -> Unit): DeleteGatewayResponse = deleteGateway(DeleteGatewayRequest.Builder().apply(block).build())

/**
 * Deletes a snapshot of a volume.
 *
 * You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to delete a snapshot schedule for a volume. For more information, see [Backing up your volumes](https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html). In the `DeleteSnapshotSchedule` request, you identify the volume by providing its Amazon Resource Name (ARN). This operation is only supported for cached volume gateway types.
 *
 * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteSnapshotSchedule.sample
 */
public suspend inline fun StorageGatewayClient.deleteSnapshotSchedule(crossinline block: DeleteSnapshotScheduleRequest.Builder.() -> Unit): DeleteSnapshotScheduleResponse = deleteSnapshotSchedule(DeleteSnapshotScheduleRequest.Builder().apply(block).build())

/**
 * Deletes the specified virtual tape. This operation is only supported in the tape gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteTape.sample
 */
public suspend inline fun StorageGatewayClient.deleteTape(crossinline block: DeleteTapeRequest.Builder.() -> Unit): DeleteTapeResponse = deleteTape(DeleteTapeRequest.Builder().apply(block).build())

/**
 * Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteTapeArchive.sample
 */
public suspend inline fun StorageGatewayClient.deleteTapeArchive(crossinline block: DeleteTapeArchiveRequest.Builder.() -> Unit): DeleteTapeArchiveResponse = deleteTapeArchive(DeleteTapeArchiveRequest.Builder().apply(block).build())

/**
 * Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there are no automatic tape creation policies that reference the custom tape pool.
 */
public suspend inline fun StorageGatewayClient.deleteTapePool(crossinline block: DeleteTapePoolRequest.Builder.() -> Unit): DeleteTapePoolResponse = deleteTapePool(DeleteTapePoolRequest.Builder().apply(block).build())

/**
 * Deletes the specified storage volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API. This operation is only supported in the cached volume and stored volume types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You can reuse the local disk to create another storage volume.
 *
 * Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are deleting and check the snapshot status. For more information, go to [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html) in the *Amazon Elastic Compute Cloud API Reference*.
 *
 * In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DeleteVolume.sample
 */
public suspend inline fun StorageGatewayClient.deleteVolume(crossinline block: DeleteVolumeRequest.Builder.() -> Unit): DeleteVolumeResponse = deleteVolume(DeleteVolumeRequest.Builder().apply(block).build())

/**
 * Returns information about the most recent high availability monitoring test that was performed on the host in a cluster. If a test isn't performed, the status and start time in the response would be null.
 */
public suspend inline fun StorageGatewayClient.describeAvailabilityMonitorTest(crossinline block: DescribeAvailabilityMonitorTestRequest.Builder.() -> Unit): DescribeAvailabilityMonitorTestResponse = describeAvailabilityMonitorTest(DescribeAvailabilityMonitorTestRequest.Builder().apply(block).build())

/**
 * Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth rate limiting is in effect. This operation is supported only for the stored volume, cached volume, and tape gateway types. To describe bandwidth rate limits for S3 file gateways, use DescribeBandwidthRateLimitSchedule.
 *
 * This operation returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for the gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeBandwidthRateLimit.sample
 */
public suspend inline fun StorageGatewayClient.describeBandwidthRateLimit(crossinline block: DescribeBandwidthRateLimitRequest.Builder.() -> Unit): DescribeBandwidthRateLimitResponse = describeBandwidthRateLimit(DescribeBandwidthRateLimitRequest.Builder().apply(block).build())

/**
 * Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported only for volume, tape and S3 file gateways. FSx file gateways do not support bandwidth rate limits.
 *
 * This operation returns information about a gateway's bandwidth rate limit schedule. A bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the week, during which bandwidth rate limits are specified for uploading, downloading, or both.
 *
 *  A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute, an ending hour and minute, and bandwidth rate limits for uploading and downloading
 *
 *  If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an empty response. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
 */
public suspend inline fun StorageGatewayClient.describeBandwidthRateLimitSchedule(crossinline block: DescribeBandwidthRateLimitScheduleRequest.Builder.() -> Unit): DescribeBandwidthRateLimitScheduleResponse = describeBandwidthRateLimitSchedule(DescribeBandwidthRateLimitScheduleRequest.Builder().apply(block).build())

/**
 * Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape, and file gateway types.
 *
 * The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and used.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeCache.sample
 */
public suspend inline fun StorageGatewayClient.describeCache(crossinline block: DescribeCacheRequest.Builder.() -> Unit): DescribeCacheResponse = describeCache(DescribeCacheRequest.Builder().apply(block).build())

/**
 * Returns a description of the gateway volumes specified in the request. This operation is only supported in the cached volume gateway types.
 *
 * The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume Amazon Resource Name (ARN).
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeCachediSCSIVolumes.sample
 */
public suspend inline fun StorageGatewayClient.describeCachediScsiVolumes(crossinline block: DescribeCachediScsiVolumesRequest.Builder.() -> Unit): DescribeCachediScsiVolumesResponse = describeCachediScsiVolumes(DescribeCachediScsiVolumesRequest.Builder().apply(block).build())

/**
 * Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway types.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeChapCredentials.sample
 */
public suspend inline fun StorageGatewayClient.describeChapCredentials(crossinline block: DescribeChapCredentialsRequest.Builder.() -> Unit): DescribeChapCredentialsResponse = describeChapCredentials(DescribeChapCredentialsRequest.Builder().apply(block).build())

/**
 * Gets the file system association information. This operation is only supported for FSx File Gateways.
 */
public suspend inline fun StorageGatewayClient.describeFileSystemAssociations(crossinline block: DescribeFileSystemAssociationsRequest.Builder.() -> Unit): DescribeFileSystemAssociationsResponse = describeFileSystemAssociations(DescribeFileSystemAssociationsRequest.Builder().apply(block).build())

/**
 * Returns metadata about a gateway such as its name, network interfaces, time zone, status, and software version. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeGatewayInformation.sample
 */
public suspend inline fun StorageGatewayClient.describeGatewayInformation(crossinline block: DescribeGatewayInformationRequest.Builder.() -> Unit): DescribeGatewayInformationResponse = describeGatewayInformation(DescribeGatewayInformationRequest.Builder().apply(block).build())

/**
 * Returns your gateway's maintenance window schedule information, with values for monthly or weekly cadence, specific day and time to begin maintenance, and which types of updates to apply. Time values returned are for the gateway's time zone.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeMaintenanceStartTime.sample
 */
public suspend inline fun StorageGatewayClient.describeMaintenanceStartTime(crossinline block: DescribeMaintenanceStartTimeRequest.Builder.() -> Unit): DescribeMaintenanceStartTimeResponse = describeMaintenanceStartTime(DescribeMaintenanceStartTimeRequest.Builder().apply(block).build())

/**
 * Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation is only supported for S3 File Gateways.
 */
public suspend inline fun StorageGatewayClient.describeNfsFileShares(crossinline block: DescribeNfsFileSharesRequest.Builder.() -> Unit): DescribeNfsFileSharesResponse = describeNfsFileShares(DescribeNfsFileSharesRequest.Builder().apply(block).build())

/**
 * Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation is only supported for S3 File Gateways.
 */
public suspend inline fun StorageGatewayClient.describeSmbFileShares(crossinline block: DescribeSmbFileSharesRequest.Builder.() -> Unit): DescribeSmbFileSharesResponse = describeSmbFileShares(DescribeSmbFileSharesRequest.Builder().apply(block).build())

/**
 * Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is only supported for file gateways.
 */
public suspend inline fun StorageGatewayClient.describeSmbSettings(crossinline block: DescribeSmbSettingsRequest.Builder.() -> Unit): DescribeSmbSettingsResponse = describeSmbSettings(DescribeSmbSettingsRequest.Builder().apply(block).build())

/**
 * Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the cached volume and stored volume types.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeSnapshotSchedule.sample
 */
public suspend inline fun StorageGatewayClient.describeSnapshotSchedule(crossinline block: DescribeSnapshotScheduleRequest.Builder.() -> Unit): DescribeSnapshotScheduleResponse = describeSnapshotSchedule(DescribeSnapshotScheduleRequest.Builder().apply(block).build())

/**
 * Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported in stored volume gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeStorediSCSIVolumes.sample
 */
public suspend inline fun StorageGatewayClient.describeStorediScsiVolumes(crossinline block: DescribeStorediScsiVolumesRequest.Builder.() -> Unit): DescribeStorediScsiVolumesResponse = describeStorediScsiVolumes(DescribeStorediScsiVolumesRequest.Builder().apply(block).build())

/**
 * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.
 *
 * If a specific `TapeARN` is not specified, Storage Gateway returns a description of all virtual tapes found in the VTS associated with your account.
 */
public suspend inline fun StorageGatewayClient.describeTapeArchives(crossinline block: DescribeTapeArchivesRequest.Builder.() -> Unit): DescribeTapeArchivesResponse = describeTapeArchives(DescribeTapeArchivesRequest.Builder().apply(block).build())

/**
 * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
 *
 * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway. This operation is only supported in the tape gateway type.
 */
public suspend inline fun StorageGatewayClient.describeTapeRecoveryPoints(crossinline block: DescribeTapeRecoveryPointsRequest.Builder.() -> Unit): DescribeTapeRecoveryPointsResponse = describeTapeRecoveryPoints(DescribeTapeRecoveryPointsRequest.Builder().apply(block).build())

/**
 * Returns a description of virtual tapes that correspond to the specified Amazon Resource Names (ARNs). If `TapeARN` is not specified, returns a description of the virtual tapes associated with the specified gateway. This operation is only supported for the tape gateway type.
 *
 * The operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the `Limit` field in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a `Marker` field. You can use this `Marker` value in your subsequent request to retrieve the next set of tapes.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeTapes.sample
 */
public suspend inline fun StorageGatewayClient.describeTapes(crossinline block: DescribeTapesRequest.Builder.() -> Unit): DescribeTapesResponse = describeTapes(DescribeTapesRequest.Builder().apply(block).build())

/**
 * Returns information about the upload buffer of a gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.
 *
 * The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload buffer space allocated and used.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeUploadBuffer.sample
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeUploadBuffer.sample2
 */
public suspend inline fun StorageGatewayClient.describeUploadBuffer(crossinline block: DescribeUploadBufferRequest.Builder.() -> Unit): DescribeUploadBufferResponse = describeUploadBuffer(DescribeUploadBufferRequest.Builder().apply(block).build())

/**
 * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, Storage Gateway returns VTL device information.
 *
 * This operation is only supported in the tape gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeVTLDevices.sample
 */
public suspend inline fun StorageGatewayClient.describeVtlDevices(crossinline block: DescribeVtlDevicesRequest.Builder.() -> Unit): DescribeVtlDevicesResponse = describeVtlDevices(DescribeVtlDevicesRequest.Builder().apply(block).build())

/**
 * Returns information about the working storage of a gateway. This operation is only supported in the stored volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use DescribeUploadBuffer instead.
 *
 * Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.
 *
 * The response includes disk IDs that are configured as working storage, and it includes the amount of working storage allocated and used.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DescribeWorkingStorage.sample
 */
public suspend inline fun StorageGatewayClient.describeWorkingStorage(crossinline block: DescribeWorkingStorageRequest.Builder.() -> Unit): DescribeWorkingStorageResponse = describeWorkingStorage(DescribeWorkingStorageRequest.Builder().apply(block).build())

/**
 * Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance. This operation is only supported in the volume gateway type.
 */
public suspend inline fun StorageGatewayClient.detachVolume(crossinline block: DetachVolumeRequest.Builder.() -> Unit): DetachVolumeResponse = detachVolume(DetachVolumeRequest.Builder().apply(block).build())

/**
 * Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.
 *
 * Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported in the tape gateway type.
 *
 * After a gateway is disabled, it cannot be enabled.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.DisableGateway.sample
 */
public suspend inline fun StorageGatewayClient.disableGateway(crossinline block: DisableGatewayRequest.Builder.() -> Unit): DisableGatewayResponse = disableGateway(DisableGatewayRequest.Builder().apply(block).build())

/**
 * Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes, the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File Gateway type.
 */
public suspend inline fun StorageGatewayClient.disassociateFileSystem(crossinline block: DisassociateFileSystemRequest.Builder.() -> Unit): DisassociateFileSystemResponse = disassociateFileSystem(DisassociateFileSystemRequest.Builder().apply(block).build())

/**
 * Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that support the SMB file protocol.
 *
 * Joining a domain creates an Active Directory computer account in the default organizational unit, using the gateway's **Gateway ID** as the account name (for example, SGW-1234ADE). If your Active Directory environment requires that you pre-stage accounts to facilitate the join domain process, you will need to create this account ahead of time.
 *
 * To create the gateway's computer account in an organizational unit other than the default, you must specify the organizational unit when joining the domain.
 */
public suspend inline fun StorageGatewayClient.joinDomain(crossinline block: JoinDomainRequest.Builder.() -> Unit): JoinDomainResponse = joinDomain(JoinDomainRequest.Builder().apply(block).build())

/**
 * Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for the gateway, it returns an empty list.
 *
 * This operation is only supported for tape gateways.
 */
public suspend inline fun StorageGatewayClient.listAutomaticTapeCreationPolicies(crossinline block: ListAutomaticTapeCreationPoliciesRequest.Builder.() -> Unit): ListAutomaticTapeCreationPoliciesResponse = listAutomaticTapeCreationPolicies(ListAutomaticTapeCreationPoliciesRequest.Builder().apply(block).build())

/**
 * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the calling Amazon Web Services account. This operation is only supported for S3 File Gateways.
 */
public suspend inline fun StorageGatewayClient.listFileShares(crossinline block: ListFileSharesRequest.Builder.() -> Unit): ListFileSharesResponse = listFileShares(ListFileSharesRequest.Builder().apply(block).build())

/**
 * Gets a list of `FileSystemAssociationSummary` objects. Each object contains a summary of a file system association. This operation is only supported for FSx File Gateways.
 */
public suspend inline fun StorageGatewayClient.listFileSystemAssociations(crossinline block: ListFileSystemAssociationsRequest.Builder.() -> Unit): ListFileSystemAssociationsResponse = listFileSystemAssociations(ListFileSystemAssociationsRequest.Builder().apply(block).build())

/**
 * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).
 *
 * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you to optionally reduce the number of gateways returned in a response.
 *
 * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of your gateways), the response contains a marker that you can specify in your next request to fetch the next page of gateways.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ListGateways.sample
 */
public suspend inline fun StorageGatewayClient.listGateways(crossinline block: ListGatewaysRequest.Builder.() -> Unit): ListGatewaysResponse = listGateways(ListGatewaysRequest.Builder().apply(block).build())

/**
 * Returns a list of the gateway's local disks. To specify which gateway to describe, you use the Amazon Resource Name (ARN) of the gateway in the body of the request.
 *
 * The request returns a list of all disks, specifying which are configured as working storage, cache storage, or stored volume or not configured at all. The response includes a `DiskStatus` field. This field can have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway), or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ListLocalDisks.sample
 */
public suspend inline fun StorageGatewayClient.listLocalDisks(crossinline block: ListLocalDisksRequest.Builder.() -> Unit): ListLocalDisksResponse = listLocalDisks(ListLocalDisksRequest.Builder().apply(block).build())

/**
 * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of all types.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ListTagsForResource.sample
 */
public suspend inline fun StorageGatewayClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
 *
 * This operation supports pagination. You can optionally specify the `Limit` parameter in the body to limit the number of tape pools in the response. If the number of tape pools returned in the response is truncated, the response includes a `Marker` element that you can use in your subsequent request to retrieve the next set of tape pools.
 */
public suspend inline fun StorageGatewayClient.listTapePools(crossinline block: ListTapePoolsRequest.Builder.() -> Unit): ListTapePoolsResponse = listTapePools(ListTapePoolsRequest.Builder().apply(block).build())

/**
 * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation lists all virtual tapes in both your VTL and VTS.
 *
 * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the `Limit` parameter in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a `Marker` element that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported in the tape gateway type.
 */
public suspend inline fun StorageGatewayClient.listTapes(crossinline block: ListTapesRequest.Builder.() -> Unit): ListTapesResponse = listTapes(ListTapesRequest.Builder().apply(block).build())

/**
 * Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume is being used or not. This operation is only supported in the cached volume and stored volume gateway types.
 */
public suspend inline fun StorageGatewayClient.listVolumeInitiators(crossinline block: ListVolumeInitiatorsRequest.Builder.() -> Unit): ListVolumeInitiatorsResponse = listVolumeInitiators(ListVolumeInitiatorsRequest.Builder().apply(block).build())

/**
 * Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway type.
 *
 * Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume. To create a snapshot from a volume recovery point use the CreateSnapshotFromVolumeRecoveryPoint operation.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ListVolumeRecoveryPoints.sample
 */
public suspend inline fun StorageGatewayClient.listVolumeRecoveryPoints(crossinline block: ListVolumeRecoveryPointsRequest.Builder.() -> Unit): ListVolumeRecoveryPointsResponse = listVolumeRecoveryPoints(ListVolumeRecoveryPointsRequest.Builder().apply(block).build())

/**
 * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the volume ARNs. If you want additional volume information, use the DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes API.
 *
 * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can optionally specify the `Limit` field in the body to limit the number of volumes in the response. If the number of volumes returned in the response is truncated, the response includes a Marker field. You can use this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only supported in the cached volume and stored volume gateway types.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ListVolumes.sample
 */
public suspend inline fun StorageGatewayClient.listVolumes(crossinline block: ListVolumesRequest.Builder.() -> Unit): ListVolumesResponse = listVolumes(ListVolumesRequest.Builder().apply(block).build())

/**
 * Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to Amazon S3.
 *
 * Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file share up to that point in time have been uploaded to Amazon S3. These files include files written to the file share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File Gateways.
 *
 * For more information, see [Getting file upload notification](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*.
 */
public suspend inline fun StorageGatewayClient.notifyWhenUploaded(crossinline block: NotifyWhenUploadedRequest.Builder.() -> Unit): NotifyWhenUploadedResponse = notifyWhenUploaded(NotifyWhenUploadedRequest.Builder().apply(block).build())

/**
 * Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only supported in the S3 File Gateway types.
 *
 * You can subscribe to be notified through an Amazon CloudWatch event when your `RefreshCache` operation completes. For more information, see [Getting notified about file operations](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*. This operation is Only supported for S3 File Gateways.
 *
 * When this API is called, it only initiates the refresh operation. When the API call completes and returns a success code, it doesn't necessarily mean that the file refresh has completed. You should use the refresh-complete notification to determine that the operation has completed before you check for new files on the gateway file share. You can subscribe to be notified through a CloudWatch event when your `RefreshCache` operation completes.
 *
 * Throttle limit: This API is asynchronous, so the gateway will accept no more than two refreshes at any time. We recommend using the refresh-complete CloudWatch event notification before issuing additional requests. For more information, see [Getting notified about file operations](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*.
 *
 * + Wait at least 60 seconds between consecutive RefreshCache API requests.
 * + If you invoke the RefreshCache API when two requests are already being processed, any new request will cause an `InvalidGatewayRequestException` error because too many requests were sent to the server.
 * The S3 bucket name does not need to be included when entering the list of folders in the FolderList parameter.
 *
 * For more information, see [Getting notified about file operations](https://docs.aws.amazon.com/filegateway/latest/files3/monitoring-file-gateway.html#get-notification) in the *Amazon S3 File Gateway User Guide*.
 */
public suspend inline fun StorageGatewayClient.refreshCache(crossinline block: RefreshCacheRequest.Builder.() -> Unit): RefreshCacheResponse = refreshCache(RefreshCacheRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource. This operation is supported in storage gateways of all types.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.RemoveTagsFromResource.sample
 */
public suspend inline fun StorageGatewayClient.removeTagsFromResource(crossinline block: RemoveTagsFromResourceRequest.Builder.() -> Unit): RemoveTagsFromResourceResponse = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

/**
 * Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks. This operation is only supported in the cached volume and tape types.
 *
 * If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must configure at least one new cache disk for your gateway to function properly.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ResetCache.sample
 */
public suspend inline fun StorageGatewayClient.resetCache(crossinline block: ResetCacheRequest.Builder.() -> Unit): ResetCacheResponse = resetCache(ResetCacheRequest.Builder().apply(block).build())

/**
 * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway, even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway type.
 *
 * Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must archive the tape again before you can retrieve it to another gateway. This operation is only supported in the tape gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.RetrieveTapeArchive.sample
 */
public suspend inline fun StorageGatewayClient.retrieveTapeArchive(crossinline block: RetrieveTapeArchiveRequest.Builder.() -> Unit): RetrieveTapeArchiveResponse = retrieveTapeArchive(RetrieveTapeArchiveRequest.Builder().apply(block).build())

/**
 * Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway type.
 *
 * A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
 *
 * The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge for retrieving recovery points.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.RetrieveTapeRecoveryPoint.sample
 */
public suspend inline fun StorageGatewayClient.retrieveTapeRecoveryPoint(crossinline block: RetrieveTapeRecoveryPointRequest.Builder.() -> Unit): RetrieveTapeRecoveryPointResponse = retrieveTapeRecoveryPoint(RetrieveTapeRecoveryPointRequest.Builder().apply(block).build())

/**
 * Sets the password for your VM local console. When you log in to the local console for the first time, you log in to the VM with the default credentials. We recommend that you set a new password. You don't need to know the default password to set a new password.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.SetLocalConsolePassword.sample
 */
public suspend inline fun StorageGatewayClient.setLocalConsolePassword(crossinline block: SetLocalConsolePasswordRequest.Builder.() -> Unit): SetLocalConsolePasswordResponse = setLocalConsolePassword(SetLocalConsolePasswordRequest.Builder().apply(block).build())

/**
 * Sets the password for the guest user `smbguest`. The `smbguest` user is the user when the authentication method for the file share is set to `GuestAccess`. This operation only supported for S3 File Gateways
 */
public suspend inline fun StorageGatewayClient.setSmbGuestPassword(crossinline block: SetSmbGuestPasswordRequest.Builder.() -> Unit): SetSmbGuestPasswordResponse = setSmbGuestPassword(SetSmbGuestPasswordRequest.Builder().apply(block).build())

/**
 * Shuts down a Tape Gateway or Volume Gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in the body of your request.
 *
 * This API action cannot be used to shut down S3 File Gateway or FSx File Gateway.
 *
 * The operation shuts down the gateway service component running in the gateway's virtual machine (VM) and not the host VM.
 *
 * If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to avoid unpredictable conditions.
 *
 * After the gateway is shutdown, you cannot call any other API except StartGateway, DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway. Your applications cannot read from or write to the gateway's storage volumes, and there are no snapshots taken.
 *
 * When you make a shutdown request, you will get a `200 OK` success response immediately. However, it might take some time for the gateway to shut down. You can call the DescribeGatewayInformation API to check the status. For more information, see ActivateGateway.
 *
 * If do not intend to use the gateway again, you must delete the gateway (using DeleteGateway) to no longer pay software charges associated with the gateway.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.ShutdownGateway.sample
 */
public suspend inline fun StorageGatewayClient.shutdownGateway(crossinline block: ShutdownGatewayRequest.Builder.() -> Unit): ShutdownGatewayResponse = shutdownGateway(ShutdownGatewayRequest.Builder().apply(block).build())

/**
 * Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host environment. This request only initiates the test and that a successful response only indicates that the test was started. It doesn't indicate that the test passed. For the status of the test, invoke the `DescribeAvailabilityMonitorTest` API.
 *
 * Starting this test will cause your gateway to go offline for a brief period.
 */
public suspend inline fun StorageGatewayClient.startAvailabilityMonitorTest(crossinline block: StartAvailabilityMonitorTestRequest.Builder.() -> Unit): StartAvailabilityMonitorTestResponse = startAvailabilityMonitorTest(StartAvailabilityMonitorTestRequest.Builder().apply(block).build())

/**
 * Starts a gateway that you previously shut down (see ShutdownGateway). After the gateway starts, you can then make other API calls, your applications can read from or write to the gateway's storage volumes and you will be able to take snapshot backups.
 *
 * When you make a request, you will get a 200 OK success response immediately. However, it might take some time for the gateway to be ready. You should call DescribeGatewayInformation and check the status before making any additional API calls. For more information, see ActivateGateway.
 *
 * To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.StartGateway.sample
 */
public suspend inline fun StorageGatewayClient.startGateway(crossinline block: StartGatewayRequest.Builder.() -> Unit): StartGatewayResponse = startGateway(StartGatewayRequest.Builder().apply(block).build())

/**
 * Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of automatic tape creation rules. This is only supported for tape gateways.
 *
 * By default, there is no automatic tape creation policy.
 *
 * A gateway can have only one automatic tape creation policy.
 */
public suspend inline fun StorageGatewayClient.updateAutomaticTapeCreationPolicy(crossinline block: UpdateAutomaticTapeCreationPolicyRequest.Builder.() -> Unit): UpdateAutomaticTapeCreationPolicyResponse = updateAutomaticTapeCreationPolicy(UpdateAutomaticTapeCreationPolicyRequest.Builder().apply(block).build())

/**
 * Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This operation is supported only for the stored volume, cached volume, and tape gateway types. To update bandwidth rate limits for S3 file gateways, use UpdateBandwidthRateLimitSchedule.
 *
 * By default, a gateway's bandwidth rate limits are not set. If you don't set any limit, the gateway does not have any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.
 *
 * To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateBandwidthRateLimit.sample
 */
public suspend inline fun StorageGatewayClient.updateBandwidthRateLimit(crossinline block: UpdateBandwidthRateLimitRequest.Builder.() -> Unit): UpdateBandwidthRateLimitResponse = updateBandwidthRateLimit(UpdateBandwidthRateLimitRequest.Builder().apply(block).build())

/**
 * Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a gateway's bandwidth rate limit schedule. This operation is supported for volume, tape, and S3 file gateways. S3 file gateways support bandwidth rate limits for upload only. FSx file gateways do not support bandwidth rate limits.
 */
public suspend inline fun StorageGatewayClient.updateBandwidthRateLimitSchedule(crossinline block: UpdateBandwidthRateLimitScheduleRequest.Builder.() -> Unit): UpdateBandwidthRateLimitScheduleResponse = updateBandwidthRateLimitSchedule(UpdateBandwidthRateLimitScheduleRequest.Builder().apply(block).build())

/**
 * Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is supported in the volume and tape gateway types.
 *
 * When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect with the new credentials.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateChapCredentials.sample
 */
public suspend inline fun StorageGatewayClient.updateChapCredentials(crossinline block: UpdateChapCredentialsRequest.Builder.() -> Unit): UpdateChapCredentialsResponse = updateChapCredentials(UpdateChapCredentialsRequest.Builder().apply(block).build())

/**
 * Updates a file system association. This operation is only supported in the FSx File Gateways.
 */
public suspend inline fun StorageGatewayClient.updateFileSystemAssociation(crossinline block: UpdateFileSystemAssociationRequest.Builder.() -> Unit): UpdateFileSystemAssociationResponse = updateFileSystemAssociation(UpdateFileSystemAssociationRequest.Builder().apply(block).build())

/**
 * Updates a gateway's metadata, which includes the gateway's name, time zone, and metadata cache size. To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
 *
 * For gateways activated after September 2, 2015, the gateway's ARN contains the gateway ID rather than the gateway name. However, changing the name of the gateway has no effect on the gateway's ARN.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateGatewayInformation.sample
 */
public suspend inline fun StorageGatewayClient.updateGatewayInformation(crossinline block: UpdateGatewayInformationRequest.Builder.() -> Unit): UpdateGatewayInformationResponse = updateGatewayInformation(UpdateGatewayInformationRequest.Builder().apply(block).build())

/**
 * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
 *
 * When you make this request, you get a `200 OK` success response immediately. However, it might take some time for the update to complete. You can call DescribeGatewayInformation to verify the gateway is in the `STATE_RUNNING` state.
 *
 * A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your applications by increasing your iSCSI Initiators' timeouts. For more information about increasing iSCSI Initiator timeouts for Windows and Linux, see [Customizing your Windows iSCSI settings](https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings) and [Customizing your Linux iSCSI settings](https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings), respectively.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateGatewaySoftwareNow.sample
 */
public suspend inline fun StorageGatewayClient.updateGatewaySoftwareNow(crossinline block: UpdateGatewaySoftwareNowRequest.Builder.() -> Unit): UpdateGatewaySoftwareNowResponse = updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest.Builder().apply(block).build())

/**
 * Updates a gateway's maintenance window schedule, with settings for monthly or weekly cadence, specific day and time to begin maintenance, and which types of updates to apply. Time configuration uses the gateway's time zone. You can pass values for a complete maintenance schedule, or update policy, or both. Previous values will persist for whichever setting you choose not to modify. If an incomplete or invalid maintenance schedule is passed, the entire request will be rejected with an error and no changes will occur.
 *
 * A complete maintenance schedule must include values for *both*`MinuteOfHour` and `HourOfDay`, and *either*`DayOfMonth`*or*`DayOfWeek`.
 *
 * We recommend keeping maintenance updates turned on, except in specific use cases where the brief disruptions caused by updating the gateway could critically impact your deployment.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateMaintenanceStartTime.sample
 */
public suspend inline fun StorageGatewayClient.updateMaintenanceStartTime(crossinline block: UpdateMaintenanceStartTimeRequest.Builder.() -> Unit): UpdateMaintenanceStartTimeResponse = updateMaintenanceStartTime(UpdateMaintenanceStartTimeRequest.Builder().apply(block).build())

/**
 * Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.
 *
 * To leave a file share field unchanged, set the corresponding input field to null.
 *
 * Updates the following file share settings:
 * + Default storage class for your S3 bucket
 * + Metadata defaults for your S3 bucket
 * + Allowed NFS clients for your file share
 * + Squash settings
 * + Write status of your file share
 */
public suspend inline fun StorageGatewayClient.updateNfsFileShare(crossinline block: UpdateNfsFileShareRequest.Builder.() -> Unit): UpdateNfsFileShareResponse = updateNfsFileShare(UpdateNfsFileShareRequest.Builder().apply(block).build())

/**
 * Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.
 *
 * To leave a file share field unchanged, set the corresponding input field to null.
 *
 * File gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are creating your file gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region, activate it. For information about how to activate Amazon Web Services STS, see [Activating and deactivating Amazon Web Services STS in an Amazon Web Services Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html) in the *Identity and Access Management User Guide*.
 *
 * File gateways don't support creating hard or symbolic links on a file share.
 */
public suspend inline fun StorageGatewayClient.updateSmbFileShare(crossinline block: UpdateSmbFileShareRequest.Builder.() -> Unit): UpdateSmbFileShareResponse = updateSmbFileShare(UpdateSmbFileShareRequest.Builder().apply(block).build())

/**
 * Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only supported for S3 File Gateways.
 */
public suspend inline fun StorageGatewayClient.updateSmbFileShareVisibility(crossinline block: UpdateSmbFileShareVisibilityRequest.Builder.() -> Unit): UpdateSmbFileShareVisibilityResponse = updateSmbFileShareVisibility(UpdateSmbFileShareVisibilityRequest.Builder().apply(block).build())

/**
 * Updates the list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
 */
public suspend inline fun StorageGatewayClient.updateSmbLocalGroups(crossinline block: UpdateSmbLocalGroupsRequest.Builder.() -> Unit): UpdateSmbLocalGroupsResponse = updateSmbLocalGroups(UpdateSmbLocalGroupsRequest.Builder().apply(block).build())

/**
 * Updates the SMB security strategy level for an Amazon S3 file gateway. This action is only supported for Amazon S3 file gateways.
 *
 * For information about configuring this setting using the Amazon Web Services console, see [Setting a security level for your gateway](https://docs.aws.amazon.com/filegateway/latest/files3/security-strategy.html) in the *Amazon S3 File Gateway User Guide*.
 *
 * A higher security strategy level can affect performance of the gateway.
 */
public suspend inline fun StorageGatewayClient.updateSmbSecurityStrategy(crossinline block: UpdateSmbSecurityStrategyRequest.Builder.() -> Unit): UpdateSmbSecurityStrategyResponse = updateSmbSecurityStrategy(UpdateSmbSecurityStrategyRequest.Builder().apply(block).build())

/**
 * Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached volume and stored volume gateway types.
 *
 * The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You can use this API to change the snapshot schedule configured for the volume.
 *
 * In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateSnapshotSchedule.sample
 */
public suspend inline fun StorageGatewayClient.updateSnapshotSchedule(crossinline block: UpdateSnapshotScheduleRequest.Builder.() -> Unit): UpdateSnapshotScheduleResponse = updateSnapshotSchedule(UpdateSnapshotScheduleRequest.Builder().apply(block).build())

/**
 * Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium changer type for the tape gateway. This operation enables you to select a different type of medium changer after a tape gateway is activated. This operation is only supported in the tape gateway type.
 *
 * @sample aws.sdk.kotlin.services.storagegateway.samples.UpdateVTLDeviceType.sample
 */
public suspend inline fun StorageGatewayClient.updateVtlDeviceType(crossinline block: UpdateVtlDeviceTypeRequest.Builder.() -> Unit): UpdateVtlDeviceTypeResponse = updateVtlDeviceType(UpdateVtlDeviceTypeRequest.Builder().apply(block).build())
