// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.serde

import aws.sdk.kotlin.services.storagegateway.model.DescribeGatewayInformationResponse
import aws.sdk.kotlin.services.storagegateway.model.GatewayCapacity
import aws.sdk.kotlin.services.storagegateway.model.HostEnvironment
import aws.sdk.kotlin.services.storagegateway.model.NetworkInterface
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.sdk.kotlin.services.storagegateway.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeGatewayInformationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeGatewayInformationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeGatewayInformationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeGatewayInformationError(context, call, payload)
        }
        val builder = DescribeGatewayInformationResponse.Builder()

        if (payload != null) {
            deserializeDescribeGatewayInformationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeGatewayInformationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeGatewayInformationOperationBody(builder: DescribeGatewayInformationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLOUDWATCHLOGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CloudWatchLogGroupARN"))
    val DEPRECATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeprecationDate"))
    val EC2INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Ec2InstanceId"))
    val EC2INSTANCEREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Ec2InstanceRegion"))
    val ENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointType"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayARN"))
    val GATEWAYCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("GatewayCapacity"))
    val GATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayId"))
    val GATEWAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayName"))
    val GATEWAYNETWORKINTERFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GatewayNetworkInterfaces"))
    val GATEWAYSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayState"))
    val GATEWAYTIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayTimezone"))
    val GATEWAYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayType"))
    val HOSTENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HostEnvironment"))
    val HOSTENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HostEnvironmentId"))
    val LASTSOFTWAREUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastSoftwareUpdate"))
    val NEXTUPDATEAVAILABILITYDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextUpdateAvailabilityDate"))
    val SOFTWAREUPDATESENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SoftwareUpdatesEndDate"))
    val SOFTWAREVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SoftwareVersion"))
    val SUPPORTEDGATEWAYCAPACITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SupportedGatewayCapacities"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VPCENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VPCEndpoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLOUDWATCHLOGGROUPARN_DESCRIPTOR)
        field(DEPRECATIONDATE_DESCRIPTOR)
        field(EC2INSTANCEID_DESCRIPTOR)
        field(EC2INSTANCEREGION_DESCRIPTOR)
        field(ENDPOINTTYPE_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
        field(GATEWAYCAPACITY_DESCRIPTOR)
        field(GATEWAYID_DESCRIPTOR)
        field(GATEWAYNAME_DESCRIPTOR)
        field(GATEWAYNETWORKINTERFACES_DESCRIPTOR)
        field(GATEWAYSTATE_DESCRIPTOR)
        field(GATEWAYTIMEZONE_DESCRIPTOR)
        field(GATEWAYTYPE_DESCRIPTOR)
        field(HOSTENVIRONMENT_DESCRIPTOR)
        field(HOSTENVIRONMENTID_DESCRIPTOR)
        field(LASTSOFTWAREUPDATE_DESCRIPTOR)
        field(NEXTUPDATEAVAILABILITYDATE_DESCRIPTOR)
        field(SOFTWAREUPDATESENDDATE_DESCRIPTOR)
        field(SOFTWAREVERSION_DESCRIPTOR)
        field(SUPPORTEDGATEWAYCAPACITIES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCENDPOINT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLOUDWATCHLOGGROUPARN_DESCRIPTOR.index -> builder.cloudWatchLogGroupArn = deserializeString()
                DEPRECATIONDATE_DESCRIPTOR.index -> builder.deprecationDate = deserializeString()
                EC2INSTANCEID_DESCRIPTOR.index -> builder.ec2InstanceId = deserializeString()
                EC2INSTANCEREGION_DESCRIPTOR.index -> builder.ec2InstanceRegion = deserializeString()
                ENDPOINTTYPE_DESCRIPTOR.index -> builder.endpointType = deserializeString()
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                GATEWAYCAPACITY_DESCRIPTOR.index -> builder.gatewayCapacity = deserializeString().let { GatewayCapacity.fromValue(it) }
                GATEWAYID_DESCRIPTOR.index -> builder.gatewayId = deserializeString()
                GATEWAYNAME_DESCRIPTOR.index -> builder.gatewayName = deserializeString()
                GATEWAYNETWORKINTERFACES_DESCRIPTOR.index -> builder.gatewayNetworkInterfaces =
                    deserializer.deserializeList(GATEWAYNETWORKINTERFACES_DESCRIPTOR) {
                        val col0 = mutableListOf<NetworkInterface>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNetworkInterfaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GATEWAYSTATE_DESCRIPTOR.index -> builder.gatewayState = deserializeString()
                GATEWAYTIMEZONE_DESCRIPTOR.index -> builder.gatewayTimezone = deserializeString()
                GATEWAYTYPE_DESCRIPTOR.index -> builder.gatewayType = deserializeString()
                HOSTENVIRONMENT_DESCRIPTOR.index -> builder.hostEnvironment = deserializeString().let { HostEnvironment.fromValue(it) }
                HOSTENVIRONMENTID_DESCRIPTOR.index -> builder.hostEnvironmentId = deserializeString()
                LASTSOFTWAREUPDATE_DESCRIPTOR.index -> builder.lastSoftwareUpdate = deserializeString()
                NEXTUPDATEAVAILABILITYDATE_DESCRIPTOR.index -> builder.nextUpdateAvailabilityDate = deserializeString()
                SOFTWAREUPDATESENDDATE_DESCRIPTOR.index -> builder.softwareUpdatesEndDate = deserializeString()
                SOFTWAREVERSION_DESCRIPTOR.index -> builder.softwareVersion = deserializeString()
                SUPPORTEDGATEWAYCAPACITIES_DESCRIPTOR.index -> builder.supportedGatewayCapacities =
                    deserializer.deserializeList(SUPPORTEDGATEWAYCAPACITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<GatewayCapacity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { GatewayCapacity.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCENDPOINT_DESCRIPTOR.index -> builder.vpcEndpoint = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
