// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * UpdateSMBFileShareInput
 */
public class UpdateSmbFileShareRequest private constructor(builder: Builder) {
    /**
     * The files and folders on this share will only be visible to users with read access.
     */
    public val accessBasedEnumeration: kotlin.Boolean? = builder.accessBasedEnumeration
    /**
     * A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
     */
    public val adminUserList: List<String>? = builder.adminUserList
    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public val auditDestinationArn: kotlin.String? = builder.auditDestinationArn
    /**
     * Specifies refresh cache information for the file share.
     */
    public val cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = builder.cacheAttributes
    /**
     * The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     */
    public val caseSensitivity: aws.sdk.kotlin.services.storagegateway.model.CaseSensitivity? = builder.caseSensitivity
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
     *
     * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
     */
    public val defaultStorageClass: kotlin.String? = builder.defaultStorageClass
    /**
     * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * The name of the file share. Optional.
     *
     * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
     */
    public val fileShareName: kotlin.String? = builder.fileShareName
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
     *
     * Valid Values: `true` | `false`
     */
    public val guessMimeTypeEnabled: kotlin.Boolean? = builder.guessMimeTypeEnabled
    /**
     * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
     */
    public val invalidUserList: List<String>? = builder.invalidUserList
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
     *
     * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
     *
     * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
     *
     * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
     *
     * The following example sets `NotificationPolicy` off.
     *
     * `{}`
     */
    public val notificationPolicy: kotlin.String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
     */
    public val objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = builder.objectAcl
    /**
     * Specifies whether opportunistic locking is enabled for the SMB file share.
     *
     * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.
     *
     * Valid Values: `true` | `false`
     */
    public val oplocksEnabled: kotlin.Boolean? = builder.oplocksEnabled
    /**
     * A value that sets the write status of a file share. Set this value to `true` to set write status to read-only, otherwise set to `false`.
     *
     * Valid Values: `true` | `false`
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
     *
     * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
     *
     * Valid Values: `true` | `false`
     */
    public val requesterPays: kotlin.Boolean? = builder.requesterPays
    /**
     * Set this value to `true` to enable access control list (ACL) on the SMB file share. Set it to `false` to map file and directory permissions to the POSIX permissions.
     *
     * For more information, see [Using Microsoft Windows ACLs to control access to an SMB file share](https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html) in the *Storage Gateway User Guide*.
     *
     * Valid Values: `true` | `false`
     */
    public val smbaclEnabled: kotlin.Boolean? = builder.smbaclEnabled
    /**
     * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
     */
    public val validUserList: List<String>? = builder.validUserList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSmbFileShareRequest(")
        append("accessBasedEnumeration=$accessBasedEnumeration,")
        append("adminUserList=$adminUserList,")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("caseSensitivity=$caseSensitivity,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("fileShareArn=$fileShareArn,")
        append("fileShareName=$fileShareName,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("invalidUserList=$invalidUserList,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("oplocksEnabled=$oplocksEnabled,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("smbaclEnabled=$smbaclEnabled,")
        append("validUserList=$validUserList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessBasedEnumeration?.hashCode() ?: 0
        result = 31 * result + (adminUserList?.hashCode() ?: 0)
        result = 31 * result + (auditDestinationArn?.hashCode() ?: 0)
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (caseSensitivity?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (invalidUserList?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (oplocksEnabled?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (smbaclEnabled?.hashCode() ?: 0)
        result = 31 * result + (validUserList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSmbFileShareRequest

        if (accessBasedEnumeration != other.accessBasedEnumeration) return false
        if (adminUserList != other.adminUserList) return false
        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (caseSensitivity != other.caseSensitivity) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (fileShareArn != other.fileShareArn) return false
        if (fileShareName != other.fileShareName) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (invalidUserList != other.invalidUserList) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (oplocksEnabled != other.oplocksEnabled) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (smbaclEnabled != other.smbaclEnabled) return false
        if (validUserList != other.validUserList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The files and folders on this share will only be visible to users with read access.
         */
        public var accessBasedEnumeration: kotlin.Boolean? = null
        /**
         * A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
         */
        public var adminUserList: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        public var auditDestinationArn: kotlin.String? = null
        /**
         * Specifies refresh cache information for the file share.
         */
        public var cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = null
        /**
         * The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
         */
        public var caseSensitivity: aws.sdk.kotlin.services.storagegateway.model.CaseSensitivity? = null
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
         *
         * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
         */
        public var defaultStorageClass: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * The name of the file share. Optional.
         *
         * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
         */
        public var fileShareName: kotlin.String? = null
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
         *
         * Valid Values: `true` | `false`
         */
        public var guessMimeTypeEnabled: kotlin.Boolean? = null
        /**
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
         */
        public var invalidUserList: List<String>? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
         *
         * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
         *
         * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
         *
         * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
         *
         * The following example sets `NotificationPolicy` off.
         *
         * `{}`
         */
        public var notificationPolicy: kotlin.String? = null
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
         */
        public var objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = null
        /**
         * Specifies whether opportunistic locking is enabled for the SMB file share.
         *
         * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.
         *
         * Valid Values: `true` | `false`
         */
        public var oplocksEnabled: kotlin.Boolean? = null
        /**
         * A value that sets the write status of a file share. Set this value to `true` to set write status to read-only, otherwise set to `false`.
         *
         * Valid Values: `true` | `false`
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
         *
         * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
         *
         * Valid Values: `true` | `false`
         */
        public var requesterPays: kotlin.Boolean? = null
        /**
         * Set this value to `true` to enable access control list (ACL) on the SMB file share. Set it to `false` to map file and directory permissions to the POSIX permissions.
         *
         * For more information, see [Using Microsoft Windows ACLs to control access to an SMB file share](https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html) in the *Storage Gateway User Guide*.
         *
         * Valid Values: `true` | `false`
         */
        public var smbaclEnabled: kotlin.Boolean? = null
        /**
         * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: `DOMAIN\User1`, `user1`, `@group1`, and `@DOMAIN\group1`. Can only be set if Authentication is set to `ActiveDirectory`.
         */
        public var validUserList: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareRequest) : this() {
            this.accessBasedEnumeration = x.accessBasedEnumeration
            this.adminUserList = x.adminUserList
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.caseSensitivity = x.caseSensitivity
            this.defaultStorageClass = x.defaultStorageClass
            this.fileShareArn = x.fileShareArn
            this.fileShareName = x.fileShareName
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.invalidUserList = x.invalidUserList
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.oplocksEnabled = x.oplocksEnabled
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.smbaclEnabled = x.smbaclEnabled
            this.validUserList = x.validUserList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.UpdateSmbFileShareRequest = UpdateSmbFileShareRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        public fun cacheAttributes(block: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.Builder.() -> kotlin.Unit) {
            this.cacheAttributes = aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
