// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a custom tape pool.
 */
public class PoolInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the custom tape pool. Use the ListTapePools operation to return a list of custom tape pools for your account and Amazon Web Services Region.
     */
    public val poolArn: kotlin.String? = builder.poolArn
    /**
     * The name of the custom tape pool. `PoolName` can use all ASCII characters, except '/' and '\'.
     */
    public val poolName: kotlin.String? = builder.poolName
    /**
     * Status of the custom tape pool. Pool can be `ACTIVE` or `DELETED`.
     */
    public val poolStatus: aws.sdk.kotlin.services.storagegateway.model.PoolStatus? = builder.poolStatus
    /**
     * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).
     */
    public val retentionLockTimeInDays: kotlin.Int? = builder.retentionLockTimeInDays
    /**
     * Tape retention lock type, which can be configured in two modes. When configured in governance mode, Amazon Web Services accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root Amazon Web Services account.
     */
    public val retentionLockType: aws.sdk.kotlin.services.storagegateway.model.RetentionLockType? = builder.retentionLockType
    /**
     * The storage class that is associated with the custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public val storageClass: aws.sdk.kotlin.services.storagegateway.model.TapeStorageClass? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.PoolInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PoolInfo(")
        append("poolArn=$poolArn,")
        append("poolName=$poolName,")
        append("poolStatus=$poolStatus,")
        append("retentionLockTimeInDays=$retentionLockTimeInDays,")
        append("retentionLockType=$retentionLockType,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = poolArn?.hashCode() ?: 0
        result = 31 * result + (poolName?.hashCode() ?: 0)
        result = 31 * result + (poolStatus?.hashCode() ?: 0)
        result = 31 * result + (retentionLockTimeInDays ?: 0)
        result = 31 * result + (retentionLockType?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PoolInfo

        if (poolArn != other.poolArn) return false
        if (poolName != other.poolName) return false
        if (poolStatus != other.poolStatus) return false
        if (retentionLockTimeInDays != other.retentionLockTimeInDays) return false
        if (retentionLockType != other.retentionLockType) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.PoolInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the custom tape pool. Use the ListTapePools operation to return a list of custom tape pools for your account and Amazon Web Services Region.
         */
        public var poolArn: kotlin.String? = null
        /**
         * The name of the custom tape pool. `PoolName` can use all ASCII characters, except '/' and '\'.
         */
        public var poolName: kotlin.String? = null
        /**
         * Status of the custom tape pool. Pool can be `ACTIVE` or `DELETED`.
         */
        public var poolStatus: aws.sdk.kotlin.services.storagegateway.model.PoolStatus? = null
        /**
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).
         */
        public var retentionLockTimeInDays: kotlin.Int? = null
        /**
         * Tape retention lock type, which can be configured in two modes. When configured in governance mode, Amazon Web Services accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root Amazon Web Services account.
         */
        public var retentionLockType: aws.sdk.kotlin.services.storagegateway.model.RetentionLockType? = null
        /**
         * The storage class that is associated with the custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        public var storageClass: aws.sdk.kotlin.services.storagegateway.model.TapeStorageClass? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.PoolInfo) : this() {
            this.poolArn = x.poolArn
            this.poolName = x.poolName
            this.poolStatus = x.poolStatus
            this.retentionLockTimeInDays = x.retentionLockTimeInDays
            this.retentionLockType = x.retentionLockType
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.PoolInfo = PoolInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
