// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a file share. Only supported S3 File Gateway.
 */
public class FileShareInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the file share.
     */
    public val fileShareArn: kotlin.String? = builder.fileShareArn
    /**
     * The ID of the file share.
     */
    public val fileShareId: kotlin.String? = builder.fileShareId
    /**
     * The status of the file share.
     *
     * Valid Values: `CREATING` | `UPDATING` | `AVAILABLE` | `DELETING`
     */
    public val fileShareStatus: kotlin.String? = builder.fileShareStatus
    /**
     * The type of the file share.
     */
    public val fileShareType: aws.sdk.kotlin.services.storagegateway.model.FileShareType? = builder.fileShareType
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.FileShareInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileShareInfo(")
        append("fileShareArn=$fileShareArn,")
        append("fileShareId=$fileShareId,")
        append("fileShareStatus=$fileShareStatus,")
        append("fileShareType=$fileShareType,")
        append("gatewayArn=$gatewayArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileShareArn?.hashCode() ?: 0
        result = 31 * result + (fileShareId?.hashCode() ?: 0)
        result = 31 * result + (fileShareStatus?.hashCode() ?: 0)
        result = 31 * result + (fileShareType?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileShareInfo

        if (fileShareArn != other.fileShareArn) return false
        if (fileShareId != other.fileShareId) return false
        if (fileShareStatus != other.fileShareStatus) return false
        if (fileShareType != other.fileShareType) return false
        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.FileShareInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the file share.
         */
        public var fileShareArn: kotlin.String? = null
        /**
         * The ID of the file share.
         */
        public var fileShareId: kotlin.String? = null
        /**
         * The status of the file share.
         *
         * Valid Values: `CREATING` | `UPDATING` | `AVAILABLE` | `DELETING`
         */
        public var fileShareStatus: kotlin.String? = null
        /**
         * The type of the file share.
         */
        public var fileShareType: aws.sdk.kotlin.services.storagegateway.model.FileShareType? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.FileShareInfo) : this() {
            this.fileShareArn = x.fileShareArn
            this.fileShareId = x.fileShareId
            this.fileShareStatus = x.fileShareStatus
            this.fileShareType = x.fileShareType
            this.gatewayArn = x.gatewayArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.FileShareInfo = FileShareInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
