// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeCacheResponse private constructor(builder: Builder) {
    /**
     * The amount of cache in bytes allocated to a gateway.
     */
    public val cacheAllocatedInBytes: kotlin.Long = builder.cacheAllocatedInBytes
    /**
     * The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.
     */
    public val cacheDirtyPercentage: kotlin.Double = builder.cacheDirtyPercentage
    /**
     * Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.
     */
    public val cacheHitPercentage: kotlin.Double = builder.cacheHitPercentage
    /**
     * Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.
     */
    public val cacheMissPercentage: kotlin.Double = builder.cacheMissPercentage
    /**
     * Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.
     */
    public val cacheUsedPercentage: kotlin.Double = builder.cacheUsedPercentage
    /**
     * An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the ListLocalDisks API.
     */
    public val diskIds: List<String>? = builder.diskIds
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.DescribeCacheResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCacheResponse(")
        append("cacheAllocatedInBytes=$cacheAllocatedInBytes,")
        append("cacheDirtyPercentage=$cacheDirtyPercentage,")
        append("cacheHitPercentage=$cacheHitPercentage,")
        append("cacheMissPercentage=$cacheMissPercentage,")
        append("cacheUsedPercentage=$cacheUsedPercentage,")
        append("diskIds=$diskIds,")
        append("gatewayArn=$gatewayArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheAllocatedInBytes.hashCode()
        result = 31 * result + (cacheDirtyPercentage.hashCode())
        result = 31 * result + (cacheHitPercentage.hashCode())
        result = 31 * result + (cacheMissPercentage.hashCode())
        result = 31 * result + (cacheUsedPercentage.hashCode())
        result = 31 * result + (diskIds?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCacheResponse

        if (cacheAllocatedInBytes != other.cacheAllocatedInBytes) return false
        if (cacheDirtyPercentage != other.cacheDirtyPercentage) return false
        if (cacheHitPercentage != other.cacheHitPercentage) return false
        if (cacheMissPercentage != other.cacheMissPercentage) return false
        if (cacheUsedPercentage != other.cacheUsedPercentage) return false
        if (diskIds != other.diskIds) return false
        if (gatewayArn != other.gatewayArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.DescribeCacheResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of cache in bytes allocated to a gateway.
         */
        public var cacheAllocatedInBytes: kotlin.Long = 0L
        /**
         * The file share's contribution to the overall percentage of the gateway's cache that has not been persisted to Amazon Web Services. The sample is taken at the end of the reporting period.
         */
        public var cacheDirtyPercentage: kotlin.Double = 0.0
        /**
         * Percent of application read operations from the file shares that are served from cache. The sample is taken at the end of the reporting period.
         */
        public var cacheHitPercentage: kotlin.Double = 0.0
        /**
         * Percent of application read operations from the file shares that are not served from cache. The sample is taken at the end of the reporting period.
         */
        public var cacheMissPercentage: kotlin.Double = 0.0
        /**
         * Percent use of the gateway's cache storage. This metric applies only to the gateway-cached volume setup. The sample is taken at the end of the reporting period.
         */
        public var cacheUsedPercentage: kotlin.Double = 0.0
        /**
         * An array of strings that identify disks that are to be configured as working storage. Each string has a minimum length of 1 and maximum length of 300. You can get the disk IDs from the ListLocalDisks API.
         */
        public var diskIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.DescribeCacheResponse) : this() {
            this.cacheAllocatedInBytes = x.cacheAllocatedInBytes
            this.cacheDirtyPercentage = x.cacheDirtyPercentage
            this.cacheHitPercentage = x.cacheHitPercentage
            this.cacheMissPercentage = x.cacheMissPercentage
            this.cacheUsedPercentage = x.cacheUsedPercentage
            this.diskIds = x.diskIds
            this.gatewayArn = x.gatewayArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.DescribeCacheResponse = DescribeCacheResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
