// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The refresh cache information for the file share or FSx file systems.
 */
public class CacheAttributes private constructor(builder: Builder) {
    /**
     * Refreshes a file share's cache by using Time To Live (TTL). TTL is the length of time since the last refresh after which access to the directory would cause the file gateway to first refresh that directory's contents from the Amazon S3 bucket or Amazon FSx file system. The TTL duration is in seconds.
     *
     * Valid Values:0, 300 to 2,592,000 seconds (5 minutes to 30 days)
     */
    public val cacheStaleTimeoutInSeconds: kotlin.Int? = builder.cacheStaleTimeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CacheAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheAttributes(")
        append("cacheStaleTimeoutInSeconds=$cacheStaleTimeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheStaleTimeoutInSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheAttributes

        if (cacheStaleTimeoutInSeconds != other.cacheStaleTimeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CacheAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Refreshes a file share's cache by using Time To Live (TTL). TTL is the length of time since the last refresh after which access to the directory would cause the file gateway to first refresh that directory's contents from the Amazon S3 bucket or Amazon FSx file system. The TTL duration is in seconds.
         *
         * Valid Values:0, 300 to 2,592,000 seconds (5 minutes to 30 days)
         */
        public var cacheStaleTimeoutInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes) : this() {
            this.cacheStaleTimeoutInSeconds = x.cacheStaleTimeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CacheAttributes = CacheAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
