// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.serde

import aws.sdk.kotlin.services.storagegateway.model.ActiveDirectoryStatus
import aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsResponse
import aws.sdk.kotlin.services.storagegateway.model.SmbLocalGroups
import aws.sdk.kotlin.services.storagegateway.model.SmbSecurityStrategy
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeSMBSettingsOperationDeserializer: HttpDeserialize<DescribeSmbSettingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeSmbSettingsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeSmbSettingsError(context, call)
        }
        val builder = DescribeSmbSettingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSMBSettingsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeSmbSettingsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSMBSettingsOperationBody(builder: DescribeSmbSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVEDIRECTORYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ActiveDirectoryStatus"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val FILESHARESVISIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("FileSharesVisible"))
    val GATEWAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GatewayARN"))
    val SMBGUESTPASSWORDSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SMBGuestPasswordSet"))
    val SMBLOCALGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SMBLocalGroups"))
    val SMBSECURITYSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SMBSecurityStrategy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVEDIRECTORYSTATUS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(FILESHARESVISIBLE_DESCRIPTOR)
        field(GATEWAYARN_DESCRIPTOR)
        field(SMBGUESTPASSWORDSET_DESCRIPTOR)
        field(SMBLOCALGROUPS_DESCRIPTOR)
        field(SMBSECURITYSTRATEGY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVEDIRECTORYSTATUS_DESCRIPTOR.index -> builder.activeDirectoryStatus = deserializeString().let { ActiveDirectoryStatus.fromValue(it) }
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                FILESHARESVISIBLE_DESCRIPTOR.index -> builder.fileSharesVisible = deserializeBoolean()
                GATEWAYARN_DESCRIPTOR.index -> builder.gatewayArn = deserializeString()
                SMBGUESTPASSWORDSET_DESCRIPTOR.index -> builder.smbGuestPasswordSet = deserializeBoolean()
                SMBLOCALGROUPS_DESCRIPTOR.index -> builder.smbLocalGroups = deserializeSmbLocalGroupsDocument(deserializer)
                SMBSECURITYSTRATEGY_DESCRIPTOR.index -> builder.smbSecurityStrategy = deserializeString().let { SmbSecurityStrategy.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
