// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a recovery point.
 */
public class TapeRecoveryPointInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the virtual tape.
     */
    public val tapeArn: kotlin.String? = builder.tapeArn
    /**
     * The time when the point-in-time view of the virtual tape was replicated for later recovery.
     *
     * The default timestamp format of the tape recovery point time is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
     */
    public val tapeRecoveryPointTime: aws.smithy.kotlin.runtime.time.Instant? = builder.tapeRecoveryPointTime
    /**
     * The size, in bytes, of the virtual tapes to recover.
     */
    public val tapeSizeInBytes: kotlin.Long? = builder.tapeSizeInBytes
    /**
     * The status of the virtual tapes.
     */
    public val tapeStatus: kotlin.String? = builder.tapeStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.TapeRecoveryPointInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TapeRecoveryPointInfo(")
        append("tapeArn=$tapeArn,")
        append("tapeRecoveryPointTime=$tapeRecoveryPointTime,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("tapeStatus=$tapeStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = tapeArn?.hashCode() ?: 0
        result = 31 * result + (tapeRecoveryPointTime?.hashCode() ?: 0)
        result = 31 * result + (tapeSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tapeStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TapeRecoveryPointInfo

        if (tapeArn != other.tapeArn) return false
        if (tapeRecoveryPointTime != other.tapeRecoveryPointTime) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (tapeStatus != other.tapeStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.TapeRecoveryPointInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the virtual tape.
         */
        public var tapeArn: kotlin.String? = null
        /**
         * The time when the point-in-time view of the virtual tape was replicated for later recovery.
         *
         * The default timestamp format of the tape recovery point time is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
         */
        public var tapeRecoveryPointTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size, in bytes, of the virtual tapes to recover.
         */
        public var tapeSizeInBytes: kotlin.Long? = null
        /**
         * The status of the virtual tapes.
         */
        public var tapeStatus: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.TapeRecoveryPointInfo) : this() {
            this.tapeArn = x.tapeArn
            this.tapeRecoveryPointTime = x.tapeRecoveryPointTime
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.tapeStatus = x.tapeStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.TapeRecoveryPointInfo = TapeRecoveryPointInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
