// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



public class CreateTapePoolRequest private constructor(builder: Builder) {
    /**
     * The name of the new custom tape pool.
     */
    public val poolName: kotlin.String? = builder.poolName
    /**
     * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).
     */
    public val retentionLockTimeInDays: kotlin.Int? = builder.retentionLockTimeInDays
    /**
     * Tape retention lock can be configured in two modes. When configured in governance mode, Amazon Web Services accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root Amazon Web Services account.
     */
    public val retentionLockType: aws.sdk.kotlin.services.storagegateway.model.RetentionLockType? = builder.retentionLockType
    /**
     * The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public val storageClass: aws.sdk.kotlin.services.storagegateway.model.TapeStorageClass? = builder.storageClass
    /**
     * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CreateTapePoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTapePoolRequest(")
        append("poolName=$poolName,")
        append("retentionLockTimeInDays=$retentionLockTimeInDays,")
        append("retentionLockType=$retentionLockType,")
        append("storageClass=$storageClass,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = poolName?.hashCode() ?: 0
        result = 31 * result + (retentionLockTimeInDays ?: 0)
        result = 31 * result + (retentionLockType?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTapePoolRequest

        if (poolName != other.poolName) return false
        if (retentionLockTimeInDays != other.retentionLockTimeInDays) return false
        if (retentionLockType != other.retentionLockType) return false
        if (storageClass != other.storageClass) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CreateTapePoolRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the new custom tape pool.
         */
        public var poolName: kotlin.String? = null
        /**
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).
         */
        public var retentionLockTimeInDays: kotlin.Int? = null
        /**
         * Tape retention lock can be configured in two modes. When configured in governance mode, Amazon Web Services accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root Amazon Web Services account.
         */
        public var retentionLockType: aws.sdk.kotlin.services.storagegateway.model.RetentionLockType? = null
        /**
         * The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        public var storageClass: aws.sdk.kotlin.services.storagegateway.model.TapeStorageClass? = null
        /**
         * A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CreateTapePoolRequest) : this() {
            this.poolName = x.poolName
            this.retentionLockTimeInDays = x.retentionLockTimeInDays
            this.retentionLockType = x.retentionLockType
            this.storageClass = x.storageClass
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CreateTapePoolRequest = CreateTapePoolRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
