// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * An automatic tape creation policy consists of automatic tape creation rules where each rule defines when and how to create new tapes. For more information about automatic tape creation, see [Creating Tapes Automatically](https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically).
 */
public class AutomaticTapeCreationRule private constructor(builder: Builder) {
    /**
     * The minimum number of available virtual tapes that the gateway maintains at all times. If the number of tapes on the gateway goes below this value, the gateway creates as many new tapes as are needed to have `MinimumNumTapes` on the gateway. For more information about automatic tape creation, see [Creating Tapes Automatically](https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically).
     */
    public val minimumNumTapes: kotlin.Int = requireNotNull(builder.minimumNumTapes) { "A non-null value must be provided for minimumNumTapes" }
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the Amazon S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public val poolId: kotlin.String = requireNotNull(builder.poolId) { "A non-null value must be provided for poolId" }
    /**
     * A prefix that you append to the barcode of the virtual tape that you are creating. This prefix makes the barcode unique.
     *
     * The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
     */
    public val tapeBarcodePrefix: kotlin.String = requireNotNull(builder.tapeBarcodePrefix) { "A non-null value must be provided for tapeBarcodePrefix" }
    /**
     * The size, in bytes, of the virtual tape capacity.
     */
    public val tapeSizeInBytes: kotlin.Long = requireNotNull(builder.tapeSizeInBytes) { "A non-null value must be provided for tapeSizeInBytes" }
    /**
     * Set to `true` to indicate that tapes are to be archived as write-once-read-many (WORM). Set to `false` when WORM is not enabled for tapes.
     */
    public val worm: kotlin.Boolean = builder.worm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.AutomaticTapeCreationRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomaticTapeCreationRule(")
        append("minimumNumTapes=$minimumNumTapes,")
        append("poolId=$poolId,")
        append("tapeBarcodePrefix=$tapeBarcodePrefix,")
        append("tapeSizeInBytes=$tapeSizeInBytes,")
        append("worm=$worm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = minimumNumTapes
        result = 31 * result + (poolId.hashCode())
        result = 31 * result + (tapeBarcodePrefix.hashCode())
        result = 31 * result + (tapeSizeInBytes.hashCode())
        result = 31 * result + (worm.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomaticTapeCreationRule

        if (minimumNumTapes != other.minimumNumTapes) return false
        if (poolId != other.poolId) return false
        if (tapeBarcodePrefix != other.tapeBarcodePrefix) return false
        if (tapeSizeInBytes != other.tapeSizeInBytes) return false
        if (worm != other.worm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.AutomaticTapeCreationRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The minimum number of available virtual tapes that the gateway maintains at all times. If the number of tapes on the gateway goes below this value, the gateway creates as many new tapes as are needed to have `MinimumNumTapes` on the gateway. For more information about automatic tape creation, see [Creating Tapes Automatically](https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically).
         */
        public var minimumNumTapes: kotlin.Int? = null
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the Amazon S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * A prefix that you append to the barcode of the virtual tape that you are creating. This prefix makes the barcode unique.
         *
         * The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
         */
        public var tapeBarcodePrefix: kotlin.String? = null
        /**
         * The size, in bytes, of the virtual tape capacity.
         */
        public var tapeSizeInBytes: kotlin.Long? = null
        /**
         * Set to `true` to indicate that tapes are to be archived as write-once-read-many (WORM). Set to `false` when WORM is not enabled for tapes.
         */
        public var worm: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.AutomaticTapeCreationRule) : this() {
            this.minimumNumTapes = x.minimumNumTapes
            this.poolId = x.poolId
            this.tapeBarcodePrefix = x.tapeBarcodePrefix
            this.tapeSizeInBytes = x.tapeSizeInBytes
            this.worm = x.worm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.AutomaticTapeCreationRule = AutomaticTapeCreationRule(this)

        internal fun correctErrors(): Builder {
            if (minimumNumTapes == null) minimumNumTapes = 0
            if (poolId == null) poolId = ""
            if (tapeBarcodePrefix == null) tapeBarcodePrefix = ""
            if (tapeSizeInBytes == null) tapeSizeInBytes = 0L
            return this
        }
    }
}
