// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



public class AssignTapePoolRequest private constructor(builder: Builder) {
    /**
     * Set permissions to bypass governance retention. If the lock type of the archived tape is `Governance`, the tape's archived age is not older than `RetentionLockInDays`, and the user does not already have `BypassGovernanceRetention`, setting this to TRUE enables the user to bypass the retention lock. This parameter is set to true by default for calls from the console.
     *
     * Valid values: `TRUE` | `FALSE`
     */
    public val bypassGovernanceRetention: kotlin.Boolean? = builder.bypassGovernanceRetention
    /**
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     */
    public val poolId: kotlin.String? = builder.poolId
    /**
     * The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.
     */
    public val tapeArn: kotlin.String? = builder.tapeArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.AssignTapePoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssignTapePoolRequest(")
        append("bypassGovernanceRetention=$bypassGovernanceRetention,")
        append("poolId=$poolId,")
        append("tapeArn=$tapeArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassGovernanceRetention?.hashCode() ?: 0
        result = 31 * result + (poolId?.hashCode() ?: 0)
        result = 31 * result + (tapeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssignTapePoolRequest

        if (bypassGovernanceRetention != other.bypassGovernanceRetention) return false
        if (poolId != other.poolId) return false
        if (tapeArn != other.tapeArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.AssignTapePoolRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set permissions to bypass governance retention. If the lock type of the archived tape is `Governance`, the tape's archived age is not older than `RetentionLockInDays`, and the user does not already have `BypassGovernanceRetention`, setting this to TRUE enables the user to bypass the retention lock. This parameter is set to true by default for calls from the console.
         *
         * Valid values: `TRUE` | `FALSE`
         */
        public var bypassGovernanceRetention: kotlin.Boolean? = null
        /**
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.
         */
        public var tapeArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.AssignTapePoolRequest) : this() {
            this.bypassGovernanceRetention = x.bypassGovernanceRetention
            this.poolId = x.poolId
            this.tapeArn = x.tapeArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.AssignTapePoolRequest = AssignTapePoolRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
