// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.serde

import aws.sdk.kotlin.services.storagegateway.model.DescribeNfsFileSharesResponse
import aws.sdk.kotlin.services.storagegateway.model.NfsFileShareInfo
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeNFSFileSharesOperationDeserializer: HttpDeserialize<DescribeNfsFileSharesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeNfsFileSharesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeNfsFileSharesError(context, call)
        }
        val builder = DescribeNfsFileSharesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeNFSFileSharesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeNfsFileSharesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw StorageGatewayException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> StorageGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeNFSFileSharesOperationBody(builder: DescribeNfsFileSharesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NFSFILESHAREINFOLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NFSFileShareInfoList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NFSFILESHAREINFOLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NFSFILESHAREINFOLIST_DESCRIPTOR.index -> builder.nfsFileShareInfoList =
                    deserializer.deserializeList(NFSFILESHAREINFOLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<NfsFileShareInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNfsFileShareInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
