// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.paginators

import aws.sdk.kotlin.services.storagegateway.StorageGatewayClient
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeArchivesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeArchivesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeRecoveryPointsRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapeRecoveryPointsResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeTapesResponse
import aws.sdk.kotlin.services.storagegateway.model.DescribeVtlDevicesRequest
import aws.sdk.kotlin.services.storagegateway.model.DescribeVtlDevicesResponse
import aws.sdk.kotlin.services.storagegateway.model.FileShareInfo
import aws.sdk.kotlin.services.storagegateway.model.FileSystemAssociationSummary
import aws.sdk.kotlin.services.storagegateway.model.GatewayInfo
import aws.sdk.kotlin.services.storagegateway.model.ListFileSharesRequest
import aws.sdk.kotlin.services.storagegateway.model.ListFileSharesResponse
import aws.sdk.kotlin.services.storagegateway.model.ListFileSystemAssociationsRequest
import aws.sdk.kotlin.services.storagegateway.model.ListFileSystemAssociationsResponse
import aws.sdk.kotlin.services.storagegateway.model.ListGatewaysRequest
import aws.sdk.kotlin.services.storagegateway.model.ListGatewaysResponse
import aws.sdk.kotlin.services.storagegateway.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.storagegateway.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.storagegateway.model.ListTapePoolsRequest
import aws.sdk.kotlin.services.storagegateway.model.ListTapePoolsResponse
import aws.sdk.kotlin.services.storagegateway.model.ListTapesRequest
import aws.sdk.kotlin.services.storagegateway.model.ListTapesResponse
import aws.sdk.kotlin.services.storagegateway.model.ListVolumesRequest
import aws.sdk.kotlin.services.storagegateway.model.ListVolumesResponse
import aws.sdk.kotlin.services.storagegateway.model.PoolInfo
import aws.sdk.kotlin.services.storagegateway.model.Tag
import aws.sdk.kotlin.services.storagegateway.model.Tape
import aws.sdk.kotlin.services.storagegateway.model.TapeArchive
import aws.sdk.kotlin.services.storagegateway.model.TapeInfo
import aws.sdk.kotlin.services.storagegateway.model.TapeRecoveryPointInfo
import aws.sdk.kotlin.services.storagegateway.model.VolumeInfo
import aws.sdk.kotlin.services.storagegateway.model.VtlDevice
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeTapeArchivesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTapeArchivesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTapeArchivesResponse]
 */
public fun StorageGatewayClient.describeTapeArchivesPaginated(initialRequest: DescribeTapeArchivesRequest = DescribeTapeArchivesRequest { }): Flow<DescribeTapeArchivesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTapeArchivesPaginated.describeTapeArchives(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTapeArchivesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTapeArchivesResponse]
 */
public fun StorageGatewayClient.describeTapeArchivesPaginated(block: DescribeTapeArchivesRequest.Builder.() -> Unit): Flow<DescribeTapeArchivesResponse> =
    describeTapeArchivesPaginated(DescribeTapeArchivesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTapeArchivesPaginated]
 * to access the nested member [TapeArchive]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TapeArchive]
 */
@JvmName("describeTapeArchivesResponseTapeArchive")
public fun Flow<DescribeTapeArchivesResponse>.tapeArchives(): Flow<TapeArchive> =
    transform() { response ->
        response.tapeArchives?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTapeRecoveryPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTapeRecoveryPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTapeRecoveryPointsResponse]
 */
public fun StorageGatewayClient.describeTapeRecoveryPointsPaginated(initialRequest: DescribeTapeRecoveryPointsRequest): Flow<DescribeTapeRecoveryPointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTapeRecoveryPointsPaginated.describeTapeRecoveryPoints(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTapeRecoveryPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTapeRecoveryPointsResponse]
 */
public fun StorageGatewayClient.describeTapeRecoveryPointsPaginated(block: DescribeTapeRecoveryPointsRequest.Builder.() -> Unit): Flow<DescribeTapeRecoveryPointsResponse> =
    describeTapeRecoveryPointsPaginated(DescribeTapeRecoveryPointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTapeRecoveryPointsPaginated]
 * to access the nested member [TapeRecoveryPointInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TapeRecoveryPointInfo]
 */
@JvmName("describeTapeRecoveryPointsResponseTapeRecoveryPointInfo")
public fun Flow<DescribeTapeRecoveryPointsResponse>.tapeRecoveryPointInfos(): Flow<TapeRecoveryPointInfo> =
    transform() { response ->
        response.tapeRecoveryPointInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTapesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTapesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTapesResponse]
 */
public fun StorageGatewayClient.describeTapesPaginated(initialRequest: DescribeTapesRequest): Flow<DescribeTapesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTapesPaginated.describeTapes(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTapesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTapesResponse]
 */
public fun StorageGatewayClient.describeTapesPaginated(block: DescribeTapesRequest.Builder.() -> Unit): Flow<DescribeTapesResponse> =
    describeTapesPaginated(DescribeTapesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTapesPaginated]
 * to access the nested member [Tape]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tape]
 */
@JvmName("describeTapesResponseTape")
public fun Flow<DescribeTapesResponse>.tapes(): Flow<Tape> =
    transform() { response ->
        response.tapes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeVtlDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeVtlDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeVtlDevicesResponse]
 */
public fun StorageGatewayClient.describeVtlDevicesPaginated(initialRequest: DescribeVtlDevicesRequest): Flow<DescribeVtlDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeVtlDevicesPaginated.describeVtlDevices(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeVtlDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeVtlDevicesResponse]
 */
public fun StorageGatewayClient.describeVtlDevicesPaginated(block: DescribeVtlDevicesRequest.Builder.() -> Unit): Flow<DescribeVtlDevicesResponse> =
    describeVtlDevicesPaginated(DescribeVtlDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeVtlDevicesPaginated]
 * to access the nested member [VtlDevice]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VtlDevice]
 */
@JvmName("describeVtlDevicesResponseVtlDevice")
public fun Flow<DescribeVtlDevicesResponse>.vtlDevices(): Flow<VtlDevice> =
    transform() { response ->
        response.vtlDevices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFileSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFileSharesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFileSharesResponse]
 */
public fun StorageGatewayClient.listFileSharesPaginated(initialRequest: ListFileSharesRequest = ListFileSharesRequest { }): Flow<ListFileSharesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listFileSharesPaginated.listFileShares(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFileSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFileSharesResponse]
 */
public fun StorageGatewayClient.listFileSharesPaginated(block: ListFileSharesRequest.Builder.() -> Unit): Flow<ListFileSharesResponse> =
    listFileSharesPaginated(ListFileSharesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFileSharesPaginated]
 * to access the nested member [FileShareInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FileShareInfo]
 */
@JvmName("listFileSharesResponseFileShareInfo")
public fun Flow<ListFileSharesResponse>.fileShareInfoList(): Flow<FileShareInfo> =
    transform() { response ->
        response.fileShareInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFileSystemAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFileSystemAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFileSystemAssociationsResponse]
 */
public fun StorageGatewayClient.listFileSystemAssociationsPaginated(initialRequest: ListFileSystemAssociationsRequest = ListFileSystemAssociationsRequest { }): Flow<ListFileSystemAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listFileSystemAssociationsPaginated.listFileSystemAssociations(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFileSystemAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFileSystemAssociationsResponse]
 */
public fun StorageGatewayClient.listFileSystemAssociationsPaginated(block: ListFileSystemAssociationsRequest.Builder.() -> Unit): Flow<ListFileSystemAssociationsResponse> =
    listFileSystemAssociationsPaginated(ListFileSystemAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFileSystemAssociationsPaginated]
 * to access the nested member [FileSystemAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FileSystemAssociationSummary]
 */
@JvmName("listFileSystemAssociationsResponseFileSystemAssociationSummary")
public fun Flow<ListFileSystemAssociationsResponse>.fileSystemAssociationSummaryList(): Flow<FileSystemAssociationSummary> =
    transform() { response ->
        response.fileSystemAssociationSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGatewaysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewaysResponse]
 */
public fun StorageGatewayClient.listGatewaysPaginated(initialRequest: ListGatewaysRequest = ListGatewaysRequest { }): Flow<ListGatewaysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listGatewaysPaginated.listGateways(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGatewaysResponse]
 */
public fun StorageGatewayClient.listGatewaysPaginated(block: ListGatewaysRequest.Builder.() -> Unit): Flow<ListGatewaysResponse> =
    listGatewaysPaginated(ListGatewaysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGatewaysPaginated]
 * to access the nested member [GatewayInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GatewayInfo]
 */
@JvmName("listGatewaysResponseGatewayInfo")
public fun Flow<ListGatewaysResponse>.gateways(): Flow<GatewayInfo> =
    transform() { response ->
        response.gateways?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun StorageGatewayClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun StorageGatewayClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTapePoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTapePoolsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTapePoolsResponse]
 */
public fun StorageGatewayClient.listTapePoolsPaginated(initialRequest: ListTapePoolsRequest = ListTapePoolsRequest { }): Flow<ListTapePoolsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listTapePoolsPaginated.listTapePools(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTapePoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTapePoolsResponse]
 */
public fun StorageGatewayClient.listTapePoolsPaginated(block: ListTapePoolsRequest.Builder.() -> Unit): Flow<ListTapePoolsResponse> =
    listTapePoolsPaginated(ListTapePoolsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTapePoolsPaginated]
 * to access the nested member [PoolInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PoolInfo]
 */
@JvmName("listTapePoolsResponsePoolInfo")
public fun Flow<ListTapePoolsResponse>.poolInfos(): Flow<PoolInfo> =
    transform() { response ->
        response.poolInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTapesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTapesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTapesResponse]
 */
public fun StorageGatewayClient.listTapesPaginated(initialRequest: ListTapesRequest = ListTapesRequest { }): Flow<ListTapesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listTapesPaginated.listTapes(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTapesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTapesResponse]
 */
public fun StorageGatewayClient.listTapesPaginated(block: ListTapesRequest.Builder.() -> Unit): Flow<ListTapesResponse> =
    listTapesPaginated(ListTapesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTapesPaginated]
 * to access the nested member [TapeInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TapeInfo]
 */
@JvmName("listTapesResponseTapeInfo")
public fun Flow<ListTapesResponse>.tapeInfos(): Flow<TapeInfo> =
    transform() { response ->
        response.tapeInfos?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVolumesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVolumesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVolumesResponse]
 */
public fun StorageGatewayClient.listVolumesPaginated(initialRequest: ListVolumesRequest = ListVolumesRequest { }): Flow<ListVolumesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listVolumesPaginated.listVolumes(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVolumesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVolumesResponse]
 */
public fun StorageGatewayClient.listVolumesPaginated(block: ListVolumesRequest.Builder.() -> Unit): Flow<ListVolumesResponse> =
    listVolumesPaginated(ListVolumesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVolumesPaginated]
 * to access the nested member [VolumeInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VolumeInfo]
 */
@JvmName("listVolumesResponseVolumeInfo")
public fun Flow<ListVolumesResponse>.volumeInfos(): Flow<VolumeInfo> =
    transform() { response ->
        response.volumeInfos?.forEach {
            emit(it)
        }
    }
