// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



public class DescribeSmbSettingsResponse private constructor(builder: Builder) {
    /**
     * Indicates the status of a gateway that is a member of the Active Directory domain.
     * + `ACCESS_DENIED`: Indicates that the `JoinDomain` operation failed due to an authentication error.
     * + `DETACHED`: Indicates that gateway is not joined to a domain.
     * + `JOINED`: Indicates that the gateway has successfully joined a domain.
     * + `JOINING`: Indicates that a `JoinDomain` operation is in progress.
     * + `NETWORK_ERROR`: Indicates that `JoinDomain` operation failed due to a network or connectivity error.
     * + `TIMEOUT`: Indicates that the `JoinDomain` operation failed because the operation didn't complete within the allotted time.
     * + `UNKNOWN_ERROR`: Indicates that the `JoinDomain` operation failed due to another type of error.
     */
    public val activeDirectoryStatus: aws.sdk.kotlin.services.storagegateway.model.ActiveDirectoryStatus? = builder.activeDirectoryStatus
    /**
     * The name of the domain that the gateway is joined to.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
     */
    public val fileSharesVisible: kotlin.Boolean? = builder.fileSharesVisible
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * This value is `true` if a password for the guest user `smbguest` is set, otherwise `false`. Only supported for S3 File Gateways.
     *
     * Valid Values: `true` | `false`
     */
    public val smbGuestPasswordSet: kotlin.Boolean? = builder.smbGuestPasswordSet
    /**
     * A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
     */
    public val smbLocalGroups: aws.sdk.kotlin.services.storagegateway.model.SmbLocalGroups? = builder.smbLocalGroups
    /**
     * The type of security strategy that was specified for file gateway.
     * + `ClientSpecified`: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.
     * + `MandatorySigning`: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.
     * + `MandatoryEncryption`: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
     */
    public val smbSecurityStrategy: aws.sdk.kotlin.services.storagegateway.model.SmbSecurityStrategy? = builder.smbSecurityStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSmbSettingsResponse(")
        append("activeDirectoryStatus=$activeDirectoryStatus,")
        append("domainName=$domainName,")
        append("fileSharesVisible=$fileSharesVisible,")
        append("gatewayArn=$gatewayArn,")
        append("smbGuestPasswordSet=$smbGuestPasswordSet,")
        append("smbLocalGroups=$smbLocalGroups,")
        append("smbSecurityStrategy=$smbSecurityStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryStatus?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (fileSharesVisible?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (smbGuestPasswordSet?.hashCode() ?: 0)
        result = 31 * result + (smbLocalGroups?.hashCode() ?: 0)
        result = 31 * result + (smbSecurityStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSmbSettingsResponse

        if (activeDirectoryStatus != other.activeDirectoryStatus) return false
        if (domainName != other.domainName) return false
        if (fileSharesVisible != other.fileSharesVisible) return false
        if (gatewayArn != other.gatewayArn) return false
        if (smbGuestPasswordSet != other.smbGuestPasswordSet) return false
        if (smbLocalGroups != other.smbLocalGroups) return false
        if (smbSecurityStrategy != other.smbSecurityStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the status of a gateway that is a member of the Active Directory domain.
         * + `ACCESS_DENIED`: Indicates that the `JoinDomain` operation failed due to an authentication error.
         * + `DETACHED`: Indicates that gateway is not joined to a domain.
         * + `JOINED`: Indicates that the gateway has successfully joined a domain.
         * + `JOINING`: Indicates that a `JoinDomain` operation is in progress.
         * + `NETWORK_ERROR`: Indicates that `JoinDomain` operation failed due to a network or connectivity error.
         * + `TIMEOUT`: Indicates that the `JoinDomain` operation failed because the operation didn't complete within the allotted time.
         * + `UNKNOWN_ERROR`: Indicates that the `JoinDomain` operation failed due to another type of error.
         */
        public var activeDirectoryStatus: aws.sdk.kotlin.services.storagegateway.model.ActiveDirectoryStatus? = null
        /**
         * The name of the domain that the gateway is joined to.
         */
        public var domainName: kotlin.String? = null
        /**
         * The shares on this gateway appear when listing shares. Only supported for S3 File Gateways.
         */
        public var fileSharesVisible: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * This value is `true` if a password for the guest user `smbguest` is set, otherwise `false`. Only supported for S3 File Gateways.
         *
         * Valid Values: `true` | `false`
         */
        public var smbGuestPasswordSet: kotlin.Boolean? = null
        /**
         * A list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
         */
        public var smbLocalGroups: aws.sdk.kotlin.services.storagegateway.model.SmbLocalGroups? = null
        /**
         * The type of security strategy that was specified for file gateway.
         * + `ClientSpecified`: If you use this option, requests are established based on what is negotiated by the client. This option is recommended when you want to maximize compatibility across different clients in your environment. Only supported for S3 File Gateways.
         * + `MandatorySigning`: If you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.
         * + `MandatoryEncryption`: If you use this option, file gateway only allows connections from SMBv3 clients that have encryption enabled. This option is highly recommended for environments that handle sensitive data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
         */
        public var smbSecurityStrategy: aws.sdk.kotlin.services.storagegateway.model.SmbSecurityStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsResponse) : this() {
            this.activeDirectoryStatus = x.activeDirectoryStatus
            this.domainName = x.domainName
            this.fileSharesVisible = x.fileSharesVisible
            this.gatewayArn = x.gatewayArn
            this.smbGuestPasswordSet = x.smbGuestPasswordSet
            this.smbLocalGroups = x.smbLocalGroups
            this.smbSecurityStrategy = x.smbSecurityStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.DescribeSmbSettingsResponse = DescribeSmbSettingsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.SmbLocalGroups] inside the given [block]
         */
        public fun smbLocalGroups(block: aws.sdk.kotlin.services.storagegateway.model.SmbLocalGroups.Builder.() -> kotlin.Unit) {
            this.smbLocalGroups = aws.sdk.kotlin.services.storagegateway.model.SmbLocalGroups.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
